/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server;

import java.io.IOException;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.server.MainCmdItem;
import org.eclipse.statet.rj.server.RjsStatus;

@NonNullByDefault
public final class MainCtrlCmdItem
extends MainCmdItem {
    public static final byte OP_FINISH_TASK = 2;
    private final byte op;

    public MainCtrlCmdItem(byte op, int options) {
        this.op = op;
        this.options = options | Integer.MIN_VALUE;
    }

    public MainCtrlCmdItem(RJIO in) throws IOException {
        this.requestId = in.readInt();
        this.options = in.readInt();
        this.op = in.readByte();
    }

    @Override
    public void writeExternal(RJIO out) throws IOException {
        out.writeInt(this.requestId);
        out.writeInt(this.options);
        out.writeByte(this.op);
    }

    @Override
    public byte getCmdType() {
        return 16;
    }

    @Override
    public byte getOp() {
        return this.op;
    }

    @Override
    public void setAnswer(RjsStatus status) {
        this.options = this.options & 0xF00FFFFF | status.getSeverity() << 20;
    }

    @Override
    public boolean isOK() {
        return (this.options & 0xF00000) == 0;
    }

    @Override
    public @Nullable RjsStatus getStatus() {
        return null;
    }

    @Override
    public @Nullable String getDataText() {
        return null;
    }

    @Override
    public byte @Nullable [] getDataTextUtf8() {
        return null;
    }

    @Override
    public boolean testEquals(MainCmdItem other) {
        if (other instanceof MainCtrlCmdItem) {
            MainCtrlCmdItem otherItem = (MainCtrlCmdItem)other;
            if (this.getOp() == otherItem.getOp() && this.options == otherItem.options) {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("MainCtrlCmdItem ");
        switch (this.op) {
            case 2: {
                sb.append("FINISH_TASK");
                break;
            }
            default: {
                sb.append(this.op);
            }
        }
        sb.append("\n\t").append("options= 0x").append(Integer.toHexString(this.options));
        return sb.toString();
    }
}

