/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.text;

import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.IDocumentPartitionerExtension3;
import org.eclipse.jface.text.ISynchronizable;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public abstract class PartitionerDocumentSetupParticipant
implements IDocumentSetupParticipant {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setup(IDocument document) {
        if (document instanceof IDocumentExtension3) {
            Object synch;
            Object object = synch = this.getLockObject(document);
            synchronized (object) {
                this.doSetup(document);
            }
        } else {
            throw new UnsupportedOperationException("IDocumentExtension3 required.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getLockObject(IDocument document) {
        Object synch;
        if (document instanceof ISynchronizable) {
            IDocument iDocument = document;
            synchronized (iDocument) {
                synch = ((ISynchronizable)document).getLockObject();
                if (synch == null) {
                    synch = new Object();
                    ((ISynchronizable)document).setLockObject(synch);
                }
            }
        } else {
            synch = new Object();
        }
        return synch;
    }

    protected void doSetup(IDocument document) {
        IDocumentExtension3 extension3 = (IDocumentExtension3)document;
        if (extension3.getDocumentPartitioner(this.getPartitioningId()) == null) {
            IDocumentPartitioner partitioner = this.createDocumentPartitioner();
            if (partitioner instanceof IDocumentPartitionerExtension3) {
                ((IDocumentPartitionerExtension3)partitioner).connect(document, true);
            } else {
                partitioner.connect(document);
            }
            extension3.setDocumentPartitioner(this.getPartitioningId(), partitioner);
        }
    }

    public abstract String getPartitioningId();

    protected abstract IDocumentPartitioner createDocumentPartitioner();
}

