/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.source.ast;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.AstVisitor;
import org.eclipse.statet.r.core.source.RTerminal;
import org.eclipse.statet.r.core.source.ast.Comment;
import org.eclipse.statet.r.core.source.ast.DocuTag;
import org.eclipse.statet.r.core.source.ast.Expression;
import org.eclipse.statet.r.core.source.ast.NodeType;
import org.eclipse.statet.r.core.source.ast.RAstNode;
import org.eclipse.statet.r.core.source.ast.RAstVisitor;

@NonNullByDefault
public final class DocuComment
extends RAstNode {
    int nextOffset = Integer.MIN_VALUE;
    Comment[] lines;
    ImList<DocuTag> tags;

    DocuComment() {
    }

    @Override
    public final NodeType getNodeType() {
        return NodeType.DOCU_AGGREGATION;
    }

    @Override
    public final RTerminal getOperator(int index) {
        return RTerminal.ROXYGEN_COMMENT;
    }

    public final int getSubsequentNodeOffset() {
        return this.nextOffset;
    }

    public List<DocuTag> getTags() {
        return this.tags;
    }

    @Override
    public final boolean hasChildren() {
        return this.lines.length > 0;
    }

    @Override
    public final int getChildCount() {
        return this.lines.length;
    }

    @Override
    public final Comment getChild(int index) {
        return this.lines[index];
    }

    @Override
    public final int getChildIndex(AstNode child) {
        int i = 0;
        while (i < this.lines.length) {
            if (this.lines[i] == child) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public final void acceptInR(RAstVisitor visitor) throws InvocationTargetException {
        visitor.visit(this);
    }

    @Override
    public final void acceptInRChildren(RAstVisitor visitor) throws InvocationTargetException {
        Comment[] commentArray = this.lines;
        int n = this.lines.length;
        int n2 = 0;
        while (n2 < n) {
            Comment child = commentArray[n2];
            visitor.visit(child);
            ++n2;
        }
    }

    public final void acceptInRDocu(RAstVisitor visitor) throws InvocationTargetException {
        for (DocuTag tag : this.tags) {
            visitor.visit(tag);
        }
    }

    public final void acceptInChildren(AstVisitor visitor) throws InvocationTargetException {
        int i = 0;
        while (i < this.lines.length) {
            visitor.visit((AstNode)this.lines[i]);
            ++i;
        }
    }

    @Override
    final @Nullable Expression getExpr(RAstNode child) {
        return null;
    }

    @Override
    final @Nullable Expression getLeftExpr() {
        return null;
    }

    @Override
    final @Nullable Expression getRightExpr() {
        return null;
    }

    @Override
    public final boolean equalsSingle(RAstNode element) {
        return NodeType.DOCU_AGGREGATION == element.getNodeType();
    }

    @Override
    final int getMissingExprStatus(Expression expr) {
        throw new IllegalArgumentException();
    }

    final void updateOffsets() {
    }
}

