/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.sourcelookup;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainerTypeDelegate;
import org.eclipse.statet.internal.r.debug.core.sourcelookup.Messages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.debug.core.sourcelookup.REnvLibraryPathSourceContainer;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.core.REnvManager;
import org.eclipse.statet.rj.renv.core.REnvUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@NonNullByDefault
public class REnvLibraryPathSourceContainerTypeDelegate
extends AbstractSourceContainerTypeDelegate {
    public ISourceContainer createSourceContainer(String memento) throws CoreException {
        Element node = this.parseDocument(memento);
        if (node.getNodeType() == 1) {
            Element element = node;
            if ("org.eclipse.statet.r.debugSourceContainers.REnvLibraryPathType".equals(element.getNodeName())) {
                REnv rEnv;
                String s = element.getAttribute("rEnv");
                if (s == null || s.isEmpty()) {
                    this.abort(Messages.REnvLibraryPathSourceContainer_error_InvalidConfiguration_message, null);
                }
                if ((rEnv = REnvUtils.decode((String)s, (REnvManager)RCore.getREnvManager())) != null) {
                    return new REnvLibraryPathSourceContainer(rEnv);
                }
                this.abort(Messages.REnvLibraryPathSourceContainer_error_REnvNotAvailable_message, null);
            }
            this.abort(Messages.REnvLibraryPathSourceContainer_error_InvalidConfiguration_message, null);
        }
        this.abort(Messages.REnvLibraryPathSourceContainer_error_InvalidConfiguration_message, null);
        return null;
    }

    public String getMemento(ISourceContainer container) throws CoreException {
        REnvLibraryPathSourceContainer rEnvContainer = (REnvLibraryPathSourceContainer)container;
        Document document = this.newDocument();
        Element element = document.createElement("org.eclipse.statet.r.debugSourceContainers.REnvLibraryPathType");
        element.setAttribute("rEnv", REnvUtils.encode((REnv)rEnvContainer.getREnv()));
        document.appendChild(element);
        return this.serializeDocument(document);
    }
}

