/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.yaml.core.source.ast;

import org.eclipse.statet.dsl.core.source.ast.Collection;
import org.eclipse.statet.dsl.core.source.ast.DslAstNode;
import org.eclipse.statet.dsl.core.source.ast.DslParser;
import org.eclipse.statet.dsl.core.source.ast.NodeType;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImIntList;
import org.eclipse.statet.jcommons.collections.IntList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public abstract class YamlCollection
extends Collection {
    private YamlCollection(DslAstNode parent) {
        super(parent);
    }

    abstract int getNodeCode();

    public static abstract class BlockCollection
    extends YamlCollection {
        BlockCollection(DslAstNode parent) {
            super(parent);
        }

        public int getOpenIndicatorOffset() {
            return Integer.MIN_VALUE;
        }

        public int getCloseIndicatorOffset() {
            return Integer.MIN_VALUE;
        }
    }

    static final class BlockMap
    extends BlockCollection {
        BlockMap(DslAstNode parent, int offset, int endOffset) {
            super(parent);
            this.doSetStartEndOffset(offset, endOffset);
        }

        public NodeType getNodeType() {
            return NodeType.MAP;
        }

        public char getOperator() {
            return '?';
        }

        @Override
        int getNodeCode() {
            return 200704;
        }
    }

    static final class BlockSeq
    extends BlockCollection {
        BlockSeq(DslAstNode parent, int offset, int endOffset) {
            super(parent);
            this.doSetStartEndOffset(offset, endOffset);
        }

        public NodeType getNodeType() {
            return NodeType.SEQ;
        }

        public char getOperator() {
            return '-';
        }

        @Override
        int getNodeCode() {
            return 196608;
        }
    }

    public static abstract class FlowCollection
    extends YamlCollection {
        private ImIntList sepOffsets;
        int closeIndicatorOffset = Integer.MIN_VALUE;

        FlowCollection(DslAstNode parent) {
            super(parent);
        }

        protected void add(DslParser.NContainerBuilder containerBuilder, DslAstNode child) {
            if (containerBuilder.sepOffsets.size() < containerBuilder.children.size()) {
                containerBuilder.sepOffsets.add(Integer.MIN_VALUE);
                if (this.getStatusCode() == 0) {
                    this.doSetStatusCode(0x400570 | this.getNodeCode());
                }
            }
            super.add(containerBuilder, child);
        }

        protected void finish(int endOffset, DslParser.NContainerBuilder containerBuilder) {
            if (this.getStatusCode() == 0 && this.closeIndicatorOffset == Integer.MIN_VALUE) {
                this.doSetStatusCode(0x400520 | this.getNodeCode());
            }
            super.finish(endOffset, containerBuilder);
            this.sepOffsets = ImCollections.toIntList((IntList)containerBuilder.sepOffsets);
            if (!this.sepOffsets.isEmpty()) {
                this.doSetEndOffsetMin(this.sepOffsets.getLast() + 1);
            }
        }

        public int getOpenIndicatorOffset() {
            return this.getStartOffset();
        }

        public ImIntList getSepOffsets() {
            return this.sepOffsets;
        }

        public int getCloseIndicatorOffset() {
            return this.closeIndicatorOffset;
        }
    }

    static final class FlowMap
    extends FlowCollection {
        FlowMap(DslAstNode parent, int offset, int endOffset) {
            super(parent);
            this.doSetStartEndOffset(offset, endOffset);
        }

        public NodeType getNodeType() {
            return NodeType.MAP;
        }

        public char getOperator() {
            return '{';
        }

        @Override
        int getNodeCode() {
            return 233472;
        }
    }

    static final class FlowSeq
    extends FlowCollection {
        FlowSeq(DslAstNode parent, int offset, int endOffset) {
            super(parent);
            this.doSetStartEndOffset(offset, endOffset);
        }

        public NodeType getNodeType() {
            return NodeType.SEQ;
        }

        public char getOperator() {
            return '[';
        }

        @Override
        int getNodeCode() {
            return 229376;
        }
    }
}

