/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.model.core.build;

import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.ecommons.preferences.core.PreferenceAccess;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.core.source.SourceContent;
import org.eclipse.statet.ltk.issues.core.IssueRequestor;
import org.eclipse.statet.ltk.issues.core.TaskIssueConfig;
import org.eclipse.statet.ltk.issues.core.impl.TaskTagReporter;
import org.eclipse.statet.ltk.model.core.element.SourceStructElement;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.model.core.element.SourceUnitModelInfo;

@NonNullByDefault
public class BasicIssueReporter<TSourceUnit extends SourceUnit, TSourceUnitModelInfo extends SourceUnitModelInfo> {
    private final String categoryId;
    private @Nullable TaskIssueConfig taskIssueConfig;
    private boolean isReportProblemsEnabled;
    private boolean isReportTasksEnabled;

    public BasicIssueReporter(String categoryId) {
        this.categoryId = categoryId;
    }

    protected void configure(TaskIssueConfig taskIssueConfig) {
        this.taskIssueConfig = taskIssueConfig;
    }

    protected @Nullable TaskTagReporter getTaskReporter() {
        return null;
    }

    protected final boolean shouldReportProblems() {
        return this.isReportProblemsEnabled;
    }

    protected final boolean shouldReportTasks() {
        return this.isReportTasksEnabled;
    }

    protected void clear() {
    }

    public void run(TSourceUnit sourceUnit, TSourceUnitModelInfo modelInfo, SourceContent content, IssueRequestor requestor, int level) {
        this.isReportProblemsEnabled = requestor.isInterestedInProblems(this.categoryId);
        TaskTagReporter taskReporter = this.getTaskReporter();
        boolean bl = this.isReportTasksEnabled = taskReporter != null && requestor.isInterestedInTasks();
        if (!this.isReportProblemsEnabled && !this.isReportTasksEnabled) {
            return;
        }
        if (this.shouldReportTasks()) {
            TaskIssueConfig taskIssueConfig = this.taskIssueConfig;
            if (taskIssueConfig == null) {
                PreferenceAccess prefs = EPreferences.getContextPrefs(sourceUnit);
                taskIssueConfig = TaskIssueConfig.getConfig(prefs);
            }
            taskReporter.configure(taskIssueConfig);
        }
        try {
            this.runReporters(sourceUnit, modelInfo, content, requestor, level);
        }
        finally {
            this.clear();
        }
    }

    protected void runReporters(TSourceUnit sourceUnit, TSourceUnitModelInfo modelInfo, SourceContent content, IssueRequestor requestor, int level) {
        SourceStructElement<?, ?> element = modelInfo.getSourceElement();
        this.runReporters(sourceUnit, (AstNode)element.getAdapter(AstNode.class), modelInfo, content, requestor, level);
    }

    protected void runReporters(TSourceUnit sourceUnit, @Nullable AstNode node, @Nullable TSourceUnitModelInfo modelInfo, SourceContent content, IssueRequestor requestor, int level) {
    }
}

