/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.eutils.autonature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.internal.eutils.autonature.Activator;
import org.eclipse.statet.internal.eutils.autonature.AutoConfig;
import org.eclipse.statet.internal.eutils.autonature.ConfigManager;
import org.eclipse.statet.internal.eutils.autonature.ConfiguratorTask;
import org.eclipse.statet.internal.eutils.autonature.NatureTask;
import org.eclipse.statet.internal.eutils.autonature.Task;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class TaskProcessor {
    private Map<IProject, List<Task>> projectTasks = new HashMap<IProject, List<Task>>();
    private @Nullable ConfigJob job;

    public static void aggregateTasks(IProject project, List<AutoConfig> configs, int flags, @Nullable List<Task> configurableTasks, @Nullable List<Task> alreadyConfigTasks, @Nullable List<Task> notConfigTasks, SubMonitor m) throws CoreException {
        int l = configs.size();
        if (configurableTasks == null) {
            configurableTasks = new ArrayList<Task>(l);
        }
        if (alreadyConfigTasks == null) {
            alreadyConfigTasks = new ArrayList<Task>(l);
        }
        if (notConfigTasks == null) {
            notConfigTasks = new ArrayList<Task>();
        }
        int i = 0;
        while (i < l) {
            m.setWorkRemaining(l - i);
            AutoConfig config = configs.get(i);
            if (config.isAvailable()) {
                for (Task task : config.getTasks()) {
                    if (configurableTasks.contains(task) || alreadyConfigTasks.contains(task) || notConfigTasks.contains(task)) continue;
                    switch (task.check(project, flags, m.newChild(1))) {
                        case 2: {
                            configurableTasks.add(task);
                            break;
                        }
                        case 1: {
                            alreadyConfigTasks.add(task);
                            break;
                        }
                        default: {
                            notConfigTasks.add(task);
                        }
                    }
                }
            }
            ++i;
        }
    }

    public static IStatus process(IProject project, Collection<Task> tasks, SubMonitor m) {
        try {
            int taskCount = 0;
            for (Task task : tasks) {
                if (!(task instanceof ConfiguratorTask)) continue;
                ++taskCount;
            }
            m.beginTask(NLS.bind((String)"Configuring project ''{0}''", (Object)project.getName()), 3 + taskCount);
            IProjectDescription description = project.getDescription();
            boolean descriptionChanged = false;
            String[] existingNatureIds = description.getNatureIds();
            ArrayList<String> natureIds = new ArrayList<String>(existingNatureIds.length + tasks.size());
            int i = 0;
            while (i < existingNatureIds.length) {
                existingNatureIds[i] = existingNatureIds[i].intern();
                natureIds.add(existingNatureIds[i]);
                ++i;
            }
            for (Task task : tasks) {
                String natureId;
                if (!(task instanceof NatureTask) || TaskProcessor.contains(existingNatureIds, natureId = ((NatureTask)task).getNatureId())) continue;
                natureIds.add(natureId);
            }
            m.worked(1);
            if (natureIds.size() > existingNatureIds.length) {
                ConfigManager configManager = Activator.getInstance().getConfigManager();
                configManager.arrangeNatures(natureIds, existingNatureIds.length);
                description.setNatureIds(natureIds.toArray(new String[natureIds.size()]));
                descriptionChanged = true;
            }
            if (descriptionChanged) {
                project.setDescription(description, (IProgressMonitor)m.newChild(1));
            }
            m.setWorkRemaining(taskCount);
            for (Task task : tasks) {
                if (!(task instanceof ConfiguratorTask)) continue;
                ((ConfiguratorTask)task).configure(project, m.newChild(1));
            }
            return Status.OK_STATUS;
        }
        catch (CoreException e) {
            return new Status(4, "org.eclipse.statet.eutils.autonature", NLS.bind((String)"An error occurred when configuring project ''{0}''.", (Object)project.getName()), (Throwable)e);
        }
    }

    public synchronized void add(IProject project, List<Task> tasks) {
        List<Task> allTasks = this.projectTasks.get(project);
        if (allTasks == null) {
            this.projectTasks.put(project, new ArrayList<Task>(tasks));
            return;
        }
        for (Task task : tasks) {
            if (allTasks.contains(task)) continue;
            allTasks.add(task);
        }
    }

    public synchronized void schedule() {
        if (this.projectTasks.isEmpty()) {
            return;
        }
        ConfigJob job = this.job;
        if (job == null) {
            this.job = job = new ConfigJob();
        }
        job.schedule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IStatus process(@Nullable IProgressMonitor monitor) {
        Map<IProject, List<Task>> tasks;
        TaskProcessor taskProcessor = this;
        synchronized (taskProcessor) {
            tasks = this.projectTasks;
            if (tasks.isEmpty()) {
                return Status.OK_STATUS;
            }
            this.projectTasks = new HashMap<IProject, List<Task>>();
        }
        SubMonitor m = SubMonitor.convert((IProgressMonitor)monitor, (int)tasks.size());
        ArrayList<IStatus> status = null;
        for (Map.Entry<IProject, List<Task>> entry : tasks.entrySet()) {
            IStatus projectStatus = TaskProcessor.process(entry.getKey(), (Collection<Task>)entry.getValue(), m.newChild(1, 0));
            if (projectStatus.isOK()) continue;
            if (status == null) {
                status = new ArrayList<IStatus>(tasks.size());
            }
            status.add(projectStatus);
        }
        if (status != null) {
            return new MultiStatus("org.eclipse.statet.eutils.autonature", 0, status.toArray(new IStatus[status.size()]), status.size() == 1 ? "The auto project configuration failed for 1 project." : NLS.bind((String)"The auto project configuration failed for {0} projects.", (Object)status.size()), null);
        }
        return Status.OK_STATUS;
    }

    private static boolean contains(String[] array, String s) {
        int i = 0;
        while (i < array.length) {
            if (array[i] == s) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private class ConfigJob
    extends WorkspaceJob {
        public ConfigJob() {
            super("Auto Project Configuration");
            this.setUser(false);
            this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
        }

        public IStatus runInWorkspace(@Nullable IProgressMonitor monitor) throws CoreException {
            return TaskProcessor.this.process(monitor);
        }
    }
}

