/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.eutils.autonature;

import org.eclipse.statet.internal.eutils.autonature.Task;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public abstract class AutoConfig {
    private final String id;
    private final String enabledPrefKey;
    private final ImList<Task> tasks;

    public AutoConfig(String id, ImList<Task> tasks) {
        this.id = id;
        this.enabledPrefKey = id + ".enabled";
        this.tasks = tasks;
    }

    public String getId() {
        return this.id;
    }

    public String getEnabledPrefKey() {
        return this.enabledPrefKey;
    }

    public boolean isAvailable() {
        if (this.getLabel() == null) {
            return false;
        }
        for (Task task : this.tasks) {
            if (task.isAvailable()) continue;
            return false;
        }
        return true;
    }

    public boolean isSupported(byte mode) {
        for (Task task : this.tasks) {
            if (task.isSupported(mode)) continue;
            return false;
        }
        return true;
    }

    public abstract @Nullable String getLabel();

    public ImList<Task> getTasks() {
        return this.tasks;
    }

    public String toString() {
        return this.id;
    }

    static class Dummy
    extends AutoConfig {
        public Dummy(String id) {
            super(id, (ImList<Task>)ImCollections.emptyList());
        }

        @Override
        public @Nullable String getLabel() {
            return null;
        }
    }
}

