/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.sql.dictionary;

import org.apache.derby.catalog.DependableFinder;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.PermissionsDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.shared.common.error.StandardException;

public class ColPermsDescriptor
extends PermissionsDescriptor {
    private UUID tableUUID;
    private String type;
    private FormatableBitSet columns;
    private String tableName;

    public ColPermsDescriptor(DataDictionary dd, String grantee, String grantor, UUID tableUUID, String type, FormatableBitSet columns) throws StandardException {
        super(dd, grantee, grantor);
        this.tableUUID = tableUUID;
        this.type = type;
        this.columns = columns;
        if (tableUUID != null) {
            this.tableName = dd.getTableDescriptor(tableUUID).getName();
        }
    }

    public ColPermsDescriptor(DataDictionary dd, String grantee, String grantor, UUID tableUUID, String type) throws StandardException {
        this(dd, grantee, grantor, tableUUID, type, null);
    }

    public ColPermsDescriptor(DataDictionary dd, UUID colPermsUUID) throws StandardException {
        super(dd, null, null);
        this.oid = colPermsUUID;
    }

    @Override
    public int getCatalogNumber() {
        return 17;
    }

    public UUID getTableUUID() {
        return this.tableUUID;
    }

    public String getType() {
        return this.type;
    }

    public FormatableBitSet getColumns() {
        return this.columns;
    }

    public String toString() {
        return "colPerms: grantee=" + this.getGrantee() + ",colPermsUUID=" + this.getUUID() + ",grantor=" + this.getGrantor() + ",tableUUID=" + this.getTableUUID() + ",type=" + this.getType() + ",columns=" + this.getColumns();
    }

    public boolean equals(Object other) {
        if (!(other instanceof ColPermsDescriptor)) {
            return false;
        }
        ColPermsDescriptor otherColPerms = (ColPermsDescriptor)other;
        return super.keyEquals(otherColPerms) && this.tableUUID.equals(otherColPerms.tableUUID) && (this.type == null ? otherColPerms.type == null : this.type.equals(otherColPerms.type));
    }

    public int hashCode() {
        return super.keyHashCode() + this.tableUUID.hashCode() + (this.type == null ? 0 : this.type.hashCode());
    }

    @Override
    public boolean checkOwner(String authorizationId) throws StandardException {
        TableDescriptor td = this.getDataDictionary().getTableDescriptor(this.tableUUID);
        return td.getSchemaDescriptor().getAuthorizationId().equals(authorizationId);
    }

    @Override
    public String getObjectName() {
        return "Column Privilege on " + this.tableName;
    }

    @Override
    public String getClassType() {
        return "ColumnsPrivilege";
    }

    @Override
    public DependableFinder getDependableFinder() {
        return this.getDependableFinder(463);
    }
}

