/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.sourceediting;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.statet.dsl.dcf.ui.util.FieldNameTextStyleScanner;
import org.eclipse.statet.dsl.ui.DslUI;
import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.text.IIndentSettings;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.ui.presentation.SingleTokenScanner;
import org.eclipse.statet.ecommons.text.ui.presentation.TextStyleManager;
import org.eclipse.statet.ecommons.text.ui.settings.PreferenceStoreTextStyleManager;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.editors.rpkg.RPkgDescrAutoEditStrategy;
import org.eclipse.statet.internal.r.ui.editors.rpkg.RPkgDescrBracketPairMatcher;
import org.eclipse.statet.internal.r.ui.editors.rpkg.RPkgDescrContentAssistProcessor;
import org.eclipse.statet.internal.r.ui.editors.rpkg.RPkgDescrQuickOutlineInformationProvider;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.ltk.text.core.CharPairMatcher;
import org.eclipse.statet.ltk.ui.LtkUIPreferences;
import org.eclipse.statet.ltk.ui.sourceediting.EcoReconciler2;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorAddon;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfiguration;
import org.eclipse.statet.ltk.ui.sourceediting.SourceUnitReconcilingStrategy;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistComputerRegistry;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistProcessor;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.RCoreAccess;
import org.eclipse.statet.r.core.source.doc.RDocumentConstants;
import org.eclipse.statet.r.core.source.doc.RPkgDescrDocumentContentInfo;
import org.eclipse.statet.r.ui.editors.REditorOptions;
import org.eclipse.statet.r.ui.sourceediting.RAutoEditStrategy;
import org.eclipse.statet.r.ui.sourceediting.RContentAssistProcessor;

@NonNullByDefault
public class RPkgDescrSourceViewerConfiguration
extends SourceEditorViewerConfiguration {
    private static final @NonNull String[] CONTENT_TYPES = (String[])RDocumentConstants.RPKG_DESCR_CONTENT_TYPES.toArray(String[]::new);
    private RCoreAccess rCoreAccess;
    private @Nullable RPkgDescrAutoEditStrategy descrAutoEditStrategy;
    private @Nullable RAutoEditStrategy rAutoEditStrategy;

    public RPkgDescrSourceViewerConfiguration(DocContentSections documentContentInfo, int flags, SourceEditor editor, @Nullable RCoreAccess access, @Nullable IPreferenceStore preferenceStore, @Nullable PreferenceStoreTextStyleManager<TextAttribute> textStyles) {
        super(documentContentInfo, flags, editor);
        this.setCoreAccess(access);
        this.setup(preferenceStore != null ? preferenceStore : RUIPlugin.getInstance().getEditorPreferenceStore(), LtkUIPreferences.getEditorDecorationPreferences(), LtkUIPreferences.getAssistPreferences());
        if (textStyles != null) {
            this.setTextStyles(textStyles);
        }
    }

    public RPkgDescrSourceViewerConfiguration(int flags) {
        this((DocContentSections)RPkgDescrDocumentContentInfo.INSTANCE, flags, null, null, null, null);
    }

    protected void setCoreAccess(@Nullable RCoreAccess access) {
        this.rCoreAccess = access != null ? access : RCore.getWorkbenchAccess();
    }

    protected void initTextStyles() {
        this.setTextStyles(DslUI.getTextStyleManager());
    }

    protected void initScanners() {
        TextStyleManager textStyles = this.getTextStyles();
        this.addScanner("RPkgDescr.Default", (ITokenScanner)new SingleTokenScanner(textStyles, "dsl_ts_Default"));
        this.addScanner("RPkgDescr.FieldName", (ITokenScanner)new FieldNameTextStyleScanner(textStyles));
    }

    protected ITokenScanner getScanner(String contentType) {
        if (contentType != "RPkgDescr.FieldName") {
            contentType = "RPkgDescr.Default";
        }
        return super.getScanner(contentType);
    }

    public List<SourceEditorAddon> getAddOns() {
        List addons = super.getAddOns();
        if (this.descrAutoEditStrategy != null) {
            addons.add(this.descrAutoEditStrategy);
        }
        if (this.rAutoEditStrategy != null) {
            addons.add(this.rAutoEditStrategy);
        }
        return addons;
    }

    public @NonNull String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return CONTENT_TYPES;
    }

    public CharPairMatcher createPairMatcher() {
        return new RPkgDescrBracketPairMatcher();
    }

    protected IIndentSettings getIndentSettings() {
        return this.rCoreAccess.getRCodeStyle();
    }

    public boolean isSmartInsertSupported() {
        return true;
    }

    public boolean isSmartInsertByDefault() {
        return (Boolean)EPreferences.getInstancePrefs().getPreferenceValue((Preference)REditorOptions.SMARTINSERT_BYDEFAULT_ENABLED_PREF);
    }

    public @NonNull IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if (this.getSourceEditor() == null) {
            return super.getAutoEditStrategies(sourceViewer, contentType);
        }
        switch (this.getDocumentContentInfo().getTypeByPartition(contentType)) {
            case "org.eclipse.statet.R": {
                RAutoEditStrategy autoEditStrategy = this.rAutoEditStrategy;
                if (autoEditStrategy == null) {
                    this.rAutoEditStrategy = autoEditStrategy = new RAutoEditStrategy(this.rCoreAccess, this.getSourceEditor());
                }
                return new IAutoEditStrategy[]{autoEditStrategy};
            }
        }
        RPkgDescrAutoEditStrategy autoEditStrategy = this.descrAutoEditStrategy;
        if (autoEditStrategy == null) {
            this.descrAutoEditStrategy = autoEditStrategy = new RPkgDescrAutoEditStrategy(this.rCoreAccess, this.getSourceEditor());
        }
        return new IAutoEditStrategy[]{autoEditStrategy};
    }

    public @Nullable IReconciler getReconciler(ISourceViewer sourceViewer) {
        SourceEditor editor = this.getSourceEditor();
        if (!(editor instanceof SourceEditor1)) {
            return null;
        }
        EcoReconciler2 reconciler = new EcoReconciler2(editor);
        reconciler.setDelay(500);
        reconciler.addReconcilingStrategy((IReconcilingStrategy)new SourceUnitReconcilingStrategy());
        return reconciler;
    }

    public void initContentAssist(ContentAssist assistant) {
        ContentAssistComputerRegistry registry = RUIPlugin.getInstance().getRPkgDescrContentAssistRegistry();
        ContentAssistProcessor processor = new RPkgDescrContentAssistProcessor(assistant, "RPkgDescr.Default", registry, this.getSourceEditor());
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "RPkgDescr.Default");
        processor = new RPkgDescrContentAssistProcessor(assistant, "RPkgDescr.FieldName", registry, this.getSourceEditor());
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "RPkgDescr.FieldName");
        processor = new RContentAssistProcessor(assistant, "R.Default", registry, this.getSourceEditor());
        processor.setCompletionProposalAutoActivationCharacters(new char[]{'$', '@'});
        processor.setContextInformationAutoActivationCharacters(new char[]{','});
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "R.Default");
        processor = new RContentAssistProcessor(assistant, "R.QuotedSymbol", registry, this.getSourceEditor());
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "R.QuotedSymbol");
        processor = new RContentAssistProcessor(assistant, "R.String", registry, this.getSourceEditor());
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "R.String");
        processor = new RContentAssistProcessor(assistant, "R.Comment", registry, this.getSourceEditor());
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "R.Comment");
    }

    protected void collectHyperlinkDetectorTargets(Map<String, IAdaptable> targets, ISourceViewer sourceViewer) {
    }

    protected @Nullable IInformationProvider getQuickInformationProvider(ISourceViewer sourceViewer, int operation) {
        SourceEditor editor = this.getSourceEditor();
        if (editor == null) {
            return null;
        }
        return switch (operation) {
            case 51 -> new RPkgDescrQuickOutlineInformationProvider(editor, operation);
            default -> null;
        };
    }
}

