/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.launcher;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.preferences.core.EPreferences;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.internal.r.debug.ui.RLaunchingMessages;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.r.launching.ICodeSubmitContentHandler;
import org.eclipse.statet.r.launching.IRCodeSubmitConnector;
import org.eclipse.statet.r.launching.RRunDebugPreferenceConstants;
import org.eclipse.ui.statushandlers.StatusManager;

public class RCodeLaunchRegistry {
    static final String CONNECTOR_EXTENSION_POINT = "rCodeLaunchConnector";
    static final String CONTENTHANDLER_EXTENSION_POINT = "rCodeLaunchContentHandler";
    private static final String CONNECTOR_ELEMENT = "connector";
    private static final String CONTENTHANDLER_ELEMENT = "contentHandler";
    private static final String CONTENT_FILECOMMAND_ELEMENT = "fileCommand";
    private static final String ATT_ID = "id";
    private static final String ATT_NAME = "name";
    private static final String ATT_DESCRIPTION = "description";
    private static final String ATT_CLASS = "class";
    private static final String ATT_CONTENT_TYPE = "contentTypeId";
    private static final String ATT_HANDLER = "handler";
    private static final String ATT_DEFAULTCOMMAND = "defaultCommand";
    private static RCodeLaunchRegistry fgRegistry;
    private IRCodeSubmitConnector fConnector;
    private final HashMap<String, ContentHandler> fContentHandler = new HashMap();
    private ContentHandler fDefaultHandler;

    public static boolean isConfigured() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.statet.r.ui", CONNECTOR_EXTENSION_POINT);
        return elements != null && elements.length > 0;
    }

    public static synchronized RCodeLaunchRegistry getDefault() {
        if (fgRegistry == null) {
            new RCodeLaunchRegistry();
        }
        return fgRegistry;
    }

    public static ConnectorConfig[] getAvailableConnectors() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.statet.r.ui", CONNECTOR_EXTENSION_POINT);
        ConnectorConfig[] configs = new ConnectorConfig[elements.length];
        int i = 0;
        while (i < elements.length) {
            configs[i] = new ConnectorConfig(elements[i]);
            ++i;
        }
        return configs;
    }

    public static ContentHandler.FileCommand[] getAvailableFileCommands() {
        return RCodeLaunchRegistry.getDefault().getFileCommands();
    }

    private RCodeLaunchRegistry() {
        fgRegistry = this;
        this.loadConnectorExtensions();
        this.loadHandlerExtensions();
        IScopeContext scope = InstanceScope.INSTANCE;
        scope.getNode(RRunDebugPreferenceConstants.PREF_R_CONNECTOR.getQualifier()).addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                RCodeLaunchRegistry.this.loadConnectorExtensions();
            }
        });
        scope.getNode("org.eclipse.statet.r.ui/CodeLaunchContentHandler").addPreferenceChangeListener(new IEclipsePreferences.IPreferenceChangeListener(){

            public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
                RCodeLaunchRegistry.this.loadHandlerPreferences();
            }
        });
    }

    private void loadConnectorExtensions() {
        this.fConnector = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.statet.r.ui", CONNECTOR_EXTENSION_POINT);
        String id = (String)EPreferences.getInstancePrefs().getPreferenceValue((Preference)RRunDebugPreferenceConstants.PREF_R_CONNECTOR);
        int i = 0;
        while (i < elements.length) {
            if (id.equals(elements[i].getAttribute(ATT_ID))) {
                try {
                    this.fConnector = (IRCodeSubmitConnector)elements[i].createExecutableExtension(ATT_CLASS);
                    return;
                }
                catch (Exception e) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.ui", 0, NLS.bind((String)"Error loading R Launch Connector ''{0}''.", (Object)elements[i].getAttribute(ATT_NAME)), (Throwable)e));
                }
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadHandlerExtensions() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.statet.r.ui", CONTENTHANDLER_EXTENSION_POINT);
        HashMap<String, ContentHandler> hashMap = this.fContentHandler;
        synchronized (hashMap) {
            int i = 0;
            while (i < elements.length) {
                ContentHandler handlerData;
                String contentTypeId;
                if (elements[i].getName().equals(CONTENTHANDLER_ELEMENT) && (contentTypeId = (handlerData = new ContentHandler(elements[i])).getContentTypeId()) != null && contentTypeId.length() > 0) {
                    this.fContentHandler.put(contentTypeId, handlerData);
                }
                ++i;
            }
            this.fDefaultHandler = this.fContentHandler.get("org.eclipse.statet.r.contentTypes.R");
            if (this.fDefaultHandler == null) {
                throw new IllegalStateException();
            }
        }
        this.loadHandlerPreferences();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadHandlerPreferences() {
        IEclipsePreferences node = InstanceScope.INSTANCE.getNode("org.eclipse.statet.r.ui/CodeLaunchContentHandler");
        if (node == null) {
            return;
        }
        HashMap<String, ContentHandler> hashMap = this.fContentHandler;
        synchronized (hashMap) {
            for (ContentHandler data : this.fContentHandler.values()) {
                ContentHandler.FileCommand[] fileCommandArray = data.getFileCommands();
                int n = fileCommandArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ContentHandler.FileCommand fileCommand = fileCommandArray[n2];
                    fileCommand.setCurrentCommand(node.get(fileCommand.fId + ":command", null));
                    ++n2;
                }
            }
        }
    }

    public IRCodeSubmitConnector getConnector() throws CoreException {
        if (this.fConnector == null) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.ui", 0, RLaunchingMessages.SubmitCode_error_NoConnector_message, null));
        }
        return this.fConnector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ICodeSubmitContentHandler getContentHandler(String contentType) {
        ICodeSubmitContentHandler handler;
        ContentHandler data;
        HashMap<String, ContentHandler> hashMap = this.fContentHandler;
        synchronized (hashMap) {
            data = this.fContentHandler.get(contentType);
        }
        ICodeSubmitContentHandler iCodeSubmitContentHandler = handler = data != null ? data.getHandler() : null;
        if (handler != null) {
            return handler;
        }
        return this.fDefaultHandler.getHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentHandler.FileCommand getContentFileCommand(String contentType) {
        ContentHandler.FileCommand fileCommand;
        ContentHandler data;
        HashMap<String, ContentHandler> hashMap = this.fContentHandler;
        synchronized (hashMap) {
            data = this.fContentHandler.get(contentType);
        }
        ContentHandler.FileCommand fileCommand2 = fileCommand = data != null ? data.getContentFileCommand() : null;
        if (fileCommand != null) {
            return fileCommand;
        }
        return this.fDefaultHandler.getContentFileCommand();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentHandler.FileCommand[] getFileCommands() {
        HashMap<String, ContentHandler> hashMap = this.fContentHandler;
        synchronized (hashMap) {
            ArrayList<ContentHandler.FileCommand> list = new ArrayList<ContentHandler.FileCommand>(this.fContentHandler.size() * 2);
            for (ContentHandler data : this.fContentHandler.values()) {
                ContentHandler.FileCommand[] fileCommandArray = data.getFileCommands();
                int n = fileCommandArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ContentHandler.FileCommand fileCommand = fileCommandArray[n2];
                    list.add(fileCommand);
                    ++n2;
                }
            }
            return list.toArray(new ContentHandler.FileCommand[list.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContentHandler.FileCommand getFileCommand(String id) {
        HashMap<String, ContentHandler> hashMap = this.fContentHandler;
        synchronized (hashMap) {
            for (ContentHandler data : this.fContentHandler.values()) {
                ContentHandler.FileCommand[] fileCommandArray = data.getFileCommands();
                int n = fileCommandArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ContentHandler.FileCommand fileCommand = fileCommandArray[n2];
                    if (fileCommand.getId().equals(id)) {
                        return fileCommand;
                    }
                    ++n2;
                }
            }
        }
        return null;
    }

    public static class ConnectorConfig {
        public final String fId;
        public final String fName;
        public final String fDescription;

        private ConnectorConfig(IConfigurationElement element) {
            this.fId = element.getAttribute(RCodeLaunchRegistry.ATT_ID);
            this.fName = element.getAttribute(RCodeLaunchRegistry.ATT_NAME);
            this.fDescription = element.getAttribute(RCodeLaunchRegistry.ATT_DESCRIPTION);
        }
    }

    public static class ContentHandler {
        private final String fContentTypeId;
        IConfigurationElement fConfigurationElement;
        ICodeSubmitContentHandler fHandler;
        private final FileCommand[] fFileCommands;

        public ContentHandler(IConfigurationElement config) {
            this.fContentTypeId = config.getAttribute(RCodeLaunchRegistry.ATT_CONTENT_TYPE);
            this.fConfigurationElement = config;
            IConfigurationElement[] fileCommandConfigs = config.getChildren(RCodeLaunchRegistry.CONTENT_FILECOMMAND_ELEMENT);
            this.fFileCommands = new FileCommand[fileCommandConfigs.length];
            int i = 0;
            while (i < fileCommandConfigs.length) {
                this.fFileCommands[i] = new FileCommand(fileCommandConfigs[i].getAttribute(RCodeLaunchRegistry.ATT_ID), fileCommandConfigs[i].getAttribute(RCodeLaunchRegistry.ATT_NAME), fileCommandConfigs[i].getAttribute(RCodeLaunchRegistry.ATT_DEFAULTCOMMAND));
                ++i;
            }
        }

        public String getContentTypeId() {
            return this.fContentTypeId;
        }

        public ICodeSubmitContentHandler getHandler() {
            if (this.fHandler == null && this.fConfigurationElement != null && this.fConfigurationElement.getAttribute(RCodeLaunchRegistry.ATT_HANDLER) != null) {
                try {
                    this.fHandler = (ICodeSubmitContentHandler)this.fConfigurationElement.createExecutableExtension(RCodeLaunchRegistry.ATT_HANDLER);
                }
                catch (CoreException e) {
                    RUIPlugin.logError(0, "Error occurred when loading content handler", e);
                }
            }
            return this.fHandler;
        }

        public FileCommand getContentFileCommand() {
            if (this.fFileCommands.length > 0) {
                return this.fFileCommands[0];
            }
            return null;
        }

        public FileCommand[] getFileCommands() {
            return this.fFileCommands;
        }

        public FileCommand getFileCommand(String id) {
            int i = 0;
            while (i < this.fFileCommands.length) {
                if (this.fFileCommands[i].fId.equals(id)) {
                    return this.fFileCommands[i];
                }
                ++i;
            }
            return null;
        }

        public static class FileCommand {
            private final String fId;
            private final String fLabel;
            private final String fDefaultFileCommand;
            private String fCurrentFileCommand;

            public FileCommand(String id, String label, String defaultCommand) {
                this.fId = id;
                this.fLabel = label;
                this.fDefaultFileCommand = this.fCurrentFileCommand = defaultCommand;
            }

            void setCurrentCommand(String command) {
                this.fCurrentFileCommand = command != null ? command : this.fDefaultFileCommand;
            }

            public String getId() {
                return this.fId;
            }

            public String getLabel() {
                return this.fLabel;
            }

            public String getDefaultCommand() {
                return this.fDefaultFileCommand;
            }

            public String getCurrentCommand() {
                return this.fCurrentFileCommand;
            }
        }
    }
}

