/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.grid.core.layers;

import org.eclipse.statet.ecommons.waltable.core.config.DisplayMode;
import org.eclipse.statet.ecommons.waltable.core.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.core.layer.ForwardLayerCell;
import org.eclipse.statet.ecommons.waltable.core.layer.LabelStack;
import org.eclipse.statet.ecommons.waltable.core.layer.Layer;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCell;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerCellDim;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerPainter;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerUtils;
import org.eclipse.statet.ecommons.waltable.grid.core.layers.DimensionallyDependentLayer;
import org.eclipse.statet.ecommons.waltable.selection.core.SelectionLayer;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.ObjectUtils;

@NonNullByDefault
public class AbstractPositionHeaderLayer
extends DimensionallyDependentLayer {
    private final Orientation headerOrientation;
    private final SelectionLayer selectionLayer;
    private final String fullySelectedLabel;

    public AbstractPositionHeaderLayer(Layer baseLayer, Orientation orientation, Layer contentLayerDependency, SelectionLayer selectionLayer, String fullySelectedLabel, LayerPainter layerPainter) {
        super(baseLayer, orientation == Orientation.HORIZONTAL ? contentLayerDependency : baseLayer, orientation == Orientation.VERTICAL ? contentLayerDependency : baseLayer, layerPainter);
        this.headerOrientation = (Orientation)((Object)ObjectUtils.nonNullAssert((Object)((Object)orientation)));
        this.selectionLayer = (SelectionLayer)ObjectUtils.nonNullAssert((Object)selectionLayer);
        this.fullySelectedLabel = (String)ObjectUtils.nonNullAssert((Object)fullySelectedLabel);
    }

    @Override
    protected LayerCell createCell(LayerCellDim hDim, LayerCellDim vDim, LayerCell underlyingCell) {
        return new ForwardLayerCell(this, hDim, vDim, underlyingCell){

            @Override
            public DisplayMode getDisplayMode() {
                if (AbstractPositionHeaderLayer.this.isSelected(this.getDim(AbstractPositionHeaderLayer.this.headerOrientation))) {
                    return DisplayMode.SELECTED;
                }
                return super.getDisplayMode();
            }

            @Override
            public LabelStack getLabels() {
                LabelStack configLabels = super.getLabels();
                if (AbstractPositionHeaderLayer.this.isFullySelected(this.getDim(AbstractPositionHeaderLayer.this.headerOrientation))) {
                    configLabels.addLabel(AbstractPositionHeaderLayer.this.fullySelectedLabel);
                }
                return configLabels;
            }
        };
    }

    protected boolean isSelected(LayerCellDim dim) {
        long position;
        Object layerDim = this.getDim(this.headerOrientation);
        if (this.selectionLayer.isPositionSelected(this.headerOrientation, LayerUtils.convertPosition(layerDim, position = dim.getPosition(), position, this.selectionLayer.getDim(this.headerOrientation)))) {
            return true;
        }
        if (dim.getPositionSpan() > 1L) {
            long iPosition = dim.getOriginPosition();
            long endPosition = iPosition + dim.getPositionSpan();
            while (iPosition < endPosition) {
                if (iPosition != position && this.selectionLayer.isPositionSelected(this.headerOrientation, LayerUtils.convertPosition(layerDim, position, iPosition, this.selectionLayer.getDim(this.headerOrientation)))) {
                    return true;
                }
                ++iPosition;
            }
        }
        return false;
    }

    protected boolean isFullySelected(LayerCellDim dim) {
        long position;
        Object layerDim = this.getDim(this.headerOrientation);
        if (!this.selectionLayer.isPositionFullySelected(this.headerOrientation, LayerUtils.convertPosition(layerDim, position = dim.getPosition(), position, this.selectionLayer.getDim(this.headerOrientation)))) {
            return false;
        }
        if (dim.getPositionSpan() > 1L) {
            long iPosition = dim.getOriginPosition();
            long endPosition = iPosition + dim.getPositionSpan();
            while (iPosition < endPosition) {
                if (iPosition != position && !this.selectionLayer.isPositionFullySelected(this.headerOrientation, LayerUtils.convertPosition(layerDim, position, iPosition, this.selectionLayer.getDim(this.headerOrientation)))) {
                    return false;
                }
                ++iPosition;
            }
        }
        return true;
    }
}

