/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.conflation;

import java.util.ArrayList;
import java.util.concurrent.ScheduledFuture;
import org.eclipse.statet.ecommons.waltable.conflation.IEventConflater;
import org.eclipse.statet.ecommons.waltable.core.layer.LayerEvent;
import org.eclipse.statet.ecommons.waltable.util.Scheduler;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class EventConflaterChain
implements IEventConflater {
    public static final int DEFAULT_INITIAL_DELAY = 100;
    public static final int DEFAULT_REFRESH_INTERVAL = 50;
    private static final Scheduler scheduler = new Scheduler("EventConflaterChain");
    private final ArrayList<IEventConflater> chain = new ArrayList();
    private final long refreshInterval;
    private final long initialDelay;
    private boolean started;
    private @Nullable ScheduledFuture<?> future;

    public EventConflaterChain(int refreshInterval, int initialDelay) {
        this.refreshInterval = refreshInterval;
        this.initialDelay = initialDelay;
    }

    public EventConflaterChain() {
        this(50, 100);
    }

    public void start() {
        if (!this.started) {
            this.future = scheduler.scheduleWithFixedDelay(this.getConflaterTask(), this.initialDelay, this.refreshInterval);
            this.started = true;
        }
    }

    public void stop() {
        if (this.started) {
            this.started = false;
            scheduler.unschedule(this.future);
        }
    }

    public void add(IEventConflater conflater) {
        this.chain.add(conflater);
    }

    @Override
    public void addEvent(LayerEvent event) {
        for (IEventConflater eventConflater : this.chain) {
            eventConflater.addEvent(event);
        }
    }

    @Override
    public void clearQueue() {
        for (IEventConflater eventConflater : this.chain) {
            eventConflater.clearQueue();
        }
    }

    @Override
    public int getCount() {
        int count = 0;
        for (IEventConflater eventConflater : this.chain) {
            count += eventConflater.getCount();
        }
        return count;
    }

    @Override
    public Runnable getConflaterTask() {
        return new Runnable(){

            @Override
            public void run() {
                for (IEventConflater conflater : EventConflaterChain.this.chain) {
                    conflater.getConflaterTask().run();
                }
            }
        };
    }
}

