/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.buildpaths.ui;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.statet.ltk.buildpaths.core.BuildpathAttribute;
import org.eclipse.statet.ltk.buildpaths.core.IBuildpathAttribute;
import org.eclipse.statet.ltk.buildpaths.ui.BuildpathListElement;

public class BuildpathListElementAttribute {
    private final BuildpathListElement element;
    private final String name;
    private Object value;
    private final boolean builtin;
    private final IStatus status;

    public BuildpathListElementAttribute(BuildpathListElement parent, String name, Object value, boolean builtin) {
        this.name = name;
        this.value = value;
        this.element = parent;
        this.builtin = builtin;
        this.status = parent.getContainerChildStatus(this);
    }

    public BuildpathListElement getParent() {
        return this.element;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
        this.getParent().attributeChanged(this.name);
    }

    public boolean isBuiltin() {
        return this.builtin;
    }

    public IStatus getStatus() {
        return this.status;
    }

    public IBuildpathAttribute getCoreAttribute() {
        return new BuildpathAttribute(this.name, this.value != null ? this.value.toString() : null);
    }

    public int hashCode() {
        return this.element.getPath().hashCode() + this.name.hashCode() * 89;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BuildpathListElementAttribute) {
            BuildpathListElementAttribute other = (BuildpathListElementAttribute)obj;
            return this.element.getPath().equals((Object)other.element.getPath()) && this.name == other.name;
        }
        return false;
    }
}

