/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.variables.core;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.core.variables.IDynamicVariableResolver;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.core.variables.IValueVariable;
import org.eclipse.statet.ecommons.variables.core.DynamicVariable;
import org.eclipse.statet.ecommons.variables.core.StaticVariable;
import org.eclipse.statet.ecommons.variables.core.UnresolvedVariable;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class VariableUtils {
    public static <TVariable extends IStringVariable> void add(Map<String, ? super TVariable> variables, TVariable variableToAdd) {
        variables.put(variableToAdd.getName(), variableToAdd);
    }

    public static <TVariable extends IStringVariable> void add(Map<String, ? super TVariable> variables, Collection<TVariable> variablesToAdd) {
        for (IStringVariable variable : variablesToAdd) {
            variables.put(variable.getName(), variable);
        }
    }

    public static void add(Map<String, ? super IDynamicVariable> variables, Collection<IDynamicVariable> variablesToAdd, IDynamicVariableResolver resolver) {
        for (IDynamicVariable variable : variablesToAdd) {
            variables.put(variable.getName(), new DynamicVariable.ResolverVariable((IStringVariable)variable, resolver));
        }
    }

    public static <TVariable extends IStringVariable> TVariable getChecked(Map<@NonNull String, ? extends TVariable> variables, String name) {
        @Nullable IStringVariable variable = (IStringVariable)variables.get(name);
        if (variable == null) {
            throw new RuntimeException(String.format("Required variable '$1%s' is missing", name));
        }
        return (TVariable)variable;
    }

    public static @Nullable String getValue(IStringVariable variable) throws CoreException {
        if (variable instanceof IValueVariable) {
            return ((IValueVariable)variable).getValue();
        }
        return ((IDynamicVariable)variable).getValue(null);
    }

    public static IDynamicVariable toStaticVariable(IStringVariable variable) {
        return VariableUtils.toStaticVariable(variable, variable);
    }

    public static IDynamicVariable toStaticVariable(IStringVariable defVariable, IStringVariable valueVariable) {
        try {
            String value = VariableUtils.getValue(valueVariable);
            return new StaticVariable(defVariable, value);
        }
        catch (CoreException exception) {
            return new UnresolvedVariable(defVariable, exception);
        }
    }
}

