/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.tex.core.builder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.docmlet.tex.core.TexBuildParticipant;
import org.eclipse.statet.docmlet.tex.core.TexCore;
import org.eclipse.statet.docmlet.tex.core.model.LtxSuModelContainer;
import org.eclipse.statet.docmlet.tex.core.model.TexSourceUnit;
import org.eclipse.statet.docmlet.tex.core.model.TexWorkspaceSourceUnit;
import org.eclipse.statet.internal.docmlet.tex.core.TexCorePlugin;
import org.eclipse.statet.internal.docmlet.tex.core.builder.LtxBuildReconciler;
import org.eclipse.statet.internal.docmlet.tex.core.builder.TexProjectBuilder;
import org.eclipse.statet.internal.docmlet.tex.core.builder.TexProjectTask;
import org.eclipse.statet.internal.docmlet.tex.core.model.LtxModelManager;
import org.eclipse.statet.ltk.core.LTK;
import org.eclipse.statet.ltk.model.core.ISourceUnitManager;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;

public class TexProjectBuild
extends TexProjectTask
implements IResourceVisitor,
IResourceDeltaVisitor {
    private final ISourceUnitManager suManager = LTK.getSourceUnitManager();
    private final MultiStatus status = new MultiStatus("org.eclipse.statet.docmlet.tex.core", 0, NLS.bind((String)"TeX build status for ''{0}''", (Object)this.getTexProject().getProject().getName()), null);
    private final List<TexWorkspaceSourceUnit> updatedLtxUnits = new ArrayList<TexWorkspaceSourceUnit>();
    private final List<VirtualSourceUnit> removedLtxFiles = new ArrayList<VirtualSourceUnit>();
    private SubMonitor visitProgress;

    public TexProjectBuild(TexProjectBuilder builder) {
        super(builder);
    }

    private void dispose(SubMonitor m) {
        m.setWorkRemaining(this.updatedLtxUnits.size());
        for (TexSourceUnit texSourceUnit : this.updatedLtxUnits) {
            texSourceUnit.disconnect((IProgressMonitor)m.newChild(1));
        }
    }

    public void build(int kind, SubMonitor m) throws CoreException {
        try {
            IResourceDelta delta;
            m.beginTask(NLS.bind((String)"Preparing TeX build for ''{0}''", (Object)this.getTexProject().getProject().getName()), 12);
            switch (kind) {
                case 9: 
                case 10: {
                    delta = this.getTexProjectBuilder().getDelta(this.getTexProject().getProject());
                    m.worked(1);
                    break;
                }
                default: {
                    delta = null;
                }
            }
            if (m.isCanceled()) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            m.setWorkRemaining(11);
            this.visitProgress = m.newChild(2);
            if (delta != null) {
                this.setBuildType(10);
                delta.accept((IResourceDeltaVisitor)this);
            } else {
                this.setBuildType(6);
                this.getTexProject().getProject().accept((IResourceVisitor)this);
            }
            this.visitProgress = null;
            if (m.isCanceled()) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            this.processLtxFiles(m.newChild(8, 0));
        }
        finally {
            m.setWorkRemaining(1);
            this.dispose(m.newChild(1));
            if (!this.status.isOK()) {
                TexCorePlugin.log((IStatus)this.status);
            }
        }
    }

    public boolean visit(IResourceDelta delta) throws CoreException {
        IResource resource = delta.getResource();
        if (resource.getType() == 1) {
            if (this.visitProgress.isCanceled()) {
                throw new CoreException(Status.CANCEL_STATUS);
            }
            this.visitProgress.setWorkRemaining(100);
            try {
                switch (delta.getKind()) {
                    case 1: 
                    case 4: {
                        this.visitFileAdded((IFile)resource, delta, this.visitProgress.newChild(1));
                        break;
                    }
                    case 2: {
                        this.visitFileRemove((IFile)resource, delta, this.visitProgress.newChild(1));
                        break;
                    }
                }
            }
            catch (Exception e) {
                this.status.add((IStatus)new Status(4, "org.eclipse.statet.docmlet.tex.core", NLS.bind((String)"An error occurred when checking file ''{0}''", (Object)resource.getFullPath()), (Throwable)e));
            }
        }
        return true;
    }

    public boolean visit(IResource resource) throws CoreException {
        if (resource.getType() == 1) {
            this.visitProgress.setWorkRemaining(100);
            this.visitFileAdded((IFile)resource, null, this.visitProgress.newChild(1));
        }
        return true;
    }

    private void visitFileAdded(IFile file, IResourceDelta delta, SubMonitor m) throws CoreException {
        IContentDescription contentDescription = file.getContentDescription();
        if (contentDescription == null) {
            return;
        }
        IContentType contentType = contentDescription.getContentType();
        if (contentType == null) {
            return;
        }
        if (contentType.isKindOf(TexCore.LTX_CONTENT_TYPE)) {
            ISourceUnit unit = this.suManager.getSourceUnit(LTK.PERSISTENCE_CONTEXT, (Object)file, contentType, true, (IProgressMonitor)m);
            if (unit instanceof TexWorkspaceSourceUnit) {
                this.updatedLtxUnits.add((TexWorkspaceSourceUnit)unit);
            } else {
                if (unit != null) {
                    unit.disconnect((IProgressMonitor)m);
                }
                this.clearLtx(file, null);
            }
        }
    }

    private void visitFileRemove(IFile file, IResourceDelta delta, SubMonitor m) throws CoreException {
    }

    private void processLtxFiles(SubMonitor m) throws CoreException {
        m.beginTask(NLS.bind((String)"Analyzing LaTeX file(s) of ''{0}''", (Object)this.getTexProject().getProject().getName()), 20);
        LtxModelManager ltxModelManager = TexCorePlugin.getInstance().getLtxModelManager();
        SubMonitor m1 = m.newChild(10);
        int workRemaining = this.removedLtxFiles.size() + this.updatedLtxUnits.size() * 5;
        for (VirtualSourceUnit unit : this.removedLtxFiles) {
            m1.setWorkRemaining(workRemaining--);
            try {
                TexBuildParticipant participant = this.getParticipant(unit.getModelTypeId());
                if (participant != null) {
                    participant.ltxUnitRemoved(unit.getResource(), (IProgressMonitor)m1.newChild(1));
                }
            }
            catch (Exception e) {
                this.status.add((IStatus)new Status(4, "org.eclipse.statet.docmlet.tex.core", 0, NLS.bind((String)"An error occurred when processing removed file ''{0}''.", (Object)unit.getResource()), (Throwable)e));
            }
            if (!m1.isCanceled()) continue;
            throw new CoreException(Status.CANCEL_STATUS);
        }
        if (!this.updatedLtxUnits.isEmpty()) {
            LtxBuildReconciler ltxReconciler = new LtxBuildReconciler(ltxModelManager);
            for (TexWorkspaceSourceUnit unit : this.updatedLtxUnits) {
                m1.setWorkRemaining(workRemaining);
                workRemaining -= 5;
                try {
                    TexBuildParticipant participant = this.getParticipant(unit.getModelTypeId());
                    this.clearLtx((IFile)unit.getResource(), participant);
                    LtxSuModelContainer adapter = (LtxSuModelContainer)((Object)unit.getAdapter(LtxSuModelContainer.class));
                    if (adapter != null) {
                        ltxReconciler.reconcile(adapter, 2, (IProgressMonitor)m1.newChild(3));
                        if (m1.isCanceled()) {
                            throw new CoreException(Status.CANCEL_STATUS);
                        }
                    }
                    if (participant != null && participant.isEnabled()) {
                        participant.ltxUnitUpdated(unit, (IProgressMonitor)m1.newChild(2));
                    }
                }
                catch (Exception e) {
                    this.status.add((IStatus)new Status(4, "org.eclipse.statet.docmlet.tex.core", 0, NLS.bind((String)"An error occurred when processing file ''{0}''.", (Object)unit.getResource()), (Throwable)e));
                }
                if (!m1.isCanceled()) continue;
                throw new CoreException(Status.CANCEL_STATUS);
            }
        }
        m1 = m.newChild(10);
        Collection<TexBuildParticipant> participants = this.getParticipants();
        int workRemaining2 = participants.size();
        for (TexBuildParticipant participant : participants) {
            m1.setWorkRemaining(workRemaining2--);
            if (!participant.isEnabled()) continue;
            try {
                participant.ltxFinished((IProgressMonitor)m1.newChild(1));
            }
            catch (Exception e) {
                this.status.add((IStatus)new Status(4, "org.eclipse.statet.docmlet.tex.core", 0, NLS.bind((String)"An error occurred when processing LaTeX file(s) in ''{0}''.", (Object)this.getTexProject().getProject().getName()), (Throwable)e));
            }
        }
    }

    private void clearLtx(IFile file, TexBuildParticipant partitipant) throws CoreException {
        if (partitipant != null) {
            partitipant.clear(file);
        }
    }

    private static final class VirtualSourceUnit {
        private final IFile file;
        private final String modelTypeId;

        public VirtualSourceUnit(IFile file, String modelTypeId) {
            this.file = file;
            this.modelTypeId = modelTypeId;
        }

        public IFile getResource() {
            return this.file;
        }

        public String getModelTypeId() {
            return this.modelTypeId;
        }

        public int hashCode() {
            return this.file.hashCode();
        }

        public String toString() {
            return this.file.toString();
        }
    }
}

