/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.pkgmanager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.r.ui.pkgmanager.Messages;
import org.eclipse.statet.internal.r.ui.pkgmanager.RPkgManagerDialog;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.Statuses;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.util.ToolMessageDialog;
import org.eclipse.statet.r.console.core.AbstractRDataRunnable;
import org.eclipse.statet.r.console.core.IRDataAdapter;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.pkgmanager.IRPkgManager;
import org.eclipse.statet.r.ui.pkgmanager.StartAction;
import org.eclipse.statet.rj.renv.core.REnv;
import org.eclipse.statet.rj.renv.runtime.RPkgManagerDataset;
import org.eclipse.statet.rj.services.RService;
import org.eclipse.statet.rj.ts.core.RTool;
import org.eclipse.statet.rj.ts.core.RToolService;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class RPkgManagerUI {
    private static final Map<REnv, RPkgManagerDialog> DIALOGS = new HashMap<REnv, RPkgManagerDialog>();
    private static final int REQUIRED_FEATURES = 49;

    private static Shell getShell(IShellProvider shellProvider) {
        Shell shell = null;
        if (shellProvider != null) {
            shell = shellProvider.getShell();
        }
        if (shell == null) {
            shell = UIAccess.getActiveWorkbenchShell((boolean)false);
        }
        return shell;
    }

    public static IRPkgManager getPackageManager(RTool tool) {
        REnv env;
        if (tool instanceof RProcess && (env = tool.getREnv()) != null) {
            return RCore.getRPkgManager((REnv)env);
        }
        return null;
    }

    public static Status openDialog(final RProcess tool, final Shell parentShell, int requestFlags, final StartAction startAction) {
        final IRPkgManager.Ext manager = (IRPkgManager.Ext)RPkgManagerUI.getPackageManager((RTool)tool);
        if (manager == null) {
            return new ErrorStatus("org.eclipse.statet.r.ui", "", null);
        }
        if (manager.request(0x31 | requestFlags) == 2) {
            tool.getQueue().add((ToolRunnable)new AbstractRDataRunnable("r/pkgmanager/open", Messages.OpenRPkgManager_task){

                protected void run(IRDataAdapter r, ProgressMonitor m) throws StatusException {
                    manager.update((RService)r, m);
                    UIAccess.getDisplay((Shell)parentShell).asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            RPkgManagerUI.openDialog(manager, tool, parentShell, startAction);
                        }
                    });
                }
            });
        } else {
            Display display = UIAccess.getDisplay((Shell)parentShell);
            if (display.getThread() == Thread.currentThread()) {
                RPkgManagerUI.openDialog(manager, tool, parentShell, startAction);
            } else {
                display.asyncExec(() -> {
                    RPkgManagerDialog rPkgManagerDialog = RPkgManagerUI.openDialog(manager, tool, parentShell, startAction);
                });
            }
        }
        return Statuses.OK_STATUS;
    }

    public static RPkgManagerDialog openDialog(IRPkgManager.Ext manager, RProcess tool, Shell parentShell, StartAction startAction) {
        final REnv rEnv = manager.getREnv();
        RPkgManagerDialog dialog = DIALOGS.get(rEnv);
        if (dialog != null && dialog.getShell() != null && !dialog.getShell().isDisposed()) {
            dialog.close();
        }
        dialog = new RPkgManagerDialog(manager, tool, parentShell);
        dialog.setBlockOnOpen(false);
        DIALOGS.put(rEnv, dialog);
        dialog.open();
        dialog.getShell().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                RPkgManagerDialog d = (RPkgManagerDialog)((Object)DIALOGS.get(rEnv));
                if (d != null && d.getShell() == e.getSource()) {
                    DIALOGS.remove(rEnv);
                }
            }
        });
        if (startAction != null) {
            dialog.start(startAction);
        }
        return dialog;
    }

    public static boolean requestRequiredRPkgs(final IRPkgManager.Ext manager, List<String> pkgNames, RToolService r, ProgressMonitor m, IShellProvider shellProvider, String message, final Runnable okRunnable, final Runnable cancelRunnable) throws StatusException {
        RPkgManagerDataset rPkgSet = manager.getDataset(1, (RService)r, m);
        final ArrayList<String> missingPkgs = new ArrayList<String>(pkgNames.size());
        final StringBuilder sb = new StringBuilder();
        for (String pkgName : pkgNames) {
            if (rPkgSet.getInstalled().contains(pkgName)) continue;
            missingPkgs.add(pkgName);
            sb.append("\n\t");
            sb.append(pkgName);
        }
        if (sb.length() == 0) {
            return true;
        }
        sb.insert(0, message);
        sb.append("\n\nDo you want to install the packages now?");
        final RProcess tool = (RProcess)r.getTool();
        final Shell shell = RPkgManagerUI.getShell(shellProvider);
        final Display display = shell != null ? shell.getDisplay() : UIAccess.getDisplay();
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                boolean yes = ToolMessageDialog.openQuestion((ToolProcess)tool, (Shell)shell, (String)"Required R Packages", (String)sb.toString());
                if (yes) {
                    RPkgManagerDialog dialog = RPkgManagerUI.openDialog(manager, tool, shell, new StartAction(2, missingPkgs));
                    if (okRunnable != null) {
                        dialog.getShell().addListener(21, new Listener(){

                            public void handleEvent(Event event) {
                                display.asyncExec(okRunnable);
                            }
                        });
                    }
                    return;
                }
                if (cancelRunnable != null) {
                    cancelRunnable.run();
                }
            }
        });
        return false;
    }
}

