/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.dataeditor;

import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.nico.core.util.ToolTerminateListener;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.ui.dataeditor.IRDataTableInput;
import org.eclipse.statet.rj.services.FQRObjectRef;
import org.eclipse.statet.rj.ts.core.RTool;

public class RToolDataTableInput
implements IRDataTableInput {
    private final RElementName elementName;
    private final String fullName;
    private final String shortName;
    private final FQRObjectRef elementRef;
    private final RTool tool;
    private ToolTerminateListener processListener;
    private final CopyOnWriteIdentityListSet<IRDataTableInput.StateListener> listeners = new CopyOnWriteIdentityListSet();

    public RToolDataTableInput(RElementName elementName, FQRObjectRef elementRef) {
        if (elementName == null) {
            throw new NullPointerException("name");
        }
        if (elementRef == null) {
            throw new NullPointerException("elementRef");
        }
        if (!(elementRef.getRHandle() instanceof RTool)) {
            throw new IllegalArgumentException("Unsupported elementRef.rHandle");
        }
        this.elementName = elementName;
        this.elementRef = elementRef;
        this.fullName = RElementName.createDisplayName((RElementName)elementName, (int)3);
        RElementName name = elementName;
        while (elementName.getNextSegment() != null) {
            if (elementName.getType() == 17) {
                name = elementName;
            }
            elementName = elementName.getNextSegment();
        }
        this.shortName = name.getDisplayName();
        this.tool = (RTool)elementRef.getRHandle();
    }

    @Override
    public RElementName getElementName() {
        return this.elementName;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getName() {
        return this.shortName;
    }

    @Override
    public FQRObjectRef getElementRef() {
        return this.elementRef;
    }

    @Override
    public Tool getTool() {
        return this.tool;
    }

    @Override
    public boolean isAvailable() {
        return !this.tool.isTerminated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addStateListener(IRDataTableInput.StateListener listener) {
        CopyOnWriteIdentityListSet<IRDataTableInput.StateListener> copyOnWriteIdentityListSet = this.listeners;
        synchronized (copyOnWriteIdentityListSet) {
            if (this.listeners.add((Object)listener) && this.processListener == null) {
                this.processListener = new ToolTerminateListener((Tool)this.tool){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void toolTerminated() {
                        ImIdentityList listeners;
                        CopyOnWriteIdentityListSet copyOnWriteIdentityListSet = RToolDataTableInput.this.listeners;
                        synchronized (copyOnWriteIdentityListSet) {
                            this.dispose();
                            RToolDataTableInput.this.processListener = null;
                            listeners = RToolDataTableInput.this.listeners.toList();
                        }
                        for (IRDataTableInput.StateListener listener : listeners) {
                            listener.tableUnavailable();
                        }
                    }
                };
                this.processListener.install();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeStateListener(IRDataTableInput.StateListener listener) {
        CopyOnWriteIdentityListSet<IRDataTableInput.StateListener> copyOnWriteIdentityListSet = this.listeners;
        synchronized (copyOnWriteIdentityListSet) {
            if (this.listeners.remove((Object)listener) && this.listeners.isEmpty() && this.processListener != null) {
                this.processListener.dispose();
                this.processListener = null;
            }
        }
    }

    public int hashCode() {
        return this.shortName.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof RToolDataTableInput)) {
            return false;
        }
        RToolDataTableInput other = (RToolDataTableInput)obj;
        return this == other || this.tool.equals(other.tool) && this.fullName.equals(other.fullName);
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "(" + this.fullName + " in " + this.tool.getLabel(1) + ")";
    }
}

