/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.dataeditor;

import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.statet.ecommons.databinding.core.validation.LongValidator;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.ui.dialogs.ExtStatusDialog;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.waltable.coordinate.LRange;
import org.eclipse.statet.ecommons.waltable.coordinate.Orientation;
import org.eclipse.statet.ecommons.waltable.viewport.IViewportDim;
import org.eclipse.statet.r.ui.dataeditor.RDataTableComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class GotoCellDialog
extends ExtStatusDialog {
    private final RDataTableComposite table;
    private final Text[] indexControls = new Text[2];
    private final LRange[] indexRanges = new LRange[2];
    private final IObservableValue<Long>[] indexValues = new IObservableValue[2];

    public GotoCellDialog(RDataTableComposite table) {
        super(table.getShell(), 2);
        this.table = table;
        this.setTitle("Go to Cell");
        this.setBlockOnOpen(true);
        this.setStatusLineAboveButtons(true);
        this.setHelpAvailable(false);
        Orientation[] orientationArray = Orientation.values();
        int n = orientationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Orientation orientation = orientationArray[n2];
            IViewportDim viewportDim = this.table.getViewport(orientation);
            this.indexRanges[orientation.ordinal()] = new LRange(viewportDim.getMinimumOriginPosition(), viewportDim.getScrollable().getPositionCount());
            this.indexValues[orientation.ordinal()] = new WritableValue((Object)(viewportDim.getOriginPosition() + 1L), Long.TYPE);
            ++n2;
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)LayoutUtils.newDialogGrid((int)2));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label.setText("&Row index:");
        Text text = new Text(composite, 2052);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.indexControls[Orientation.VERTICAL.ordinal()] = text;
        label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label.setText("Co&lumn index:");
        text = new Text(composite, 2052);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = LayoutUtils.hintWidth((Text)text, (int)25);
        text.setLayoutData((Object)gd);
        this.indexControls[Orientation.HORIZONTAL.ordinal()] = text;
        GotoCellDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void addBindings(DataBindingSupport db) {
        Orientation[] orientationArray = Orientation.values();
        int n = orientationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Orientation orientation = orientationArray[n2];
            LRange lRange = this.indexRanges[orientation.ordinal()];
            db.getContext().bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.indexControls[orientation.ordinal()]), this.indexValues[orientation.ordinal()], new UpdateValueStrategy().setAfterGetValidator((IValidator)new LongValidator(lRange.start + 1L, lRange.end, "Invalid " + this.getLabel(orientation) + " index (" + (lRange.start + 1L) + "\u2013" + lRange.end + ").")), null);
            this.indexControls[orientation.ordinal()].selectAll();
            ++n2;
        }
    }

    protected String getLabel(Orientation orientation) {
        return orientation == Orientation.HORIZONTAL ? "column" : "row";
    }

    public void set(Orientation orientation, long idx) {
        if (this.indexRanges[orientation.ordinal()].contains(idx)) {
            this.indexValues[orientation.ordinal()].setValue((Object)(idx + 1L));
        }
    }

    public long get(Orientation orientation) {
        return (Long)this.indexValues[orientation.ordinal()].getValue() - 1L;
    }
}

