/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.statet.ecommons.collections.FastList;
import org.eclipse.statet.ecommons.ts.ui.workbench.WorkbenchToolRegistry;
import org.eclipse.statet.ecommons.ts.ui.workbench.WorkbenchToolRegistryListener;
import org.eclipse.statet.ecommons.ts.ui.workbench.WorkbenchToolSessionData;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.nico.ui.PageRegistry;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.console.NIConsole;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;

public class ToolRegistry
implements WorkbenchToolRegistry,
IPageListener {
    static boolean DEBUG = false;
    private final Map<IWorkbenchPage, PageRegistry> fPageRegistries = new HashMap<IWorkbenchPage, PageRegistry>();
    private boolean isDisposed = false;
    private LaunchesListener fLaunchesListener;
    private JobListener fJobListener;
    private final FastList<WorkbenchToolRegistryListener> fListenersWorkbench = new FastList(WorkbenchToolRegistryListener.class, 1);

    public ToolRegistry() {
        this.fLaunchesListener = new LaunchesListener();
        this.fJobListener = new JobListener();
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)this.fLaunchesListener);
        Job.getJobManager().addJobChangeListener((IJobChangeListener)this.fJobListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)this.fLaunchesListener);
        Map<IWorkbenchPage, PageRegistry> map = this.fPageRegistries;
        synchronized (map) {
            this.fLaunchesListener = null;
            for (IWorkbenchPage page : this.fPageRegistries.keySet()) {
                page.getWorkbenchWindow().removePageListener((IPageListener)this);
                PageRegistry reg = this.fPageRegistries.get(page);
                reg.dispose();
            }
            this.fPageRegistries.clear();
            this.isDisposed = true;
        }
        Job.getJobManager().addJobChangeListener((IJobChangeListener)this.fJobListener);
        this.fJobListener = null;
        if (DEBUG) {
            System.out.println("[tool registry] registry closed.");
        }
    }

    public void pageOpened(IWorkbenchPage page) {
    }

    public void pageActivated(IWorkbenchPage page) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pageClosed(IWorkbenchPage page) {
        PageRegistry reg;
        Map<IWorkbenchPage, PageRegistry> map = this.fPageRegistries;
        synchronized (map) {
            page.getWorkbenchWindow().removePageListener((IPageListener)this);
            reg = this.fPageRegistries.remove(page);
        }
        reg.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PageRegistry getPageRegistry(IWorkbenchPage page) {
        if (page == null) {
            return null;
        }
        Map<IWorkbenchPage, PageRegistry> map = this.fPageRegistries;
        synchronized (map) {
            PageRegistry reg = this.fPageRegistries.get(page);
            if (reg == null && !this.isDisposed) {
                page.getWorkbenchWindow().addPageListener((IPageListener)this);
                WorkbenchToolRegistryListener[] listeners = (WorkbenchToolRegistryListener[])this.fListenersWorkbench.toArray();
                reg = new PageRegistry(page, listeners);
                this.fPageRegistries.put(page, reg);
            }
            return reg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PageRegistry[] getPageRegistries() {
        Map<IWorkbenchPage, PageRegistry> map = this.fPageRegistries;
        synchronized (map) {
            Collection<PageRegistry> collection = this.fPageRegistries.values();
            return collection.toArray(new PageRegistry[collection.size()]);
        }
    }

    public void addListener(WorkbenchToolRegistryListener listener, IWorkbenchPage page) {
        PageRegistry reg;
        if (page == null) {
            this.fListenersWorkbench.add((Object)listener);
        }
        if ((reg = this.getPageRegistry(page)) != null) {
            reg.fListeners.add((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(WorkbenchToolRegistryListener listener) {
        this.fListenersWorkbench.remove((Object)listener);
        Map<IWorkbenchPage, PageRegistry> map = this.fPageRegistries;
        synchronized (map) {
            for (PageRegistry reg : this.fPageRegistries.values()) {
                reg.fListeners.remove((Object)listener);
            }
        }
    }

    public void consoleActivated(IConsoleView consoleView, NIConsole console) {
        IWorkbenchPage page = consoleView.getViewSite().getPage();
        PageRegistry reg = this.getPageRegistry(page);
        if (reg != null) {
            reg.handleActiveConsoleChanged(console, (IViewPart)consoleView);
        }
    }

    public WorkbenchToolSessionData getActiveToolSession(IWorkbenchPage page) {
        if (page == null) {
            return null;
        }
        PageRegistry reg = this.getPageRegistry(page);
        if (reg != null) {
            return reg.createSessionInfo(null);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IWorkbenchPage findWorkbenchPage(Tool process) {
        IWorkbenchPage activePage = UIAccess.getActiveWorkbenchPage((boolean)false);
        IWorkbenchPage page = null;
        Map<IWorkbenchPage, PageRegistry> map = this.fPageRegistries;
        synchronized (map) {
            for (PageRegistry reg : this.fPageRegistries.values()) {
                if (reg.getActiveProcess() != process || (page = reg.getPage()) != activePage) continue;
                return page;
            }
        }
        if (page != null) {
            return page;
        }
        return activePage;
    }

    public IConsoleView getConsoleView(NIConsole console, IWorkbenchPage page) {
        PageRegistry reg = this.getPageRegistry(page);
        if (reg != null) {
            return reg.getConsoleView(console);
        }
        return null;
    }

    public void showConsole(NIConsole console, IWorkbenchPage page, boolean activate) {
        PageRegistry reg = this.getPageRegistry(page);
        if (reg != null) {
            reg.showConsole(console, activate);
        }
    }

    public void showConsoleExplicitly(NIConsole console, IWorkbenchPage page, boolean pin) {
        PageRegistry reg = this.getPageRegistry(page);
        if (reg != null) {
            reg.showConsoleExplicitly(console, pin);
        }
    }

    private static class JobListener
    implements IJobChangeListener {
        private static final String OWN_SHOWCONSOLE_NAME = "Show NIConsole";
        private static final String OTHER_SHOWCONSOLE_NAME = "Show Console View";
        private final AtomicInteger fOwnJobs = new AtomicInteger(0);

        private JobListener() {
        }

        public void scheduled(IJobChangeEvent event) {
            if (event.getJob().getName() == OWN_SHOWCONSOLE_NAME) {
                this.fOwnJobs.incrementAndGet();
            } else {
                this.checkJob(event.getJob());
            }
        }

        public void aboutToRun(IJobChangeEvent event) {
            this.checkJob(event.getJob());
        }

        public void done(IJobChangeEvent event) {
            if (event.getJob().getName() == OWN_SHOWCONSOLE_NAME) {
                this.fOwnJobs.decrementAndGet();
            }
        }

        private void checkJob(Job eventJob) {
            if (this.fOwnJobs.get() > 0 && eventJob.getName() == OTHER_SHOWCONSOLE_NAME) {
                eventJob.cancel();
                if (DEBUG) {
                    System.out.println("[tool registry] show job canceled");
                }
            }
        }

        public void sleeping(IJobChangeEvent event) {
        }

        public void awake(IJobChangeEvent event) {
        }

        public void running(IJobChangeEvent event) {
        }
    }

    private class LaunchesListener
    implements ILaunchesListener {
        private LaunchesListener() {
        }

        public void launchesAdded(ILaunch[] launches) {
        }

        public void launchesChanged(ILaunch[] launches) {
        }

        public void launchesRemoved(ILaunch[] launches) {
            PageRegistry[] registries;
            ArrayList<ToolProcess> list = new ArrayList<ToolProcess>();
            ILaunch[] iLaunchArray = launches;
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                IProcess[] processes;
                ILaunch launch = iLaunchArray[n2];
                IProcess[] iProcessArray = processes = launch.getProcesses();
                int n3 = processes.length;
                int n4 = 0;
                while (n4 < n3) {
                    IProcess process = iProcessArray[n4];
                    if (process instanceof ToolProcess) {
                        list.add((ToolProcess)process);
                    }
                    ++n4;
                }
                ++n2;
            }
            if (list.isEmpty()) {
                return;
            }
            PageRegistry[] pageRegistryArray = registries = ToolRegistry.this.getPageRegistries();
            int n5 = registries.length;
            n = 0;
            while (n < n5) {
                PageRegistry reg = pageRegistryArray[n];
                reg.handleConsolesRemoved(list);
                ++n;
            }
            this.removeConsoles(list);
        }

        private void removeConsoles(List<ToolProcess> processes) {
            IConsole[] consoles;
            ArrayList<IConsole> toRemove = new ArrayList<IConsole>();
            IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
            IConsole[] iConsoleArray = consoles = manager.getConsoles();
            int n = consoles.length;
            int n2 = 0;
            while (n2 < n) {
                IConsole console = iConsoleArray[n2];
                if (console instanceof NIConsole && processes.contains(((NIConsole)console).getProcess())) {
                    toRemove.add(console);
                }
                ++n2;
            }
            manager.removeConsoles(toRemove.toArray(new IConsole[toRemove.size()]));
        }
    }
}

