/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rtm.base.ui.rexpr;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.IObserving;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.AbstractObservableValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.databinding.IEMFObservable;
import org.eclipse.emf.databinding.edit.EMFEditProperties;
import org.eclipse.emf.databinding.edit.IEMFEditListProperty;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableValueEditingSupport;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.statet.ecommons.emf.core.IContext;
import org.eclipse.statet.ecommons.emf.core.databinding.IEMFEditContext;
import org.eclipse.statet.ecommons.emf.core.databinding.IEMFEditPropertyContext;
import org.eclipse.statet.ecommons.emf.ui.forms.EFProperty;
import org.eclipse.statet.ecommons.emf.ui.forms.IEFFormPage;
import org.eclipse.statet.ecommons.ui.components.ButtonGroup;
import org.eclipse.statet.ecommons.ui.content.ElementSourceSelectionProvider;
import org.eclipse.statet.ecommons.ui.util.SelectionTransferDragAdapter;
import org.eclipse.statet.ecommons.ui.viewers.ViewerUtils;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rtm.base.ui.editors.RtFormToolkit;
import org.eclipse.statet.rtm.base.ui.rexpr.IRExprTypesUIProvider;
import org.eclipse.statet.rtm.base.ui.rexpr.RExpr2StringConverter;
import org.eclipse.statet.rtm.base.ui.rexpr.RExprLabelProvider;
import org.eclipse.statet.rtm.base.ui.rexpr.RExprTypeUIAdapter;
import org.eclipse.statet.rtm.base.ui.rexpr.RExprViewerDropAdapter;
import org.eclipse.statet.rtm.base.ui.rexpr.String2RTypedExprConverter;
import org.eclipse.statet.rtm.base.util.RExprTypes;
import org.eclipse.statet.rtm.rtdata.types.RTypedExpr;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class RExprListProperty
extends EFProperty
implements ButtonGroup.IActions<RTypedExpr> {
    private final IRExprTypesUIProvider provider;
    private final RExprTypes types;
    private List<RExprTypeUIAdapter> typeUIAdapters;
    private ViewerUtils.TableComposite widget;
    private ButtonGroup<RTypedExpr> buttonGroup;
    private IObservableList<RTypedExpr> modelObservable;

    public RExprListProperty(String label, String tooltip, EClass eClass, EStructuralFeature eFeature, IRExprTypesUIProvider provider) {
        super(label, tooltip, eClass, eFeature);
        this.provider = provider;
        this.types = provider.getTypes(this.getEClass(), this.getEFeature());
    }

    protected IRExprTypesUIProvider getProvider() {
        return this.provider;
    }

    @Override
    public void create(Composite parent, IEFFormPage page) {
        IRExprTypesUIProvider provider = this.getProvider();
        this.typeUIAdapters = provider.getUIAdapters(this.types, this.getEClass(), this.getEFeature());
        RtFormToolkit toolkit = (RtFormToolkit)page.getToolkit();
        toolkit.createPropLabel(parent, this.getLabel(), this.getTooltip(), 3);
        this.widget = toolkit.createPropSingleColumnTable(parent, 6, 25);
        this.widget.viewer.setContentProvider((IContentProvider)new ObservableListContentProvider());
        ViewerColumn column = this.widget.getViewerColumn(0);
        column.setLabelProvider((CellLabelProvider)new RExprLabelProvider(this.typeUIAdapters));
        this.buttonGroup = new ButtonGroup(parent, (ButtonGroup.IActions)this, true);
        this.buttonGroup.setLayoutData((Object)new GridData(4, 4, false, false));
        this.customizeButtonGroup(this.buttonGroup);
    }

    protected void customizeButtonGroup(ButtonGroup<RTypedExpr> buttonGroup) {
        buttonGroup.addAddButton(null);
        buttonGroup.addDeleteButton(null);
        buttonGroup.addSeparator();
        buttonGroup.addUpButton(null);
        buttonGroup.addDownButton(null);
    }

    @Override
    public Control getControl() {
        return this.widget;
    }

    public TableViewer getViewer() {
        return this.widget.viewer;
    }

    public RTypedExpr edit(int command, RTypedExpr item, Object parent) {
        switch (command) {
            case 1: {
                return new RTypedExpr(this.types.getDefaultTypeKey(), "");
            }
            case 4: {
                return item;
            }
        }
        return null;
    }

    public void updateState(IStructuredSelection selection) {
    }

    @Override
    public void bind(IEMFEditContext context) {
        super.bind(context);
        IEMFEditListProperty emfProperty = EMFEditProperties.list((EditingDomain)this.getEditingDomain(), (EStructuralFeature)this.getEFeature());
        this.modelObservable = emfProperty.observeDetail(this.getBaseObservable());
        this.widget.viewer.setInput(this.modelObservable);
        this.buttonGroup.connectTo((StructuredViewer)this.widget.viewer, this.modelObservable, null);
        ViewerColumn column = this.widget.getViewerColumn(0);
        column.setEditingSupport((EditingSupport)new RExprEditing());
        ViewerUtils.installDefaultEditBehaviour2((TableViewer)this.widget.viewer);
        ElementSourceSelectionProvider extSelectionProvider = new ElementSourceSelectionProvider((IPostSelectionProvider)this.widget.viewer, (Object)this);
        int operations = 19;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.widget.viewer.addDragSupport(19, transfers, (DragSourceListener)new SelectionTransferDragAdapter((ISelectionProvider)extSelectionProvider));
        this.widget.viewer.addDropSupport(19, transfers, (DropTargetListener)new RExprViewerDropAdapter((Viewer)this.widget.viewer, this.typeUIAdapters, (IContext)this){

            @Override
            protected boolean canMove(IContext source, Object input) {
                IEMFEditPropertyContext sourcePropertyContext = (IEMFEditPropertyContext)source.getAdapter(IEMFEditPropertyContext.class);
                return sourcePropertyContext != null && RExprListProperty.this.getEditingDomain() == sourcePropertyContext.getEditingDomain();
            }

            @Override
            protected int getIndex(Object element) {
                return RExprListProperty.this.modelObservable.indexOf(element);
            }

            @Override
            protected void insertExprs(List<RTypedExpr> exprs, int index, int time) {
                if (index >= 0) {
                    RExprListProperty.this.modelObservable.addAll(index, exprs);
                } else {
                    RExprListProperty.this.modelObservable.addAll(exprs);
                }
            }

            @Override
            protected void moveExprs(IContext source, List<RTypedExpr> exprs, int index, int time) {
                Command command;
                IEMFEditPropertyContext sourceContext = (IEMFEditPropertyContext)source;
                EObject owner = (EObject)((IObserving)RExprListProperty.this.modelObservable).getObserved();
                IObservable sourceObservable = sourceContext.getPropertyObservable();
                if (owner == null || sourceObservable == null) {
                    return;
                }
                if (sourceObservable == RExprListProperty.this.modelObservable) {
                    if (exprs.size() == 1) {
                        RTypedExpr expr = exprs.get(0);
                        int oldIndex = this.getIndex(expr);
                        if (oldIndex < 0) {
                            return;
                        }
                        command = MoveCommand.create((EditingDomain)RExprListProperty.this.getEditingDomain(), (Object)owner, (Object)RExprListProperty.this.getEFeature(), (Object)expr, (int)(oldIndex < index ? index - 1 : index));
                    } else {
                        CompoundCommand compound = new CompoundCommand();
                        ArrayList<RTypedExpr> after = new ArrayList<RTypedExpr>(exprs.size());
                        for (RTypedExpr expr : exprs) {
                            int oldIndex = this.getIndex(expr);
                            if (oldIndex < 0) continue;
                            if (oldIndex < index) {
                                compound.append(MoveCommand.create((EditingDomain)RExprListProperty.this.getEditingDomain(), (Object)owner, (Object)RExprListProperty.this.getEFeature(), (Object)expr, (int)(index - 1)));
                                continue;
                            }
                            after.add(expr);
                        }
                        for (RTypedExpr expr : after) {
                            compound.append(MoveCommand.create((EditingDomain)RExprListProperty.this.getEditingDomain(), (Object)owner, (Object)RExprListProperty.this.getEFeature(), (Object)expr, (int)index));
                        }
                        command = compound;
                    }
                } else {
                    EObject oldOwner = (EObject)((IObserving)sourceObservable).getObserved();
                    CompoundCommand compound = new CompoundCommand();
                    compound.append(AddCommand.create((EditingDomain)RExprListProperty.this.getEditingDomain(), (Object)owner, (Object)RExprListProperty.this.getEFeature(), exprs));
                    compound.append(RemoveCommand.create((EditingDomain)RExprListProperty.this.getEditingDomain(), (Object)oldOwner, (Object)sourceContext.getEFeature(), exprs));
                    command = compound;
                }
                RExprListProperty.this.getEditingDomain().getCommandStack().execute(command);
            }
        });
        if (!this.modelObservable.isEmpty()) {
            this.widget.viewer.setSelection((ISelection)new StructuredSelection(this.modelObservable.get(0)));
        } else {
            this.buttonGroup.updateState();
        }
    }

    protected int getIndex(Object element) {
        int i = 0;
        while (i < this.modelObservable.size()) {
            if (this.modelObservable.get(i) == element) {
                return i;
            }
            ++i;
        }
        return this.modelObservable.indexOf(element);
    }

    public IObservableList getPropertyObservable() {
        return this.modelObservable;
    }

    private class RExprEditing
    extends ObservableValueEditingSupport<RTypedExpr, RTypedExpr, String> {
        private CellEditor cellEditor;

        public RExprEditing() {
            super((ColumnViewer)((RExprListProperty)RExprListProperty.this).widget.viewer, RExprListProperty.this.getDataBindingContext());
        }

        protected CellEditor getCellEditor(Object element) {
            if (element instanceof RTypedExpr) {
                if (this.cellEditor == null) {
                    this.cellEditor = this.createRExprCellEditor();
                }
                return this.cellEditor;
            }
            return null;
        }

        protected CellEditor createRExprCellEditor() {
            TextCellEditor editor = new TextCellEditor((Composite)this.getViewer().getControl());
            return editor;
        }

        protected IObservableValue<String> doCreateCellEditorObservable(CellEditor cellEditor) {
            return WidgetProperties.text((int)24).observe((Widget)((TextCellEditor)this.cellEditor).getControl());
        }

        protected Binding createBinding(IObservableValue<String> target, IObservableValue<RTypedExpr> model) {
            return RExprListProperty.this.getDataBindingContext().bindValue(target, model, new UpdateValueStrategy(UpdateValueStrategy.POLICY_CONVERT).setConverter((IConverter)new String2RTypedExprConverter(RExprListProperty.this.types.getDefaultTypeKey())), new UpdateValueStrategy().setConverter((IConverter)new RExpr2StringConverter()));
        }

        protected IObservableValue<RTypedExpr> doCreateElementObservable(RTypedExpr element, ViewerCell cell) {
            return new AbstractObservableValue<RTypedExpr>(element){
                RTypedExpr value;
                {
                    this.value = rTypedExpr;
                }

                public Object getValueType() {
                    return RTypedExpr.class;
                }

                protected RTypedExpr doGetValue() {
                    return this.value;
                }

                protected void doSetValue(@Nullable RTypedExpr value) {
                    int index = RExprListProperty.this.getIndex(value);
                    CommandStack commandStack = RExprListProperty.this.getEditingDomain().getCommandStack();
                    IEMFObservable emfObservable = (IEMFObservable)RExprListProperty.this.modelObservable;
                    if (value == null) {
                        if (index >= 0) {
                            RExprListProperty.this.modelObservable.remove(index);
                        }
                        return;
                    }
                    if (index < 0) {
                        RExprListProperty.this.modelObservable.add((Object)value);
                        return;
                    }
                    Command command = SetCommand.create((EditingDomain)RExprListProperty.this.getEditingDomain(), (Object)emfObservable.getObserved(), (Object)RExprListProperty.this.getEFeature(), (Object)value, (int)index);
                    commandStack.execute(command);
                }
            };
        }
    }
}

