/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.pkgmanager;

import java.util.ArrayList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.rj.renv.core.RPkg;
import org.eclipse.statet.rj.renv.core.RPkgList;
import org.eclipse.statet.rj.renv.core.RPkgUtils;

@NonNullByDefault
public final class RPkgListImpl<T extends RPkg>
extends ArrayList<T>
implements RPkgList<T> {
    private static final long serialVersionUID = -3022375551268568786L;

    public RPkgListImpl(int capacity) {
        super(capacity);
    }

    public int indexOf(@Nullable String name) {
        if (name == null) {
            return -1;
        }
        int low = 0;
        int high = super.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int diff = RPkgUtils.NAMES_COLLATOR.compare(((RPkg)super.get(mid)).getName(), name);
            if (diff < 0) {
                low = mid + 1;
                continue;
            }
            if (diff > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int indexOf(String name, int low) {
        int high = super.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int diff = RPkgUtils.NAMES_COLLATOR.compare(((RPkg)super.get(mid)).getName(), name);
            if (diff < 0) {
                low = mid + 1;
                continue;
            }
            if (diff > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    @Override
    public int indexOf(@Nullable Object o) {
        if (o instanceof RPkg) {
            return this.indexOf(((RPkg)o).getName());
        }
        return -1;
    }

    public boolean contains(@Nullable String name) {
        return this.indexOf(name) >= 0;
    }

    public @Nullable T get(@Nullable String name) {
        int idx = this.indexOf(name);
        return (T)(idx >= 0 ? (RPkg)super.get(idx) : null);
    }

    @Override
    public boolean add(T pkg) {
        int idx = this.indexOf(pkg.getName());
        if (idx < 0) {
            super.add(-idx - 1, pkg);
            return true;
        }
        return false;
    }

    @Override
    public void add(int index, T element) {
        super.add(index, (RPkg)ObjectUtils.nonNullAssert(element));
    }

    public void set(T pkg) {
        int idx = this.indexOf(pkg.getName());
        if (idx < 0) {
            super.add(-idx - 1, pkg);
        } else {
            this.set(idx, pkg);
        }
    }

    public void remove(String name) {
        int idx = this.indexOf(name);
        if (idx >= 0) {
            this.remove(idx);
        }
    }
}

