/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.core.builder;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.eclipse.statet.internal.r.core.builder.CompositeFrame;
import org.eclipse.statet.internal.r.core.builder.ExportedRElement;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.r.core.model.IRElement;
import org.eclipse.statet.r.core.model.IRFrame;
import org.eclipse.statet.r.core.model.IRLangElement;
import org.eclipse.statet.r.core.model.IRSourceUnit;
import org.eclipse.statet.r.core.model.RElementName;

public class RUnitElement
implements IRLangElement,
Serializable {
    private static final long serialVersionUID = 2909953007129363256L;
    private transient ISourceUnit sourceUnit;
    transient CompositeFrame envir;
    private List<IRLangElement> elements;

    public static RUnitElement read(IRSourceUnit su, CompositeFrame envir, InputStream input) throws IOException, ClassNotFoundException {
        ObjectInputStream o = new ObjectInputStream(input);
        RUnitElement element = (RUnitElement)o.readObject();
        element.sourceUnit = su;
        element.envir = envir;
        return element;
    }

    public RUnitElement(IRSourceUnit su, List<IRLangElement> children) {
        this.sourceUnit = su;
        this.elements = Collections.unmodifiableList(children);
    }

    public RUnitElement() {
    }

    public String getModelTypeId() {
        return "R";
    }

    public int getElementType() {
        return 528;
    }

    @Override
    public RElementName getElementName() {
        ElementName elementName = this.sourceUnit.getElementName();
        if (elementName instanceof RElementName) {
            return (RElementName)elementName;
        }
        return RElementName.create(15, elementName.getSegmentName());
    }

    public String getId() {
        return this.sourceUnit.getId();
    }

    public boolean exists() {
        return true;
    }

    public boolean isReadOnly() {
        return this.sourceUnit.isReadOnly();
    }

    public ISourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    @Override
    public IRElement getModelParent() {
        return null;
    }

    @Override
    public boolean hasModelChildren(IModelElement.Filter filter) {
        return ExportedRElement.hasChildren(this.elements, filter);
    }

    @Override
    public List<? extends IRLangElement> getModelChildren(IModelElement.Filter filter) {
        return ExportedRElement.getChildren(this.elements, filter);
    }

    public <T> T getAdapter(Class<T> adapterType) {
        if (adapterType == IRFrame.class) {
            return (T)this.envir;
        }
        return null;
    }

    public void save(OutputStream outputStream) throws IOException {
        ObjectOutputStream o = new ObjectOutputStream(outputStream);
        o.writeObject(this);
        o.flush();
    }

    public TextRegion getSourceRange() {
        return null;
    }

    public TextRegion getNameSourceRange() {
        return null;
    }

    public TextRegion getDocumentationRange() {
        return null;
    }
}

