/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rhelp.core.http.jetty;

import java.util.concurrent.Executor;
import javax.servlet.ServletContext;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rhelp.core.http.MimeTypes;
import org.eclipse.statet.rhelp.core.http.ResourceHandler;
import org.eclipse.statet.rhelp.core.http.ServletMimeTypes;
import org.eclipse.statet.rhelp.core.http.jetty.JettyResourceHandler;

@NonNullByDefault
public class JettyRHelpUtils {
    private static final String JETTY_EXECUTOR_KEY = "org.eclipse.jetty.server.Executor";
    private static @Nullable Executor executor;

    public static MimeTypes getMimeTypes(ServletContext context) {
        return new ServletMimeTypes(context);
    }

    public static ResourceHandler newResourceHandler(MimeTypes mimeTypes) {
        return new JettyResourceHandler(mimeTypes);
    }

    public static ResourceHandler newResourceHandler(ServletContext context) {
        return JettyRHelpUtils.newResourceHandler(JettyRHelpUtils.getMimeTypes(context));
    }

    public static synchronized Executor getExecutor() {
        Executor executor = JettyRHelpUtils.executor;
        if (executor == null) {
            JettyRHelpUtils.executor = executor = new QueuedThreadPool(16, 2);
        }
        return executor;
    }

    public static void ensureExecutor(ServletContext context) {
        if (context.getAttribute(JETTY_EXECUTOR_KEY) == null) {
            context.setAttribute(JETTY_EXECUTOR_KEY, (Object)JettyRHelpUtils.getExecutor());
        }
    }

    private JettyRHelpUtils() {
    }
}

