/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.rhelp;

import java.net.URI;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.statet.ecommons.runtime.core.util.StatusUtils;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpInfoHoverCreator;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpLtkUI;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.InterruptNullProgressMonitor;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ast.core.util.AstSelection;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.InfoHover;
import org.eclipse.statet.r.core.RCore;
import org.eclipse.statet.r.core.model.IRSourceUnit;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.rsource.ast.FCall;
import org.eclipse.statet.r.core.rsource.ast.NodeType;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.rhelp.core.REnvHelp;
import org.eclipse.statet.rhelp.core.RPkgHelp;
import org.eclipse.swt.widgets.Control;

@NonNullByDefault
public class RHelpHover
implements InfoHover {
    private final int mode;

    public RHelpHover() {
        this(1);
    }

    public RHelpHover(int mode) {
        this.mode = mode;
    }

    public @Nullable Object getHoverInfo(AssistInvocationContext context, ProgressMonitor m) throws StatusException {
        REnvHelp help;
        m.beginSubTask("Looking up R help...");
        AstSelection astSelection = context.getAstSelection();
        if (!(astSelection.getCovering() instanceof RAstNode)) {
            return null;
        }
        IRSourceUnit rSourceUnit = context.getSourceUnit() instanceof IRSourceUnit ? (IRSourceUnit)context.getSourceUnit() : null;
        RAstNode rNode = (RAstNode)astSelection.getCovering();
        RElementName name = RHelpLtkUI.searchName(rNode, (TextRegion)context, true);
        if ((this.mode & 0x10) != 0 && name == null) {
            switch (rNode.getNodeType()) {
                case STRING_CONST: 
                case SYMBOL: {
                    RAstNode parent = rNode.getRParent();
                    if (parent == null || parent.getNodeType() != NodeType.F_CALL_ARG || ((FCall.Arg)parent).getNameChild() != rNode) break;
                    name = RHelpLtkUI.searchNameOfFunction(parent, (TextRegion)context);
                    break;
                }
                case F_CALL: 
                case F_CALL_ARGS: 
                case F_CALL_ARG: {
                    name = RHelpLtkUI.searchNameOfFunction(rNode, (TextRegion)context);
                    break;
                }
            }
        }
        if (name == null || m.isCanceled()) {
            return null;
        }
        Object helpObject = null;
        try {
            help = RHelpLtkUI.getEnvHelp(rSourceUnit);
        }
        catch (StatusException e) {
            return false;
        }
        try {
            try {
                if (RElementName.isPackageFacetScopeType((int)name.getType())) {
                    helpObject = help.getPkgHelp(name.getSegmentName());
                } else {
                    RPkgHelp pkgHelp;
                    if (name.getScope() != null && RElementName.isPackageFacetScopeType((int)name.getScope().getType()) && (pkgHelp = help.getPkgHelp(name.getScope().getSegmentName())) != null) {
                        helpObject = pkgHelp.getPageForTopic(name.getSegmentName());
                    }
                    if (helpObject == null && (helpObject = RHelpLtkUI.searchTopicObject1(help, name.getSegmentName(), (RAstNode)astSelection.getCovering(), rSourceUnit)) == null && !m.isCanceled()) {
                        helpObject = m instanceof InterruptNullProgressMonitor ? this.doSearch2Safe(help, name.getSegmentName(), m) : RHelpLtkUI.searchTopicObject2(help, name.getSegmentName(), m);
                    }
                }
            }
            catch (CoreException e) {
                help.unlock();
                return null;
            }
        }
        finally {
            help.unlock();
        }
        if (helpObject == null || m.isCanceled()) {
            return null;
        }
        URI httpUrl = RCore.getRHelpHttpService().toHttpUrl(helpObject, "info");
        if (httpUrl != null) {
            return new RHelpInfoHoverCreator.Data((Control)context.getSourceViewer().getTextWidget(), helpObject, httpUrl);
        }
        return null;
    }

    private @Nullable Object doSearch2Safe(REnvHelp help, String topic, ProgressMonitor m) {
        class SafeJob
        extends Job {
            Object helpObject;
            private final /* synthetic */ REnvHelp val$help;
            private final /* synthetic */ String val$topic;

            public SafeJob(String string, REnvHelp rEnvHelp) {
                this.val$topic = string;
                this.val$help = rEnvHelp;
                super(String.format("Lookup R Help for '%1$s'", string));
                this.setPriority(20);
                this.setUser(false);
            }

            protected IStatus run(IProgressMonitor monitor) {
                ProgressMonitor m = StatusUtils.convert((IProgressMonitor)monitor);
                try {
                    this.helpObject = RHelpLtkUI.searchTopicObject2(this.val$help, this.val$topic, m);
                    return Status.OK_STATUS;
                }
                catch (StatusException e) {
                    return Status.CANCEL_STATUS;
                }
            }
        }
        SafeJob job = new SafeJob(topic, help);
        job.schedule();
        while (true) {
            try {
                job.join();
                return job.helpObject;
            }
            catch (InterruptedException e) {
                m.setCanceled(true);
                if (!m.isCanceled() || !job.cancel()) continue;
                return null;
            }
            break;
        }
    }

    public IInformationControlCreator getHoverControlCreator() {
        return new RHelpInfoHoverCreator(this.mode);
    }
}

