/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.pkgmanager;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.r.ui.pkgmanager.RLibrarySelectionComposite;
import org.eclipse.statet.internal.r.ui.pkgmanager.StatusPage;
import org.eclipse.statet.internal.r.ui.pkgmanager.SummaryPage;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.r.core.pkgmanager.IRPkgManager;
import org.eclipse.statet.r.core.pkgmanager.RPkgAction;
import org.eclipse.statet.r.core.pkgmanager.RPkgActionHelper;
import org.eclipse.statet.r.core.pkgmanager.RPkgResolver;
import org.eclipse.statet.r.core.pkgmanager.RPkgUtils;
import org.eclipse.statet.rj.renv.core.RLibLocation;
import org.eclipse.statet.rj.renv.runtime.RuntimeRLibPaths;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class InstallPkgsWizard
extends Wizard {
    static final int MODE_INSTALL = 1;
    static final int MODE_UPDATE = 2;
    static final int MODE_REINSTALL = 3;
    private final Tool rTool;
    private final IRPkgManager.Ext rPkgManager;
    private Page page;
    private StatusPage statusPage;
    private SummaryPage summaryPage;
    private final RPkgResolver resolver;
    private List<RPkgAction.Install> actions;
    private RPkgActionHelper actionsHelper;
    private final int mode;
    private final String title;

    public InstallPkgsWizard(Tool rTool, IRPkgManager.Ext manager, int mode, RPkgResolver plan) {
        this.rTool = rTool;
        this.rPkgManager = manager;
        this.mode = mode;
        switch (this.mode) {
            case 1: {
                this.title = "Install Selected R Packages";
                break;
            }
            case 2: {
                this.title = "Update Selected R Packages";
                break;
            }
            case 3: {
                this.title = "Reinstall R Packages";
                break;
            }
            default: {
                throw new IllegalArgumentException("mode");
            }
        }
        this.resolver = plan;
        this.setWindowTitle("R Package Manager");
        this.setNeedsProgressMonitor(true);
        this.setDialogSettings(DialogUtils.getDialogSettings((AbstractUIPlugin)RUIPlugin.getInstance(), (String)"pkgmanager/InstallPkgsWizard"));
    }

    public void addPages() {
        if (this.resolver.getStatus().getSeverity() >= 2) {
            this.statusPage = new StatusPage(this.title, true);
            this.statusPage.setStatus(this.resolver.getStatus());
            this.addPage((IWizardPage)this.statusPage);
        }
        if (this.mode != 3) {
            this.page = new Page();
            this.addPage((IWizardPage)this.page);
        }
        this.summaryPage = new SummaryPage(this.rPkgManager, this.resolver, this.title){

            @Override
            public void updateInput() {
                this.setActions(InstallPkgsWizard.this.getActions(InstallPkgsWizard.this.createHelper()));
            }
        };
        this.addPage((IWizardPage)this.summaryPage);
    }

    private List<? extends RPkgAction> getActions(RPkgActionHelper helper) {
        if (this.actions == null) {
            this.actions = this.resolver.createActions();
        }
        if (this.actionsHelper == null || !this.actionsHelper.equals((Object)helper)) {
            this.actionsHelper = helper;
            helper.update(this.actions);
        }
        return this.actions;
    }

    private RPkgActionHelper createHelper() {
        switch (this.mode) {
            case 3: {
                return new RPkgActionHelper(true, null, this.rPkgManager.getRLibPaths());
            }
        }
        return new RPkgActionHelper(this.page.getInstallSameLocation(), this.page.getInstallTargetLocation(), this.rPkgManager.getRLibPaths());
    }

    public boolean performFinish() {
        final RPkgActionHelper helper = this.createHelper();
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    List actions = InstallPkgsWizard.this.getActions(helper);
                    InstallPkgsWizard.this.rPkgManager.perform(InstallPkgsWizard.this.rTool, actions);
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    class Page
    extends WizardPage {
        private Button sameTargetControl;
        private RLibrarySelectionComposite selectTargetControl;
        private IObservableValue<Boolean> sameTargetValue;
        private IObservableValue<RLibLocation> targetLibraryValue;

        public Page() {
            super("InstallPkgsTargetPage");
            this.setTitle(InstallPkgsWizard.this.title);
            this.setDescription("Select the target location.");
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite composite = new Composite(parent, 0);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            composite.setLayout((Layout)LayoutUtils.newContentGrid((int)1));
            RuntimeRLibPaths rLibPaths = InstallPkgsWizard.this.rPkgManager.getRLibPaths();
            Group group = new Group(composite, 0);
            group.setLayoutData((Object)new GridData(4, 4, true, true));
            group.setText("Target Library:");
            group.setLayout((Layout)LayoutUtils.newGroupGrid((int)1));
            this.selectTargetControl = new RLibrarySelectionComposite((Composite)group);
            this.selectTargetControl.setLayoutData(this.selectTargetControl.createGD());
            this.selectTargetControl.getValidator().setWritable(true);
            this.selectTargetControl.setInput(rLibPaths);
            if (InstallPkgsWizard.this.mode == 2) {
                this.sameTargetControl = new Button((Composite)group, 32);
                this.sameTargetControl.setText("Install updates to the library of the installed package, if possible.");
                this.sameTargetControl.setLayoutData((Object)new GridData(4, 4, true, false));
            }
            Dialog.applyDialogFont((Control)composite);
            this.setControl((Control)composite);
            DataBindingSupport databinding = new DataBindingSupport((Control)composite);
            this.addBindings(databinding);
            this.targetLibraryValue.setValue((Object)RPkgUtils.getDefaultInstallLocation((RuntimeRLibPaths)rLibPaths));
            WizardPageSupport.create((WizardPage)this, (DataBindingContext)databinding.getContext());
        }

        protected void addBindings(DataBindingSupport databinding) {
            if (this.sameTargetControl != null) {
                this.sameTargetValue = new WritableValue(databinding.getRealm(), (Object)Boolean.FALSE, Boolean.class);
                databinding.getContext().bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.sameTargetControl), this.sameTargetValue, null, null);
            }
            this.targetLibraryValue = new WritableValue(databinding.getRealm(), null, RLibLocation.class);
            databinding.getContext().bindValue((IObservableValue)ViewersObservables.observeSingleSelection((Viewer)this.selectTargetControl.getSelectionViewer()), this.targetLibraryValue, new UpdateValueStrategy().setAfterGetValidator((IValidator)this.selectTargetControl.getValidator()), null);
        }

        public boolean getInstallSameLocation() {
            return this.sameTargetValue != null && (Boolean)this.sameTargetValue.getValue() != false;
        }

        public RLibLocation getInstallTargetLocation() {
            return (RLibLocation)this.targetLibraryValue.getValue();
        }
    }
}

