/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.mylyn.wikitext.parser.IdGenerator;
import org.eclipse.statet.docmlet.wikitext.commonmark.core.ParseHelper;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlocks;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.InlineParser;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class ProcessingContext {
    public static final int INITIALIZE_CONTEXT = 1;
    public static final int EMIT_DOCUMENT = 2;
    public static final int PARSE_SOURCE_STRUCT = 3;
    private int mode;
    private final SourceBlocks sourceBlocks;
    private final InlineParser inlineParser;
    private final Map<String, UriWithTitle> links;
    private final IdGenerator idGenerator;
    private @Nullable ParseHelper parseHelper;

    public ProcessingContext(SourceBlocks sourceBlocks, InlineParser inlineParser, IdGenerator idGenerator, int initialMode) {
        this.sourceBlocks = sourceBlocks;
        this.inlineParser = inlineParser;
        this.links = new HashMap<String, UriWithTitle>();
        this.idGenerator = idGenerator;
        this.mode = initialMode;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public @Nullable String normalizeLabel(@Nullable String label) {
        if (label == null || label.isEmpty()) {
            return null;
        }
        label = this.getHelper().collapseWhitespace(label);
        if (label.isEmpty()) {
            return null;
        }
        return label.toLowerCase(Locale.ROOT);
    }

    public boolean hasNamedUri() {
        return !this.links.isEmpty();
    }

    public void addUriDefinition(@Nullable String label, String href, @Nullable String title) {
        if (this.mode > 1) {
            throw new IllegalStateException("" + this.mode);
        }
        if (label != null && !label.isEmpty() && !this.links.containsKey(label)) {
            this.links.put(label, new UriWithTitle(label, href, title));
        }
    }

    public @Nullable UriWithTitle getNamedUri(String label) {
        return this.links.get(label.toLowerCase());
    }

    public @Nullable String generateHeadingId(int headingLevel, @Nullable String headingText) {
        if (this.mode <= 1) {
            return "";
        }
        return this.idGenerator.newId("h" + headingLevel, headingText);
    }

    public SourceBlocks getSourceBlocks() {
        return this.sourceBlocks;
    }

    public InlineParser getInlineParser() {
        return this.inlineParser;
    }

    public ParseHelper getHelper() {
        if (this.parseHelper == null) {
            this.parseHelper = new ParseHelper();
        }
        return this.parseHelper;
    }

    public static class UriWithTitle {
        private final String label;
        private final String uri;
        private final @Nullable String title;

        public UriWithTitle(String label, String uri, @Nullable String title) {
            this.label = label;
            this.uri = uri;
            this.title = title;
        }

        public String getLabel() {
            return this.label;
        }

        public String getUri() {
            return this.uri;
        }

        public @Nullable String getTitle() {
            return this.title;
        }
    }
}

