/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui.preferences;

import java.util.List;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.statet.ecommons.databinding.NotEmptyValidator;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.dialogs.ExtStatusDialog;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.VariableFilterUtils;
import org.eclipse.statet.ecommons.ui.workbench.ResourceInputComposite;
import org.eclipse.statet.internal.nico.core.ResourceMapping;
import org.eclipse.statet.internal.nico.ui.NicoUIPlugin;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.plugin.AbstractUIPlugin;

class EditMappingDialog
extends ExtStatusDialog {
    private ResourceInputComposite localControl;
    private Text hostControl;
    private Text remoteControl;
    private final String mappingId;
    private final IObservableValue<String> localValue;
    private final IObservableValue<String> hostValue;
    private final IObservableValue<String> remoteValue;

    public EditMappingDialog(Shell shell, ResourceMapping mapping, boolean newMapping) {
        super(shell, newMapping ? 2 : 6);
        this.setTitle("Edit Resource Mapping");
        this.mappingId = !newMapping ? mapping.getId() : null;
        this.localValue = new WritableValue((Object)(mapping != null ? mapping.getLocalText() : null), String.class);
        this.hostValue = new WritableValue((Object)(mapping != null ? mapping.getHost() : null), String.class);
        this.remoteValue = new WritableValue((Object)(mapping != null ? mapping.getRemotePath().toString() : null), String.class);
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return DialogUtils.getDialogSettings((AbstractUIPlugin)NicoUIPlugin.getInstance(), (String)"ResourceMappingEditDialog");
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setLayoutData((Object)new GridData(4, 128, true, true));
        area.setLayout((Layout)LayoutUtils.newDialogGrid((int)2));
        Composite composite = area;
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label.setText("Path on &Local:");
        this.localControl = new ResourceInputComposite(composite, 0, 10, "local directory");
        this.localControl.getValidator().setOnNotExisting(2);
        this.localControl.setShowInsertVariable(false, (List)VariableFilterUtils.DEFAULT_NON_ITERACTIVE_FILTERS, null);
        GridData gd = new GridData(4, 0x1000000, true, false);
        gd.widthHint = LayoutUtils.hintWidth((Text)((Text)this.localControl.getTextControl()), (int)60);
        this.localControl.setLayoutData((Object)gd);
        label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label.setText("Remote &Host:");
        this.hostControl = new Text(composite, 2052);
        this.hostControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        label = new Label(composite, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label.setText("Path on &Remote:");
        this.remoteControl = new Text(composite, 2052);
        this.remoteControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        EditMappingDialog.applyDialogFont((Control)area);
        return area;
    }

    protected void addBindings(DataBindingSupport db) {
        db.getContext().bindValue(this.localControl.getObservable(), this.localValue, new UpdateValueStrategy().setAfterGetValidator((IValidator)this.localControl.getValidator()), null);
        db.getContext().bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.hostControl), this.hostValue, new UpdateValueStrategy().setAfterGetValidator((IValidator)new NotEmptyValidator("Missing host; it must be specified by its hostname or IP number.")), null);
        db.getContext().bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.remoteControl), this.remoteValue, new UpdateValueStrategy().setAfterGetValidator((IValidator)new NotEmptyValidator("Missing remote path.")), null);
    }

    public ResourceMapping getResult() {
        try {
            return new ResourceMapping(this.mappingId, (String)this.localValue.getValue(), (String)this.hostValue.getValue(), (String)this.remoteValue.getValue());
        }
        catch (CoreException e) {
            return null;
        }
    }
}

