/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.ui.editors;

import java.util.Arrays;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.statet.docmlet.wikitext.core.ast.WikitextAstNode;
import org.eclipse.statet.docmlet.wikitext.core.model.WikitextNameAccess;
import org.eclipse.statet.internal.docmlet.wikitext.ui.editors.Messages;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.ltk.core.util.NameUtils;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.LinkedNamesAssistProposal;

public class WikitextLinkedNamesAssistProposal
extends LinkedNamesAssistProposal {
    public static final int IN_FILE = 1;
    private final WikitextNameAccess access;
    private final int mode;

    public WikitextLinkedNamesAssistProposal(int mode, AssistInvocationContext invocationContext, WikitextNameAccess access) {
        super(invocationContext);
        this.mode = mode;
        switch (mode) {
            case 1: {
                this.init(Messages.Proposal_RenameInFile_label, Messages.Proposal_RenameInFile_description, 90);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.access = access;
    }

    protected void collectPositions(IDocument document, LinkedPositionGroup group) throws BadLocationException {
        int i;
        ImList accessList = this.access.getAllInUnit();
        WikitextNameAccess[] all = (WikitextNameAccess[])accessList.toArray((Object[])new WikitextNameAccess[accessList.size()]);
        Arrays.sort(all, NameUtils.NAME_POSITION_COMPARATOR);
        int current = -1;
        int i2 = 0;
        while (i2 < all.length) {
            if (this.access == all[i2]) {
                current = i2;
                break;
            }
            ++i2;
        }
        if (current < 0) {
            return;
        }
        int idx = 0;
        idx = this.addPosition(group, document, this.getPosition(all[current]), idx);
        if (this.mode == 1) {
            i = current + 1;
            while (i < all.length) {
                idx = this.addPosition(group, document, this.getPosition(all[i]), idx);
                ++i;
            }
        }
        if (this.mode == 1) {
            i = 0;
            while (i < current) {
                idx = this.addPosition(group, document, this.getPosition(all[i]), idx);
                ++i;
            }
        }
    }

    private Position getPosition(WikitextNameAccess access) {
        return WikitextNameAccess.getTextPosition((WikitextAstNode)((WikitextAstNode)access.getNameNode()));
    }
}

