/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.redocs.wikitext.r;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.statet.docmlet.wikitext.ui.sourceediting.WikitextEditingSettings;
import org.eclipse.statet.ecommons.ui.util.ImageRegistryUtil;
import org.eclipse.statet.internal.r.ui.RUIPlugin;
import org.eclipse.statet.internal.redocs.wikitext.r.ui.editors.WikidocRweaveDocumentProvider;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.ltk.ui.LTKUIPreferences;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistComputerRegistry;
import org.eclipse.statet.ltk.ui.templates.WaContributionContextTypeRegistry;
import org.eclipse.statet.ltk.ui.util.CombinedPreferenceStore;
import org.eclipse.ui.editors.text.EditorsUI;
import org.eclipse.ui.editors.text.templates.ContributionTemplateStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class RedocsWikitextRPlugin
extends AbstractUIPlugin {
    private static final String NS = "org.eclipse.statet.redocs.wikitext.r";
    public static final String OBJ_WIKIDOCRWEAVE_IMAGE_ID = "org.eclipse.statet.redocs.wikitext.r/image/obj/WikidocRweave";
    public static final String TOOL_NEW_WIKIDOCRWEAVE_IMAGE_ID = "org.eclipse.statet.redocs.wikitext.r/image/tool/New-WikidocRweave";
    public static final String WIZBAN_NEW_WIKIDOCRWEAVE_FILE_IMAGE_ID = "org.eclipse.statet.redocs.wikitext.r/image/wizban/New-WikidocRweaveFile";
    public static final String WIKITEXT_RWEAVE_EDITOR_NODE = "org.eclipse.statet.redocs.wikitext.r/rweavetex.editor/options";
    private static RedocsWikitextRPlugin instance;
    private boolean started;
    private List<Disposable> disposables;
    private WikidocRweaveDocumentProvider docRDocumentProvider;
    private IPreferenceStore editorPreferenceStore;
    private ContextTypeRegistry codegenTemplateContextTypeRegistry;
    private TemplateStore codegenTemplatesStore;
    private ContextTypeRegistry docTemplateContextTypeRegistry;
    private TemplateStore docTemplatesStore;
    private ContentAssistComputerRegistry wikidocRweaveEditorContentAssistRegistry;

    public static RedocsWikitextRPlugin getInstance() {
        return instance;
    }

    public static void log(IStatus status) {
        RedocsWikitextRPlugin plugin = RedocsWikitextRPlugin.getInstance();
        if (plugin != null) {
            plugin.getLog().log(status);
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        this.disposables = new ArrayList<Disposable>();
        this.started = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        try {
            if (this.codegenTemplatesStore != null) {
                this.codegenTemplatesStore.stopListeningForPreferenceChanges();
            }
            RedocsWikitextRPlugin redocsWikitextRPlugin = this;
            synchronized (redocsWikitextRPlugin) {
                this.started = false;
                this.editorPreferenceStore = null;
                this.codegenTemplateContextTypeRegistry = null;
                this.codegenTemplatesStore = null;
                this.docTemplateContextTypeRegistry = null;
                this.docTemplatesStore = null;
                this.wikidocRweaveEditorContentAssistRegistry = null;
            }
            for (Disposable listener : this.disposables) {
                try {
                    listener.dispose();
                }
                catch (Throwable e) {
                    RedocsWikitextRPlugin.log((IStatus)new Status(4, NS, "Error occured while disposing a module.", e));
                }
            }
            this.disposables = null;
        }
        finally {
            instance = null;
            super.stop(context);
        }
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        ImageRegistryUtil util = new ImageRegistryUtil((AbstractUIPlugin)this);
        util.register(OBJ_WIKIDOCRWEAVE_IMAGE_ID, "obj_16", "wikidoc_rweave-file.png");
        util.register(TOOL_NEW_WIKIDOCRWEAVE_IMAGE_ID, "tool_16", "new-wikidoc_rweave-file.png");
        util.register(WIZBAN_NEW_WIKIDOCRWEAVE_FILE_IMAGE_ID, "wizban", "new-wikidoc_rweave-file.png");
    }

    public synchronized WikidocRweaveDocumentProvider getDocRDocumentProvider() {
        if (this.docRDocumentProvider == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.docRDocumentProvider = new WikidocRweaveDocumentProvider();
            this.disposables.add(this.docRDocumentProvider);
        }
        return this.docRDocumentProvider;
    }

    public synchronized ContextTypeRegistry getCodegenTemplateContextTypeRegistry() {
        if (this.codegenTemplateContextTypeRegistry == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.codegenTemplateContextTypeRegistry = new WaContributionContextTypeRegistry("org.eclipse.statet.redocs.templates.WikitextRweaveCodegen");
        }
        return this.codegenTemplateContextTypeRegistry;
    }

    public synchronized TemplateStore getCodegenTemplateStore() {
        if (this.codegenTemplatesStore == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.codegenTemplatesStore = new ContributionTemplateStore(this.getCodegenTemplateContextTypeRegistry(), this.getPreferenceStore(), "codegen/CodeTemplates_store");
            try {
                this.codegenTemplatesStore.load();
            }
            catch (IOException e) {
                RedocsWikitextRPlugin.log((IStatus)new Status(4, NS, "An error occured when loading 'Wikitext+R code generation' template store.", (Throwable)e));
            }
        }
        return this.codegenTemplatesStore;
    }

    public synchronized ContextTypeRegistry getDocTemplateContextTypeRegistry() {
        if (this.docTemplateContextTypeRegistry == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.docTemplateContextTypeRegistry = new WaContributionContextTypeRegistry("org.eclipse.statet.redocs.templates.WikitextRweaveDoc");
        }
        return this.docTemplateContextTypeRegistry;
    }

    public synchronized TemplateStore getDocTemplateStore() {
        if (this.docTemplatesStore == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.docTemplatesStore = new ContributionTemplateStore(this.getDocTemplateContextTypeRegistry(), this.getPreferenceStore(), "codegen/DocTemplates_store");
            try {
                this.docTemplatesStore.load();
            }
            catch (IOException e) {
                RedocsWikitextRPlugin.log((IStatus)new Status(4, NS, 0, "An error occured when loading 'Wikitext+R document' template store.", (Throwable)e));
            }
        }
        return this.docTemplatesStore;
    }

    public synchronized IPreferenceStore getEditorPreferenceStore() {
        if (this.editorPreferenceStore == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.editorPreferenceStore = CombinedPreferenceStore.createStore((IPreferenceStore[])new IPreferenceStore[]{this.getPreferenceStore(), WikitextEditingSettings.getPreferenceStore(), RUIPlugin.getInstance().getPreferenceStore(), LTKUIPreferences.getPreferenceStore(), EditorsUI.getPreferenceStore()});
        }
        return this.editorPreferenceStore;
    }

    public synchronized ContentAssistComputerRegistry getWikidocRweaveEditorContentAssistRegistry() {
        if (this.wikidocRweaveEditorContentAssistRegistry == null) {
            if (!this.started) {
                throw new IllegalStateException("Plug-in is not started.");
            }
            this.wikidocRweaveEditorContentAssistRegistry = new ContentAssistComputerRegistry("org.eclipse.statet.redocs.contentTypes.WikidocRweave", WIKITEXT_RWEAVE_EDITOR_NODE);
            this.disposables.add((Disposable)this.wikidocRweaveEditorContentAssistRegistry);
        }
        return this.wikidocRweaveEditorContentAssistRegistry;
    }
}

