/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.cmd.ui.launching;

import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.debug.ui.CommonTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.statet.ecommons.debug.core.util.LaunchUtils;
import org.eclipse.statet.ecommons.debug.ui.config.LaunchConfigUtils;
import org.eclipse.statet.ecommons.debug.ui.util.UnterminatedLaunchAlerter;
import org.eclipse.statet.ecommons.io.FileUtil;
import org.eclipse.statet.internal.r.cmd.ui.launching.Messages;
import org.eclipse.statet.r.core.renv.IREnvConfiguration;
import org.eclipse.statet.r.launching.core.RLaunching;
import org.eclipse.statet.r.launching.ui.REnvTab;
import org.eclipse.statet.r.launching.ui.RErrorLineTracker;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IPatternMatchListener;
import org.eclipse.ui.console.TextConsole;

public class RCmdLaunchDelegate
extends LaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        SubMonitor m = LaunchUtils.initProgressMonitor((ILaunchConfiguration)configuration, (IProgressMonitor)monitor, (int)25);
        long timestamp = System.currentTimeMillis();
        try {
            IConsole console;
            Process p;
            if (m.isCanceled()) {
                return;
            }
            ArrayList<String> cmdLine = new ArrayList<String>();
            IREnvConfiguration renv = RLaunching.getREnvConfig((ILaunchConfiguration)configuration, (boolean)true);
            String cmd = configuration.getAttribute("org.eclipse.statet.r.debug/RCmd/arguments.cmd", "").trim();
            if (cmd.length() != 0) {
                cmdLine.addAll(Arrays.asList(cmd.split(" ")));
            }
            String arg1 = null;
            if (cmdLine.size() > 0) {
                arg1 = (String)cmdLine.remove(0);
            }
            cmdLine.addAll(0, renv.getExecCommand(arg1, EnumSet.of(IREnvConfiguration.Exec.CMD, IREnvConfiguration.Exec.TERM)));
            m.worked(1);
            if (m.isCanceled()) {
                return;
            }
            IFileStore workingDirectory = REnvTab.getWorkingDirectory((ILaunchConfiguration)configuration);
            m.worked(1);
            if (m.isCanceled()) {
                return;
            }
            cmdLine.addAll(Arrays.asList(LaunchUtils.getProcessArguments((ILaunchConfiguration)configuration, (String)"org.eclipse.statet.r.debug/RCmd/arguments.options")));
            String resourceValue = configuration.getAttribute("org.eclipse.statet.r.debug/RCmd/arguments.resource", "");
            IFileStore resource = null;
            IPath resourcePathAbsolute = null;
            IPath resourcePathAuto = null;
            if (resourceValue.length() > 0) {
                resource = FileUtil.expandToLocalFileStore((String)resourceValue, (IFileStore)workingDirectory, null);
                IPath workingDirectoryPath = URIUtil.toPath((URI)workingDirectory.toURI());
                if (workingDirectoryPath.isPrefixOf(resourcePathAuto = (resourcePathAbsolute = URIUtil.toPath((URI)resource.toURI())))) {
                    resourcePathAuto = resourcePathAuto.setDevice(null);
                    resourcePathAuto = resourcePathAuto.removeFirstSegments(workingDirectoryPath.segmentCount());
                }
                cmdLine.add(resourcePathAuto.toString());
            }
            m.worked(1);
            if (m.isCanceled()) {
                return;
            }
            ProcessBuilder builder = new ProcessBuilder(cmdLine);
            builder.directory(workingDirectory.toLocalFile(0, null));
            Map<String, String> envp = builder.environment();
            LaunchUtils.configureEnvironment(envp, (ILaunchConfiguration)configuration, (Map)renv.getEnvironmentsVariables());
            UnterminatedLaunchAlerter.registerLaunchType((String)"org.eclipse.statet.r.launchConfigurations.RCmdTool");
            try {
                p = builder.start();
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.console.ui", 0, Messages.RCmd_LaunchDelegate_error_StartingExec, (Throwable)e));
            }
            m.worked(10);
            HashMap<String, String> processAttributes = new HashMap<String, String>();
            processAttributes.put(IProcess.ATTR_PROCESS_TYPE, "R.cmd");
            String processName = String.valueOf((String)cmdLine.get(0)) + ' ' + LaunchUtils.createProcessTimestamp((long)timestamp);
            StringBuilder sb = new StringBuilder(200);
            sb.append(LaunchUtils.createLaunchPrefix((ILaunchConfiguration)configuration));
            sb.append(' ').append(renv.getName());
            sb.append(" : R ").append(cmd);
            if (resourcePathAbsolute != null) {
                sb.append(' ').append(resourcePathAbsolute.toOSString());
            }
            sb.append(" ~ ").append(processName);
            String label = sb.toString();
            IProcess process = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)processName, processAttributes);
            if (process == null) {
                p.destroy();
                throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.console.ui", 0, Messages.RCmd_LaunchDelegate_error_ProcessHandle, null));
            }
            process.setAttribute(IProcess.ATTR_CMDLINE, LaunchUtils.generateCommandLine(cmdLine));
            process.setAttribute(IProcess.ATTR_PROCESS_LABEL, label);
            m.worked(5);
            if (!process.isTerminated() && !CommonTab.isLaunchInBackground((ILaunchConfiguration)configuration)) {
                m.subTask(Messages.RCmd_LaunchDelegate_Running_label);
            }
            if ((console = DebugUITools.getConsole((IProcess)process)) instanceof TextConsole) {
                RErrorLineTracker lineMatcher = new RErrorLineTracker(workingDirectory);
                ((TextConsole)console).addPatternMatchListener((IPatternMatchListener)lineMatcher);
            }
            LaunchConfigUtils.launchResourceRefresh((ILaunchConfiguration)configuration, (IProcess)process, (IProgressMonitor)m.newChild(5));
        }
        finally {
            m.done();
        }
    }
}

