/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.ui.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;

@NonNullByDefault
public class MessageUtils {
    public static final Pattern AMPERSAND_PATTERN = Pattern.compile("\\&");
    public static final String AMPERSAND_TOOLTIP_REPLACEMENT = Matcher.quoteReplacement("&&");
    private static final String URL_DELIMITERS = String.valueOf(TextProcessor.getDefaultDelimiters()) + ":@?-";
    private static final String FILE_PATTERN_DELIMITERS = String.valueOf(TextProcessor.getDefaultDelimiters()) + "*.?";

    public static String removeMnemonics(String label) {
        return LegacyActionTools.removeMnemonics((String)label);
    }

    public static String escapeForFormText(String text) {
        StringBuilder escaped = new StringBuilder(text.length());
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    escaped.append("&lt;");
                    break;
                }
                case '>': {
                    escaped.append("&gt;");
                    break;
                }
                case '&': {
                    escaped.append("&amp;");
                    break;
                }
                case '\"': {
                    escaped.append("&quot;");
                    break;
                }
                case '\'': {
                    escaped.append("&apos;");
                    break;
                }
                default: {
                    escaped.append(c);
                }
            }
            ++i;
        }
        return escaped.toString();
    }

    public static String escapeForTooltip(CharSequence text) {
        return AMPERSAND_PATTERN.matcher(text).replaceAll(AMPERSAND_TOOLTIP_REPLACEMENT);
    }

    public static String escapeForMenu(String text) {
        StringBuilder escaped = new StringBuilder(text.length());
        int i = 0;
        while (i < text.length()) {
            char c = text.charAt(i);
            switch (c) {
                case '&': {
                    escaped.append("&&");
                    break;
                }
                case '\t': {
                    escaped.append("  ");
                    break;
                }
                case '\n': {
                    escaped.append("  ");
                    break;
                }
                default: {
                    escaped.append(c);
                }
            }
            ++i;
        }
        return escaped.toString();
    }

    public static String processURLPart(String url) {
        return TextProcessor.process((String)url, (String)URL_DELIMITERS);
    }

    public static String processPath(String path) {
        return TextProcessor.process((String)path);
    }

    public static String processPathPattern(String name) {
        return TextProcessor.process((String)name, (String)FILE_PATTERN_DELIMITERS);
    }

    public static String getModifierString(int stateMask) {
        if (stateMask != 0) {
            StringBuilder sb = new StringBuilder();
            if ((stateMask & 0x40000) == 262144) {
                sb.append(LegacyActionTools.findModifierString((int)262144));
                sb.append(" + ");
            }
            if ((stateMask & 0x10000) == 65536) {
                sb.append(LegacyActionTools.findModifierString((int)65536));
                sb.append(" + ");
            }
            if ((stateMask & 0x20000) == 131072) {
                sb.append(LegacyActionTools.findModifierString((int)131072));
                sb.append(" + ");
            }
            if ((stateMask & 0x400000) == 0x400000) {
                sb.append(LegacyActionTools.findModifierString((int)0x400000));
                sb.append(" + ");
            }
            if (sb.length() > 0) {
                return sb.substring(0, sb.length() - 3);
            }
        }
        return "";
    }

    private MessageUtils() {
    }
}

