/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.preferences.ui;

import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.statet.ecommons.ui.components.StatusInfo;
import org.eclipse.statet.internal.ecommons.preferences.ui.Messages;
import org.eclipse.statet.internal.ecommons.ui.UIMiscellanyPlugin;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class ProjectSelectionDialog
extends SelectionStatusDialog {
    private Set<IProject> fAllItems;
    private Set<IProject> fFilteredItems;
    private TableViewer fTableViewer;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 300;
    private ViewerFilter fFilter;
    private static final String DIALOG_SETTINGS_SHOW_ALL = "ProjectSelectionDialog.show_all";

    public ProjectSelectionDialog(Shell parentShell, Set<IProject> all, Set<IProject> filtered) {
        super(parentShell);
        this.setTitle(Messages.ProjectSelectionDialog_title);
        this.setMessage(Messages.ProjectSelectionDialog_desciption);
        this.fAllItems = all;
        this.fFilteredItems = filtered;
        this.fFilter = new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                for (Object object : ProjectSelectionDialog.this.fFilteredItems) {
                    if (element != object) continue;
                    return true;
                }
                return false;
            }
        };
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createMessageArea(composite);
        this.fTableViewer = new TableViewer(composite, 2816);
        this.fTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ProjectSelectionDialog.this.doSelectionChanged(((IStructuredSelection)event.getSelection()).toArray());
            }
        });
        this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ProjectSelectionDialog.this.okPressed();
            }
        });
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = 250;
        data.widthHint = 300;
        this.fTableViewer.getTable().setLayoutData((Object)data);
        this.fTableViewer.setContentProvider((IContentProvider)new ContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider());
        this.fTableViewer.setComparator((ViewerComparator)new ProjectComparator());
        Button checkbox = new Button(composite, 32);
        checkbox.setText(Messages.ProjectSelectionDialog_filter);
        checkbox.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        checkbox.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProjectSelectionDialog.this.updateFilter(((Button)e.widget).getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ProjectSelectionDialog.this.updateFilter(((Button)e.widget).getSelection());
            }
        });
        IDialogSettings dialogSettings = UIMiscellanyPlugin.getInstance().getDialogSettings();
        boolean doFilter = !dialogSettings.getBoolean(DIALOG_SETTINGS_SHOW_ALL) && !this.fFilteredItems.isEmpty();
        checkbox.setSelection(doFilter);
        this.updateFilter(doFilter);
        this.fTableViewer.setInput(this.fAllItems);
        this.doSelectionChanged(new Object[0]);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void updateFilter(boolean selected) {
        if (selected) {
            this.fTableViewer.addFilter(this.fFilter);
        } else {
            this.fTableViewer.removeFilter(this.fFilter);
        }
        UIMiscellanyPlugin.getInstance().getDialogSettings().put(DIALOG_SETTINGS_SHOW_ALL, !selected);
    }

    private void doSelectionChanged(Object[] objects) {
        if (objects.length != 1) {
            this.updateStatus((IStatus)new StatusInfo(4, ""));
            this.setSelectionResult(null);
        } else {
            this.updateStatus((IStatus)new StatusInfo());
            this.setSelectionResult(objects);
        }
    }

    protected void computeResult() {
    }

    private static class ContentProvider
    implements IStructuredContentProvider {
        private ContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((Set)inputElement).toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }
    }

    private static class ProjectComparator
    extends ViewerComparator {
        private ProjectComparator() {
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            return this.getComparator().compare(((IProject)e1).getName(), ((IProject)e2).getName());
        }
    }

    private static class ProjectLabelProvider
    extends LabelProvider {
        private ProjectLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IProject) {
                return ((IProject)element).getName();
            }
            return super.getText(element);
        }
    }
}

