/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.preferences.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.preferences.core.PreferenceSetService;
import org.eclipse.statet.ecommons.preferences.core.util.PreferenceUtils;
import org.eclipse.statet.ecommons.preferences.ui.ConfigurationBlock;
import org.eclipse.statet.ecommons.runtime.core.StatusChangeListener;
import org.eclipse.statet.ecommons.ui.IOverlayStatus;
import org.eclipse.statet.ecommons.ui.components.StatusInfo;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.internal.ecommons.preferences.ui.Messages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.statushandlers.StatusManager;

public abstract class ConfigurationBlockPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private ConfigurationBlock block;
    private Composite blockControl;
    private IStatus blockStatus = new StatusInfo();

    protected abstract ConfigurationBlock createConfigurationBlock() throws CoreException;

    public void init(IWorkbench workbench) {
        try {
            this.block = this.createConfigurationBlock();
        }
        catch (CoreException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ecommons.uimisc", -1, NLS.bind((String)Messages.ConfigurationPage_error_message, (Object)this.getTitle()), (Throwable)e), 3);
        }
    }

    public void dispose() {
        this.block.dispose();
        super.dispose();
    }

    protected ConfigurationBlock getBlock() {
        return this.block;
    }

    protected Control createContents(Composite parent) {
        String helpContext;
        this.blockControl = new Composite(parent, 0);
        this.blockControl.setLayoutData((Object)new GridData(4, 4, true, true));
        GridLayout layout = LayoutUtils.newCompositeGrid(1);
        layout.marginRight = LayoutUtils.defaultHSpacing();
        this.blockControl.setLayout((Layout)layout);
        this.blockControl.setBackgroundMode(2);
        this.block.createContents(this.blockControl, this.getWorkbenchContainer(), this.getPreferenceStore());
        this.applyDialogFont(this.blockControl);
        String explTitle = this.block.getTitle();
        if (explTitle != null) {
            this.setTitle(explTitle);
        }
        if ((helpContext = this.getHelpContext()) != null) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.blockControl, helpContext);
        }
        return this.blockControl;
    }

    protected Composite getBlockControl() {
        return this.blockControl;
    }

    protected String getHelpContext() {
        return this.block.getHelpContext();
    }

    private IWorkbenchPreferenceContainer getWorkbenchContainer() {
        IPreferencePageContainer container = this.getContainer();
        return container instanceof IWorkbenchPreferenceContainer ? (IWorkbenchPreferenceContainer)container : null;
    }

    public boolean performOk() {
        if (this.block != null) {
            PreferenceSetService preferenceSetService = PreferenceUtils.getPreferenceSetService();
            IWorkbenchPreferenceContainer container = this.getWorkbenchContainer();
            String sourceId = "Obj" + System.identityHashCode(container != null ? container : this);
            boolean resume = preferenceSetService.pause(sourceId);
            try {
                if (!this.block.performOk(0)) {
                    return false;
                }
            }
            finally {
                if (resume) {
                    if (container != null) {
                        container.registerUpdateJob(preferenceSetService.createResumeJob(sourceId));
                    } else {
                        preferenceSetService.resume(sourceId);
                    }
                }
            }
        }
        return super.performOk();
    }

    public void performApply() {
        if (this.block != null) {
            PreferenceSetService preferenceSetService = PreferenceUtils.getPreferenceSetService();
            String sourceId = "Obj" + System.identityHashCode((Object)this);
            boolean resume = preferenceSetService.pause(sourceId);
            try {
                this.block.performOk(16);
            }
            finally {
                if (resume) {
                    preferenceSetService.resume(sourceId);
                }
            }
        }
    }

    public void performDefaults() {
        if (this.block != null) {
            this.block.performDefaults();
        }
        super.performDefaults();
    }

    public boolean performCancel() {
        if (this.block != null) {
            this.block.performCancel();
        }
        return true;
    }

    protected StatusChangeListener createStatusChangedListener() {
        return new StatusChangeListener(){

            public void statusChanged(IStatus status) {
                ConfigurationBlockPreferencePage.this.blockStatus = status;
                ConfigurationBlockPreferencePage.this.updateStatus();
            }
        };
    }

    protected void updateStatus() {
        this.updateStatus(this.blockStatus);
    }

    protected void updateStatus(IStatus status) {
        if (status instanceof IOverlayStatus) {
            this.setValid(((IOverlayStatus)status).getCombinedSeverity() != 4);
        } else {
            this.setValid(!status.matches(4));
        }
        StatusInfo.applyToStatusLine((DialogPage)this, status);
    }

    protected IStatus getBlockStatus() {
        return this.blockStatus;
    }
}

