/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.statet.docmlet.wikitext.core.source.SourceElementAttributes;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.CommonmarkLocator;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.FilterLineSequence;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.LineSequence;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlockItem;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlocks;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks.BlockWithNestedBlocks;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks.ParagraphBlock;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class BlockQuoteBlock
extends BlockWithNestedBlocks {
    private static final Pattern START_PATTERN = Pattern.compile(">.*", 32);
    private static final Pattern PROCESS_PATTERN;
    public static final Pattern PATTERN;
    private final Matcher startMatcher = START_PATTERN.matcher("");
    private @Nullable Matcher processMatcher;

    static {
        PATTERN = PROCESS_PATTERN = Pattern.compile(">([ \t])?.*", 32);
    }

    public static final int computeContentLineIndent(Line line, Matcher matcher) {
        int spaceOffset = matcher.start(1);
        if (spaceOffset != -1) {
            return line.getColumn(spaceOffset) + 1 - line.getColumn();
        }
        return line.getColumn(matcher.regionStart()) + 1 - line.getColumn();
    }

    @Override
    public boolean canStart(LineSequence lineSequence, @Nullable SourceBlockItem<?> currentBlockItem) {
        Line currentLine = lineSequence.getCurrentLine();
        return currentLine != null && !currentLine.isBlank() && currentLine.getIndent() < 4 && currentLine.setupIndent(this.startMatcher).matches();
    }

    @Override
    public void createItem(SourceBlocks.SourceBlockBuilder builder, LineSequence lineSequence) {
        SourceBlockItem<BlockQuoteBlock> blockItem = new SourceBlockItem<BlockQuoteBlock>(this, builder);
        QuotedBlockLines quotedBlock = new QuotedBlockLines(lineSequence, builder, blockItem, this.getProcessMatcher());
        builder.createNestedItems(quotedBlock, null);
    }

    @Override
    public void emit(ProcessingContext context, SourceBlockItem<?> blockItem, CommonmarkLocator locator, DocumentBuilder builder) {
        SourceElementAttributes attributes = new SourceElementAttributes(256);
        locator.setBlockBegin(blockItem);
        builder.beginBlock(DocumentBuilder.BlockType.QUOTE, (Attributes)attributes);
        super.emit(context, blockItem, locator, builder);
        locator.setBlockEnd(blockItem);
        builder.endBlock();
    }

    private Matcher getProcessMatcher() {
        if (this.processMatcher == null) {
            this.processMatcher = PROCESS_PATTERN.matcher("");
        }
        return this.processMatcher;
    }

    private static class QuotedBlockLines
    extends FilterLineSequence {
        private final SourceBlocks.SourceBlockBuilder builder;
        private final SourceBlockItem<BlockQuoteBlock> blockItem;
        private final Matcher matcher;

        public QuotedBlockLines(LineSequence delegate, SourceBlocks.SourceBlockBuilder builder, SourceBlockItem<BlockQuoteBlock> blockItem, Matcher matcher) {
            super(delegate);
            this.builder = builder;
            this.blockItem = blockItem;
            this.matcher = matcher;
        }

        protected QuotedBlockLines(QuotedBlockLines from) {
            super(from.getDelegate().lookAhead());
            this.builder = from.builder;
            this.blockItem = from.blockItem;
            this.matcher = from.matcher;
        }

        @Override
        public LineSequence lookAhead() {
            return new QuotedBlockLines(this);
        }

        @Override
        protected @Nullable Line filter(Line line) {
            if (!line.isBlank()) {
                Matcher matcher;
                if (line.getIndent() < 4 && (matcher = line.setupIndent(this.matcher)).matches()) {
                    return line.segmentByIndent(BlockQuoteBlock.computeContentLineIndent(line, matcher));
                }
                if (this.isLazyContinuation(line)) {
                    return line.lazy();
                }
            }
            return null;
        }

        private boolean isLazyContinuation(Line line) {
            SourceBlockItem<?> currentItem = this.builder.getCurrentItem();
            if (currentItem.isParagraph()) {
                LineSequence lookAhead = this.getDelegate().lookAhead(line.getLineNumber());
                if (!((ParagraphBlock)currentItem.getType()).isAnotherBlockStart(lookAhead, this.builder.getSourceBlocks(), currentItem)) {
                    return true;
                }
            }
            return false;
        }
    }
}

