/**
 * <copyright>
 * 
 * Copyright (c) 2014-2016 itemis and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *     itemis - Initial API and implementation
 *     itemis - [503063] Provide launching support for Sphinx Workflows
 * 
 * </copyright>
 */
package org.eclipse.sphinx.examples.workflows.lib;

import com.google.common.base.Objects;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.sphinx.emf.mwe.dynamic.IModelWorkflowSlots;

@SuppressWarnings("all")
public class ModelWorkflowExtensions {
  public static List<EObject> getModelSlot(final WorkflowContext ctx) {
    Object _get = ctx.get(IModelWorkflowSlots.MODEL_SLOT_NAME);
    return ((List<EObject>) _get);
  }
  
  public static Map<String, Object> getArgumentsSlot(final WorkflowContext ctx) {
    Object _get = ctx.get(IModelWorkflowSlots.ARGUMENTS_SLOT_NAME);
    return ((Map<String, Object>) _get);
  }
  
  public static String getLabel(final EObject modelObject) {
    final ComposedAdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    final AdapterFactoryItemDelegator delegator = new AdapterFactoryItemDelegator(adapterFactory);
    final String label = delegator.getText(modelObject);
    if (((!Objects.equal(label, null)) && (!label.isEmpty()))) {
      return label;
    } else {
      String _name = modelObject.eClass().getName();
      return (_name + " <Unnamed>");
    }
  }
}
