/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.testutils;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EcoreEqualityAssert
extends Assert {
    private static Map<EObject, EObject> mappedEObjects = new HashMap<EObject, EObject>();

    public static void assertEquals(EObject eObject1, EObject eObject2) {
        try {
            EcoreEqualityAssert.internalAssertEquals(eObject1, eObject2);
        }
        finally {
            mappedEObjects.clear();
        }
    }

    protected static void internalAssertEquals(EObject eObject1, EObject eObject2) {
        if (eObject1 == null) {
            EcoreEqualityAssert.assertTrue((String)("First object is null, but second isn't: " + eObject2 + "."), (eObject2 == null ? 1 : 0) != 0);
            return;
        }
        EcoreEqualityAssert.assertFalse((String)("First object isn't null: " + eObject1.toString() + ", but second is."), (eObject2 == null ? 1 : 0) != 0);
        EObject eObject1MappedValue = mappedEObjects.get(eObject1);
        if (eObject1MappedValue != null) {
            EcoreEqualityAssert.assertTrue((eObject1MappedValue == eObject2 ? 1 : 0) != 0);
            return;
        }
        EObject eObject2MappedValue = mappedEObjects.get(eObject2);
        if (eObject2MappedValue != null) {
            EcoreEqualityAssert.assertTrue((eObject2MappedValue == eObject1 ? 1 : 0) != 0);
            return;
        }
        if (eObject1 == eObject2) {
            mappedEObjects.put(eObject1, eObject2);
            mappedEObjects.put(eObject2, eObject1);
            return;
        }
        if (eObject1.eIsProxy()) {
            EcoreEqualityAssert.assertTrue((String)("First object is a proxy: " + eObject1.toString() + ", but second isn't: " + eObject2.toString() + "."), (boolean)eObject2.eIsProxy());
            EcoreEqualityAssert.assertEquals((Object)((InternalEObject)eObject1).eProxyURI(), (Object)((InternalEObject)eObject2).eProxyURI());
            mappedEObjects.put(eObject1, eObject2);
            mappedEObjects.put(eObject2, eObject1);
            return;
        }
        EcoreEqualityAssert.assertFalse((String)("First object isn't a proxy: " + eObject1.toString() + ", but second is: " + eObject2.toString() + "."), (boolean)eObject2.eIsProxy());
        EClass eClass = eObject1.eClass();
        EcoreEqualityAssert.assertTrue((String)("Object " + eObject1.toString() + " and object " + eObject2.toString() + " don't have the same class: " + eObject1.eClass().getName() + " <-> " + eObject2.eClass().getName() + "."), (eClass == eObject2.eClass() ? 1 : 0) != 0);
        mappedEObjects.put(eObject1, eObject2);
        mappedEObjects.put(eObject2, eObject1);
        int i = 0;
        int size = eClass.getFeatureCount();
        while (i < size) {
            EStructuralFeature feature = eClass.getEStructuralFeature(i);
            if (!feature.isDerived() && !EcoreEqualityAssert.isXMLSpecificFeature(feature)) {
                EcoreEqualityAssert.assertEqualFeature(eObject1, eObject2, feature);
            }
            ++i;
        }
    }

    protected static boolean isXMLSpecificFeature(EStructuralFeature feature) {
        EClass eClass = feature.getEContainingClass();
        if (feature == ExtendedMetaData.INSTANCE.getXSISchemaLocationMapFeature(eClass)) {
            return true;
        }
        return feature == ExtendedMetaData.INSTANCE.getXMLNSPrefixMapFeature(eClass);
    }

    public static void assertEquals(List<EObject> list1, List<EObject> list2) {
        try {
            EcoreEqualityAssert.internalAssertEquals(list1, list2);
        }
        finally {
            mappedEObjects.clear();
        }
    }

    protected static void internalAssertEquals(List<EObject> list1, List<EObject> list2) {
        int size = list1.size();
        EcoreEqualityAssert.assertTrue((String)("List " + list2.toString() + " and list " + list2.toString() + " don't have same size: " + list1.size() + " <-> " + list2.size() + "."), (size == list2.size() ? 1 : 0) != 0);
        int i = 0;
        while (i < size) {
            EObject eObject1 = list1.get(i);
            EObject eObject2 = list2.get(i);
            if (eObject2 != null && eObject2.eIsProxy()) {
                ((InternalEObject)((EcoreEList)list2).getNotifier()).eResolveProxy((InternalEObject)eObject2);
            }
            EcoreEqualityAssert.internalAssertEquals(eObject1, eObject2);
            ++i;
        }
    }

    protected static void assertEqualFeature(EObject eObject1, EObject eObject2, EStructuralFeature feature) {
        EcoreEqualityAssert.assertTrue((String)("Feature '" + feature.getName() + "' of object " + eObject1.toString() + " and object " + eObject2.toString() + " don't have same set state: " + eObject1.eIsSet(feature) + " <-> " + eObject2.eIsSet(feature) + "."), (eObject1.eIsSet(feature) == eObject2.eIsSet(feature) ? 1 : 0) != 0);
        if (feature instanceof EReference) {
            EcoreEqualityAssert.assertEqualReference(eObject1, eObject2, (EReference)feature);
        } else {
            EcoreEqualityAssert.assertEqualAttribute(eObject1, eObject2, (EAttribute)feature);
        }
    }

    protected static void assertEqualReference(EObject eObject1, EObject eObject2, EReference reference) {
        Object value1 = eObject1.eGet((EStructuralFeature)reference);
        Object value2 = eObject2.eGet((EStructuralFeature)reference);
        if (reference.isMany()) {
            EcoreEqualityAssert.internalAssertEquals((List)value1, (List)value2);
        } else {
            if (value2 != null && ((EObject)value2).eIsProxy()) {
                ((InternalEObject)eObject2).eResolveProxy((InternalEObject)value2);
            }
            EcoreEqualityAssert.internalAssertEquals((EObject)value1, (EObject)value2);
        }
    }

    protected static void assertEqualAttribute(EObject eObject1, EObject eObject2, EAttribute attribute) {
        Object value1 = eObject1.eGet((EStructuralFeature)attribute);
        Object value2 = eObject2.eGet((EStructuralFeature)attribute);
        if (value1 == null) {
            EcoreEqualityAssert.assertTrue((String)("Value of attribute '" + attribute.getName() + "' on object " + eObject1.toString() + " is null, but value of same attribute on object " + eObject2.toString() + " isn't: " + value2 + "."), (value2 == null ? 1 : 0) != 0);
            return;
        }
        EcoreEqualityAssert.assertFalse((String)("Value of attribute '" + attribute.getName() + "' on object " + eObject1.toString() + " isn't null: " + value1.toString() + ", but value of same attribute on object " + eObject2.toString() + " is."), (value2 == null ? 1 : 0) != 0);
        if (FeatureMapUtil.isFeatureMap((EStructuralFeature)attribute)) {
            FeatureMap featureMap1 = (FeatureMap)value1;
            FeatureMap featureMap2 = (FeatureMap)value2;
            EcoreEqualityAssert.assertEqualFeatureMaps(featureMap1, featureMap2);
        } else {
            EcoreEqualityAssert.assertEquals((String)("Value of attribute '" + attribute.getName() + "' on object " + eObject1.toString() + " and that of same attribute on object " + eObject2.toString() + " are not equal, "), (Object)value1, (Object)value2);
        }
    }

    protected static void assertEqualFeatureMaps(FeatureMap featureMap1, FeatureMap featureMap2) {
        Iterator iter1 = featureMap1.iterator();
        Iterator iter2 = featureMap2.iterator();
        Predicate<FeatureMap.Entry> isXmlFeature = new Predicate<FeatureMap.Entry>(){

            public boolean apply(FeatureMap.Entry entry) {
                EStructuralFeature feature = entry.getEStructuralFeature();
                return feature == XMLTypePackage.Literals.XML_TYPE_DOCUMENT_ROOT__PROCESSING_INSTRUCTION || feature == XMLTypePackage.Literals.XML_TYPE_DOCUMENT_ROOT__TEXT || feature == XMLTypePackage.Literals.XML_TYPE_DOCUMENT_ROOT__CDATA || feature == XMLTypePackage.Literals.XML_TYPE_DOCUMENT_ROOT__COMMENT;
            }
        };
        Predicate isNoXmlFeature = Predicates.not((Predicate)isXmlFeature);
        iter1 = Iterators.filter((Iterator)iter1, (Predicate)isNoXmlFeature);
        iter2 = Iterators.filter((Iterator)iter2, (Predicate)isNoXmlFeature);
        int i = 0;
        while (iter1.hasNext() && iter2.hasNext()) {
            FeatureMap.Entry entry1 = (FeatureMap.Entry)iter1.next();
            FeatureMap.Entry entry2 = (FeatureMap.Entry)iter2.next();
            EcoreEqualityAssert.assertTrue((String)("Feature at position " + i + " of feature map " + featureMap1 + " and feature at same position of feature map " + featureMap2 + " are not the same: " + entry1.getEStructuralFeature().getName() + " <-> " + entry2.getEStructuralFeature().getName() + "."), (entry1.getEStructuralFeature() == entry2.getEStructuralFeature() ? 1 : 0) != 0);
            EcoreEqualityAssert.assertEqualFeatureMapValues(entry1.getValue(), entry2.getValue(), entry1.getEStructuralFeature());
            ++i;
        }
        if (iter1.hasNext() || iter2.hasNext()) {
            EcoreEqualityAssert.fail((String)("Feature map " + featureMap1 + " and feature map " + featureMap2 + " don't have the same number of non-XML features."));
        }
    }

    protected static void assertEqualFeatureMapValues(Object value1, Object value2, EStructuralFeature feature) {
        if (feature instanceof EReference) {
            EcoreEqualityAssert.internalAssertEquals((EObject)value1, (EObject)value2);
        } else {
            EcoreEqualityAssert.assertTrue((String)("Feature map values for attribute '" + feature.getName() + "' are unequal: " + value1.toString() + " <-> " + value2.toString() + "."), (boolean)(value1 == null ? value2 == null : value1.equals(value2)));
        }
    }
}

