/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.ecore.proxymanagement;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sphinx.emf.internal.ecore.proxymanagement.ProxyHelper;
import org.eclipse.sphinx.emf.internal.ecore.proxymanagement.ProxyHelperAdapterFactory;
import org.eclipse.sphinx.emf.internal.ecore.proxymanagement.resolver.DefaultResourceSetEObjectResolver;
import org.eclipse.sphinx.emf.internal.ecore.proxymanagement.resolver.EObjectResolveRequest;
import org.eclipse.sphinx.emf.internal.ecore.proxymanagement.resolver.IEObjectResolver;
import org.eclipse.sphinx.emf.internal.ecore.proxymanagement.resolver.ScopingResourceSetEObjectResolver;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;

public class ProxyResolutionBehavior {
    public static final ProxyResolutionBehavior INSTANCE = new ProxyResolutionBehavior(new ScopingResourceSetEObjectResolver().append(new DefaultResourceSetEObjectResolver()));
    private IEObjectResolver fEObjectResolver;

    protected ProxyResolutionBehavior(IEObjectResolver eObjectResolver) {
        this.fEObjectResolver = eObjectResolver;
    }

    public EObject eResolveProxy(EObject contextObject, EObject proxy) {
        ResourceSet resourceSet;
        if (proxy == null) {
            return null;
        }
        if (this.isNoProxy(proxy)) {
            return proxy;
        }
        Resource resource = contextObject.eResource();
        if (resource != null && (resourceSet = resource.getResourceSet()) != null) {
            return this.eResolveProxyInResourceSet(resourceSet, contextObject, proxy);
        }
        return EcoreUtil.resolve((EObject)proxy, (EObject)contextObject);
    }

    protected boolean isNoProxy(EObject proxy) {
        return ((InternalEObject)proxy).eProxyURI() == null;
    }

    protected EObject eResolveProxyInResourceSet(ResourceSet resourceSet, EObject contextObject, EObject proxy) {
        IMetaModelDescriptor contextMMDescriptor;
        IMetaModelDescriptor proxyMMDescriptor;
        Assert.isNotNull((Object)resourceSet);
        Assert.isNotNull((Object)proxy);
        URI proxyURI = ((InternalEObject)proxy).eProxyURI();
        ProxyHelper proxyHelper = ProxyHelperAdapterFactory.INSTANCE.adapt((Notifier)resourceSet);
        if (proxyHelper != null) {
            if (proxyHelper.getBlackList().existsProxyURI(proxyURI)) {
                return proxy;
            }
            if (proxyURI.segmentCount() == 0) {
                EObject resolvedEObject;
                if (proxyURI.segmentCount() == 0 && proxyHelper.getLookupResolver().isAvailable() && (resolvedEObject = proxyHelper.getLookupResolver().get(proxyURI)) != null) {
                    return resolvedEObject;
                }
                if (proxyHelper.isIgnoreFragmentBasedProxies()) {
                    return proxy;
                }
            }
        }
        EObjectResolveRequest resolveRequest = new EObjectResolveRequest(proxy, contextObject);
        resolveRequest.setIncludeUnloadedEObjects(true);
        EObject resolvedEObject = this.fEObjectResolver.resolve(resolveRequest);
        if (resolvedEObject == proxy && proxyHelper != null && (proxyMMDescriptor = MetaModelDescriptorRegistry.INSTANCE.getDescriptor(proxy.eClass())).equals(contextMMDescriptor = MetaModelDescriptorRegistry.INSTANCE.getEffectiveDescriptor(contextObject.eResource()))) {
            proxyHelper.getBlackList().addProxyURI(proxyURI);
        }
        return resolvedEObject;
    }
}

