/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.compare.ui.actions;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sphinx.emf.compare.ui.actions.BasicCompareAction;
import org.eclipse.sphinx.platform.ui.util.SelectionUtil;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;
import org.eclipse.sphinx.platform.util.ReflectUtil;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class FileCompareAction
implements IObjectActionDelegate {
    private BasicCompareAction modelCompareActionDelegate = new BasicCompareAction();
    private IObjectActionDelegate eclipseCompareActionDelegate;

    public FileCompareAction() {
        try {
            String eclipseCompareActionClassName = ExtendedPlatform.getFeatureVersionOrdinal() >= 35 ? "org.eclipse.team.internal.ui.actions.CompareAction" : "org.eclipse.compare.internal.CompareAction";
            Class<?> eclipseCompareActionClass = this.getClass().getClassLoader().loadClass(eclipseCompareActionClassName);
            this.eclipseCompareActionDelegate = (IObjectActionDelegate)eclipseCompareActionClass.newInstance();
        }
        catch (Exception exception) {}
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        if (this.eclipseCompareActionDelegate != null) {
            this.eclipseCompareActionDelegate.setActivePart(action, targetPart);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        if (this.eclipseCompareActionDelegate != null) {
            this.eclipseCompareActionDelegate.selectionChanged(action, selection);
        }
        this.modelCompareActionDelegate.selectionChanged(SelectionUtil.getStructuredSelection((ISelection)selection));
        if (action != null) {
            action.setEnabled(this.isEclipseCompareActionEnabled() | this.modelCompareActionDelegate.isEnabled());
        }
    }

    public void run(IAction action) {
        if (this.modelCompareActionDelegate.isEnabled()) {
            this.modelCompareActionDelegate.run();
        } else if (this.isEclipseCompareActionEnabled()) {
            this.eclipseCompareActionDelegate.run(action);
        }
    }

    private boolean isEclipseCompareActionEnabled() {
        try {
            if (this.eclipseCompareActionDelegate != null) {
                return (Boolean)ReflectUtil.invokeMethod((Object)this.eclipseCompareActionDelegate, (String)"isEnabled", (Object[])new Object[0]);
            }
        }
        catch (Exception exception) {}
        return false;
    }
}

