/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.compare.ui.actions;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.compare.diff.metamodel.ComparisonResourceSnapshot;
import org.eclipse.emf.compare.diff.metamodel.ComparisonSnapshot;
import org.eclipse.emf.compare.diff.metamodel.DiffFactory;
import org.eclipse.emf.compare.diff.metamodel.DiffModel;
import org.eclipse.emf.compare.diff.service.DiffService;
import org.eclipse.emf.compare.match.metamodel.MatchModel;
import org.eclipse.emf.compare.match.service.MatchService;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sphinx.emf.compare.ui.editor.ModelCompareEditor;
import org.eclipse.sphinx.emf.compare.ui.editor.ModelElementCompareEditorInput;
import org.eclipse.sphinx.emf.compare.ui.internal.Activator;
import org.eclipse.sphinx.emf.compare.ui.internal.messages.Messages;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.platform.ui.util.ExtendedPlatformUI;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class BasicCompareAction
extends BaseSelectionListenerAction
implements ISelectionChangedListener {
    protected ComparisonSnapshot comparisonSnapshot;
    protected List<WeakReference<EObject>> selectedObjects = null;
    protected List<WeakReference<IFile>> selectedFiles = null;

    public BasicCompareAction() {
        super(Messages.action_compareWithEachOther);
    }

    public boolean updateSelection(IStructuredSelection selection) {
        Assert.isNotNull((Object)selection);
        if (selection.size() != 2) {
            return false;
        }
        this.comparisonSnapshot = null;
        this.selectedFiles = null;
        this.selectedObjects = null;
        for (Object obj : selection) {
            IFile file;
            if (obj instanceof EObject) {
                if (this.selectedObjects == null) {
                    this.selectedObjects = new ArrayList<WeakReference<EObject>>();
                }
                this.selectedObjects.add(new WeakReference<EObject>((EObject)obj));
                continue;
            }
            if (!(obj instanceof IFile) || MetaModelDescriptorRegistry.INSTANCE.getDescriptor(file = (IFile)obj) == null) continue;
            if (this.selectedFiles == null) {
                this.selectedFiles = new ArrayList<WeakReference<IFile>>();
            }
            this.selectedFiles.add(new WeakReference<IFile>(file));
        }
        return this.selectedFiles != null ? this.selectedFiles.size() == 2 : (this.selectedObjects != null ? this.selectedObjects.size() == 2 : false);
    }

    public void run() {
        EObject leftObject = null;
        EObject rightObject = null;
        if (this.selectedObjects != null && this.selectedObjects.size() == 2) {
            leftObject = (EObject)this.selectedObjects.get(0).get();
            rightObject = (EObject)this.selectedObjects.get(1).get();
        } else if (this.selectedFiles != null && this.selectedFiles.size() == 2) {
            leftObject = this.getModelRoot((IFile)this.selectedFiles.get(0).get());
            rightObject = this.getModelRoot((IFile)this.selectedFiles.get(1).get());
        }
        if (leftObject == null || rightObject == null) {
            return;
        }
        try {
            MatchModel matchModel = MatchService.doContentMatch(leftObject, rightObject, null);
            DiffModel diffModel = DiffService.doDiff((MatchModel)matchModel);
            this.comparisonSnapshot = this.createComparisonSnapshot(matchModel, diffModel);
            CompareEditorInput input = this.getCompareEditorInput();
            IWorkbenchPage page = ExtendedPlatformUI.getActivePage();
            IReusableEditor editor = this.getReusableEditor();
            this.openCompareEditor(input, page, editor);
        }
        catch (InterruptedException ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
        }
    }

    protected EObject getModelRoot(IFile file) {
        Assert.isNotNull((Object)file);
        return EcorePlatformUtil.loadModelRoot((IFile)file);
    }

    protected ComparisonSnapshot createComparisonSnapshot(MatchModel matchModel, DiffModel diffModel) {
        ComparisonResourceSnapshot snapshot = DiffFactory.eINSTANCE.createComparisonResourceSnapshot();
        snapshot.setDate(Calendar.getInstance().getTime());
        snapshot.setDiff(diffModel);
        snapshot.setMatch(matchModel);
        return snapshot;
    }

    protected CompareEditorInput getCompareEditorInput() {
        IPreferenceStore ps;
        ModelElementCompareEditorInput input = new ModelElementCompareEditorInput(this.comparisonSnapshot);
        CompareConfiguration configuration = input.getCompareConfiguration();
        if (configuration != null && (ps = configuration.getPreferenceStore()) != null) {
            configuration.setProperty("USE_OUTLINE_VIEW", (Object)ps.getBoolean("org.eclipse.compare.UseOutlineView"));
        }
        return input;
    }

    protected IReusableEditor getReusableEditor() {
        return null;
    }

    protected void openCompareEditor(final CompareEditorInput input, final IWorkbenchPage page, final IReusableEditor editor) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (editor != null && !editor.getSite().getShell().isDisposed()) {
                    editor.setInput((IEditorInput)input);
                    return;
                }
                if (page != null) {
                    try {
                        page.openEditor((IEditorInput)input, BasicCompareAction.this.getCompareEditorId(input));
                    }
                    catch (PartInitException e) {
                        PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)e));
                        MessageDialog.openError((Shell)ExtendedPlatformUI.getActiveShell(), (String)Messages.error_openEditorError, (String)e.getMessage());
                    }
                } else {
                    String msg = Messages.error_noActiveWorkbenchPage;
                    PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)new NullPointerException(msg));
                    MessageDialog.openError((Shell)ExtendedPlatformUI.getActiveShell(), (String)Messages.error_openEditorError, (String)msg);
                }
            }
        };
        Display display = ExtendedPlatformUI.getDisplay();
        if (display != null) {
            display.syncExec(runnable);
        } else {
            runnable.run();
        }
    }

    protected String getCompareEditorId(CompareEditorInput input) {
        return ModelCompareEditor.ID;
    }
}

