/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.search.ui.providers;

import java.util.HashSet;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.sphinx.emf.search.ui.ModelSearchResult;
import org.eclipse.sphinx.emf.search.ui.pages.ModelSearchResultViewPage;
import org.eclipse.sphinx.emf.search.ui.providers.AbstractModelSearchContentProvider;
import org.eclipse.swt.widgets.Table;

public class ModelSeachTableContentProvider
extends AbstractModelSearchContentProvider {
    public ModelSeachTableContentProvider(ModelSearchResultViewPage page) {
        super(page);
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof ModelSearchResult) {
            HashSet<Object> filteredElements = new HashSet<Object>();
            Object[] rawElements = ((ModelSearchResult)inputElement).getElements();
            int limit = this.getPage().getElementLimit();
            Object[] objectArray = rawElements;
            int n = rawElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object rawElement = objectArray[n2];
                if (this.getPage().getDisplayedMatchCount(rawElement) > 0) {
                    filteredElements.add(rawElement);
                    if (limit != -1 && limit < filteredElements.size()) break;
                }
                ++n2;
            }
            return filteredElements.toArray();
        }
        return this.EMPTY_ARR;
    }

    @Override
    public void elementsChanged(Object[] updatedElements) {
        if (this.getSearchResult() == null) {
            return;
        }
        int addLimit = this.getAddLimit();
        TableViewer viewer = (TableViewer)this.getPage().getViewer();
        HashSet<Object> updated = new HashSet<Object>();
        HashSet<Object> added = new HashSet<Object>();
        HashSet<Object> removed = new HashSet<Object>();
        Object[] objectArray = updatedElements;
        int n = updatedElements.length;
        int n2 = 0;
        while (n2 < n) {
            Object updatedElement = objectArray[n2];
            if (this.getPage().getDisplayedMatchCount(updatedElement) > 0) {
                if (viewer.testFindItem(updatedElement) != null) {
                    updated.add(updatedElement);
                } else if (addLimit > 0) {
                    added.add(updatedElement);
                    --addLimit;
                }
            } else {
                removed.add(updatedElement);
            }
            ++n2;
        }
        viewer.add(added.toArray());
        viewer.update(updated.toArray(), new String[]{"org.eclipse.sphinx.emf.search.ui.matchCount"});
        viewer.remove(removed.toArray());
    }

    private int getAddLimit() {
        int limit = this.getPage().getElementLimit();
        if (limit != -1) {
            Table table = (Table)this.getPage().getViewer().getControl();
            int itemCount = table.getItemCount();
            if (itemCount >= limit) {
                return 0;
            }
            return limit - itemCount;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public void clear() {
        this.getPage().getViewer().refresh();
    }
}

