/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Optional;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.eef.ide.ui.internal.EEFIdeUiPlugin;
import org.eclipse.eef.ide.ui.internal.Messages;
import org.eclipse.eef.ide.ui.internal.resource.FileProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public final class EEFImageUtils {
    private EEFImageUtils() {
    }

    public static Optional<Image> getImage(String imgPath) {
        return FileProvider.getDefault().getFile((IPath)new Path(imgPath)).flatMap(imageFile -> {
            Optional<Object> optionalImage = Optional.empty();
            if (imageFile.exists() && imageFile.canRead()) {
                try {
                    ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)imageFile.toURI().toURL());
                    optionalImage = Optional.ofNullable(ExtendedImageRegistry.INSTANCE.getImage((Object)imageDescriptor));
                }
                catch (MalformedURLException e) {
                    EEFIdeUiPlugin.INSTANCE.log(e);
                }
            } else {
                String message = MessageFormat.format(Messages.EEFIdeUiPlugin_fileNotFound, imgPath);
                EEFIdeUiPlugin.getPlugin().error(message);
            }
            return optionalImage;
        });
    }

    public static Optional<ImageDescriptor> getImageDescriptor(String imgPath) {
        return FileProvider.getDefault().getFile((IPath)new Path(imgPath)).flatMap(imageFile -> {
            Optional<Object> optionalImageDescriptor = Optional.empty();
            if (imageFile.exists() && imageFile.canRead()) {
                try {
                    optionalImageDescriptor = Optional.of(ImageDescriptor.createFromURL((URL)imageFile.toURI().toURL()));
                }
                catch (MalformedURLException e) {
                    EEFIdeUiPlugin.INSTANCE.log(e);
                }
            } else {
                String message = MessageFormat.format(Messages.EEFIdeUiPlugin_fileNotFound, imgPath);
                EEFIdeUiPlugin.getPlugin().error(message);
            }
            return optionalImageDescriptor;
        });
    }
}

