/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.diagram.business.internal.helper.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.helper.task.AbstractCommandTask;
import org.eclipse.sirius.business.api.helper.task.ICreationTask;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.RefreshIdsHolder;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.ArrangeConstraint;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DSemanticDiagram;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManager;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramMappingsManagerRegistry;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.operations.AbstractNodeMappingSpecOperations;
import org.eclipse.sirius.diagram.business.internal.sync.DDiagramElementSynchronizer;
import org.eclipse.sirius.diagram.business.internal.sync.DNodeCandidate;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.tool.ContainerCreationDescription;
import org.eclipse.sirius.diagram.tools.api.Messages;
import org.eclipse.sirius.diagram.tools.api.preferences.SiriusDiagramPreferencesKeys;
import org.eclipse.sirius.diagram.tools.api.refresh.BestMappingGetter;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.tools.api.command.DCommand;
import org.eclipse.sirius.viewpoint.DRepresentationElement;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class CreateContainerTask
extends AbstractCommandTask
implements ICreationTask {
    private final DCommand cmd;
    private final ContainerCreationDescription tool;
    private final ModelAccessor modelAccessor;
    private DragAndDropTarget containerView;
    private Collection<AbstractDNode> createdAbstractDNodes = new ArrayList<AbstractDNode>();

    public CreateContainerTask(ContainerCreationDescription tool, DCommand cmd, ModelAccessor modelAccessor, DragAndDropTarget containerView) {
        this.tool = tool;
        this.cmd = cmd;
        this.modelAccessor = modelAccessor;
        this.containerView = containerView;
    }

    public void execute() {
        EObjectQuery eObjectQuery = new EObjectQuery((EObject)this.containerView);
        Session session = eObjectQuery.getSession();
        Option<DDiagram> parentDiagramOption = eObjectQuery.getParentDiagram();
        if (parentDiagramOption.some() && parentDiagramOption.get() instanceof DSemanticDiagram) {
            DSemanticDiagram dSemanticDiagram = (DSemanticDiagram)parentDiagramOption.get();
            this.createContainers(session, dSemanticDiagram);
        }
    }

    private void createContainers(Session session, DSemanticDiagram dSemanticDiagram) {
        IInterpreter interpreter = session.getInterpreter();
        DDiagramElementSynchronizer dDiagramElementSynchronizer = new DDiagramElementSynchronizer(dSemanticDiagram, interpreter, this.modelAccessor);
        Collection createdObjects = this.cmd.getCreatedObjects();
        DiagramMappingsManager mappingManager = DiagramMappingsManagerRegistry.INSTANCE.getDiagramMappingsManager(session, (DDiagram)dSemanticDiagram);
        for (EObject semanticElt : createdObjects) {
            DNodeCandidate abstractDNodeCandidate;
            AbstractDNode createdAbstractDNode;
            BestMappingGetter bestMappingGetter = new BestMappingGetter((DSemanticDecorator)this.containerView, semanticElt);
            ContainerMapping bestMapping = bestMappingGetter.getBestContainerMapping((Collection<ContainerMapping>)this.tool.getContainerMappings());
            if (bestMapping == null || (createdAbstractDNode = dDiagramElementSynchronizer.createNewNode(mappingManager, abstractDNodeCandidate = new DNodeCandidate((AbstractNodeMapping)bestMapping, semanticElt, this.containerView, RefreshIdsHolder.getOrCreateHolder((EObject)dSemanticDiagram)), false)) == null) continue;
            AbstractNodeMappingSpecOperations.createBorderingNodes((AbstractNodeMapping)bestMapping, semanticElt, (DDiagramElement)createdAbstractDNode, Collections.emptyList(), (DDiagram)dSemanticDiagram);
            if (this.isAutoPinOnCreateEnabled()) {
                createdAbstractDNode.getArrangeConstraints().add((Object)ArrangeConstraint.KEEP_LOCATION);
                createdAbstractDNode.getArrangeConstraints().add((Object)ArrangeConstraint.KEEP_RATIO);
                createdAbstractDNode.getArrangeConstraints().add((Object)ArrangeConstraint.KEEP_SIZE);
            }
            AbstractNodeMappingSpecOperations.setInitialVisibility((DDiagramElement)createdAbstractDNode, (DDiagram)dSemanticDiagram, session);
            this.createdAbstractDNodes.add(createdAbstractDNode);
        }
    }

    private boolean isAutoPinOnCreateEnabled() {
        return Platform.getPreferencesService().getBoolean("org.eclipse.sirius.diagram", SiriusDiagramPreferencesKeys.PREF_AUTO_PIN_ON_CREATE.name(), false, null);
    }

    public String getLabel() {
        return Messages.CreateContainerTask_label;
    }

    public Collection<EObject> getCreatedElements() {
        return Collections.emptySet();
    }

    public Collection<DRepresentationElement> getCreatedRepresentationElements() {
        return new ArrayList<AbstractDNode>(this.createdAbstractDNodes);
    }

    public Collection<EObject> getAffectedElements() {
        return Collections.emptySet();
    }

    public Collection<EObject> getCreatedReferences() {
        return Collections.emptySet();
    }
}

