/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.feature.table.pt1.ssli;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.ToDoubleFunction;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.graph.Digraph;
import org.eclipse.set.basis.graph.Digraphs;
import org.eclipse.set.basis.graph.DirectedEdgePath;
import org.eclipse.set.core.services.enumtranslation.EnumTranslationService;
import org.eclipse.set.feature.table.pt1.AbstractPlanPro2TableModelTransformator;
import org.eclipse.set.model.tablemodel.ColumnDescriptor;
import org.eclipse.set.model.tablemodel.Table;
import org.eclipse.set.model.tablemodel.TableRow;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.BereichObjektExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektExtensions;
import org.eclipse.set.ppmodel.extensions.SignalExtensions;
import org.eclipse.set.ppmodel.extensions.container.MultiContainer_AttributeGroup;
import org.eclipse.set.ppmodel.extensions.utils.Case;
import org.eclipse.set.ppmodel.extensions.utils.TopGraph;
import org.eclipse.set.toolboxmodel.BasisTypen.Bezeichnung_Element_AttributeGroup;
import org.eclipse.set.toolboxmodel.BasisTypen.Bezeichnung_Lageplan_Kurz_TypeClass;
import org.eclipse.set.toolboxmodel.BasisTypen.Bezeichnung_Tabelle_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Basis_Objekt;
import org.eclipse.set.toolboxmodel.Basisobjekte.Bereich_Objekt;
import org.eclipse.set.toolboxmodel.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.toolboxmodel.Basisobjekte.Ur_Objekt;
import org.eclipse.set.toolboxmodel.Fahrstrasse.ENUMRangierGegenfahrtausschluss;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Fahrweg;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Rangier_AttributeGroup;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Fstr_Zug_Rangier;
import org.eclipse.set.toolboxmodel.Fahrstrasse.Rangier_Gegenfahrtausschluss_TypeClass;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Knoten;
import org.eclipse.set.toolboxmodel.Gleis.Bez_Gleis_Bezeichnung_TypeClass;
import org.eclipse.set.toolboxmodel.Gleis.Gleis_Bezeichnung;
import org.eclipse.set.toolboxmodel.Gleis.Gleis_Bezeichnung_Bezeichnung_AttributeGroup;
import org.eclipse.set.toolboxmodel.Signale.ENUMSignalArt;
import org.eclipse.set.toolboxmodel.Signale.Signal;
import org.eclipse.set.toolboxmodel.Signale.Signal_Art_TypeClass;
import org.eclipse.set.toolboxmodel.Signale.Signal_Fstr_Aus_Inselgleis_AttributeGroup;
import org.eclipse.set.toolboxmodel.Signale.Signal_Real_Aktiv_Schirm_AttributeGroup;
import org.eclipse.set.toolboxmodel.Signale.Signal_Real_AttributeGroup;
import org.eclipse.set.utils.table.TMFactory;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class SsliTransformator
extends AbstractPlanPro2TableModelTransformator {
    private TMFactory factory = null;
    private MultiContainer_AttributeGroup container = null;
    private final HashMap<ArrayList<?>, Table> _createCache_transform = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, TableRow> _createCache_transform_1 = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, String> _createCache_transformToBezeichnung = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, Set<ENUMRangierGegenfahrtausschluss>> _createCache_transformToGegenfahrtausschluesse = CollectionLiterals.newHashMap();

    public SsliTransformator(Set<ColumnDescriptor> cols, EnumTranslationService enumTranslationService) {
        super(cols, enumTranslationService);
    }

    public Table transformTableContent(MultiContainer_AttributeGroup container, TMFactory factory) {
        this.factory = factory;
        this.container = container;
        return this.transform(container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Table transform(MultiContainer_AttributeGroup container) {
        Table _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new MultiContainer_AttributeGroup[]{container});
        HashMap<ArrayList<?>, Table> hashMap = this._createCache_transform;
        synchronized (hashMap) {
            Table _table;
            if (this._createCache_transform.containsKey(_cacheKey)) {
                return this._createCache_transform.get(_cacheKey);
            }
            _result = _table = this.factory.getTable();
            this._createCache_transform.put(_cacheKey, _result);
        }
        this._init_transform(_result, container);
        return _result;
    }

    private void _init_transform(Table it, MultiContainer_AttributeGroup container) {
        Functions.Function1<Gleis_BezeichnungBegrenzung, Boolean> _function = new Functions.Function1<Gleis_BezeichnungBegrenzung, Boolean>(){

            public Boolean apply(Gleis_BezeichnungBegrenzung it_1) {
                return SsliTransformator.this.getGeneralbedingung(it_1);
            }
        };
        Consumer<Gleis_BezeichnungBegrenzung> _function_1 = new Consumer<Gleis_BezeichnungBegrenzung>(){

            @Override
            public void accept(Gleis_BezeichnungBegrenzung it_1) {
                boolean _isInterrupted = Thread.currentThread().isInterrupted();
                if (_isInterrupted) {
                    return;
                }
                SsliTransformator.this.transform(it_1);
            }
        };
        IterableExtensions.filter(this.transformToBegrenzungen(container.getGleisBezeichnung(), container.getSignal()), (Functions.Function1)_function).forEach(_function_1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableRow transform(Gleis_BezeichnungBegrenzung gleisBezeichnungBegrenzung) {
        TableRow _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Gleis_BezeichnungBegrenzung[]{gleisBezeichnungBegrenzung});
        HashMap<ArrayList<?>, TableRow> hashMap = this._createCache_transform_1;
        synchronized (hashMap) {
            TableRow _newTableRow;
            if (this._createCache_transform_1.containsKey(_cacheKey)) {
                return this._createCache_transform_1.get(_cacheKey);
            }
            _result = _newTableRow = this.factory.newTableRow((Ur_Objekt)gleisBezeichnungBegrenzung.gleisBezeichnung);
            this._createCache_transform_1.put(_cacheKey, _result);
        }
        this._init_transform_1(_result, gleisBezeichnungBegrenzung);
        return _result;
    }

    private void _init_transform_1(TableRow it, Gleis_BezeichnungBegrenzung gleisBezeichnungBegrenzung) {
        final TableRow row = it;
        Gleis_Bezeichnung gleisBezeichnung = gleisBezeichnungBegrenzung.gleisBezeichnung;
        Iterable _plus = Iterables.concat(gleisBezeichnungBegrenzung.zgFahrtVerbot, gleisBezeichnungBegrenzung.raFahrtVerbot);
        final Iterable begrenzungen = Iterables.concat((Iterable)_plus, gleisBezeichnungBegrenzung.raGegenfahrtausschluss);
        Functions.Function1<Gleis_Bezeichnung, String> _function = new Functions.Function1<Gleis_Bezeichnung, String>(){

            public String apply(Gleis_Bezeichnung it_1) {
                return SsliTransformator.this.transformToBezeichnung(it_1);
            }
        };
        this.fill(it, this.getColumn(this.cols, "A"), gleisBezeichnung, (Functions.Function1)_function);
        final List<Double> laengenBegrenzung = this.getLaengenBegrenzung(gleisBezeichnungBegrenzung);
        Functions.Function1<Gleis_Bezeichnung, List<String>> _function_1 = new Functions.Function1<Gleis_Bezeichnung, List<String>>(){

            public List<String> apply(Gleis_Bezeichnung it_1) {
                Functions.Function1<Double, String> _function = new Functions.Function1<Double, String>(){

                    public String apply(Double it_2) {
                        return String.format("%.0f", Math.floor(it_2));
                    }
                };
                return ListExtensions.map((List)laengenBegrenzung, (Functions.Function1)_function);
            }
        };
        Functions.Function1<String, String> _function_2 = new Functions.Function1<String, String>(){

            public String apply(String it_1) {
                return it_1;
            }
        };
        this.fillIterable(it, this.getColumn(this.cols, "B"), gleisBezeichnung, (Functions.Function1)_function_1, null, (Functions.Function1)_function_2);
        Functions.Function1<Gleis_Bezeichnung, Iterable<String>> _function_3 = new Functions.Function1<Gleis_Bezeichnung, Iterable<String>>(){

            public Iterable<String> apply(Gleis_Bezeichnung it_1) {
                Functions.Function1<Signal, Boolean> _function = new Functions.Function1<Signal, Boolean>(){

                    public Boolean apply(Signal it_2) {
                        return SsliTransformator.lageplanKurzContains(it_2, "POUVWY", true);
                    }
                };
                Functions.Function1<Signal, String> _function_1 = new Functions.Function1<Signal, String>(){

                    public String apply(Signal it_2) {
                        Bezeichnung_Element_AttributeGroup _bezeichnung = it_2.getBezeichnung();
                        Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = null;
                        if (_bezeichnung != null) {
                            _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
                        }
                        String _wert = null;
                        if (_bezeichnungTabelle != null) {
                            _wert = _bezeichnungTabelle.getWert();
                        }
                        return _wert;
                    }
                };
                return IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)begrenzungen, (Functions.Function1)_function), (Functions.Function1)_function_1);
            }
        };
        Functions.Function1<String, String> _function_4 = new Functions.Function1<String, String>(){

            public String apply(String it_1) {
                return it_1;
            }
        };
        this.fillIterable(it, this.getColumn(this.cols, "C"), gleisBezeichnung, (Functions.Function1)_function_3, AbstractPlanPro2TableModelTransformator.MIXED_STRING_COMPARATOR, (Functions.Function1)_function_4);
        Functions.Function1<Gleis_Bezeichnung, Iterable<String>> _function_5 = new Functions.Function1<Gleis_Bezeichnung, Iterable<String>>(){

            public Iterable<String> apply(Gleis_Bezeichnung it_1) {
                Functions.Function1<Signal, Boolean> _function = new Functions.Function1<Signal, Boolean>(){

                    public Boolean apply(Signal it_2) {
                        return SsliTransformator.lageplanKurzContains(it_2, "NQRSTX", false);
                    }
                };
                Functions.Function1<Signal, String> _function_1 = new Functions.Function1<Signal, String>(){

                    public String apply(Signal it_2) {
                        Bezeichnung_Element_AttributeGroup _bezeichnung = it_2.getBezeichnung();
                        Bezeichnung_Tabelle_TypeClass _bezeichnungTabelle = null;
                        if (_bezeichnung != null) {
                            _bezeichnungTabelle = _bezeichnung.getBezeichnungTabelle();
                        }
                        String _wert = null;
                        if (_bezeichnungTabelle != null) {
                            _wert = _bezeichnungTabelle.getWert();
                        }
                        return _wert;
                    }
                };
                return IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)begrenzungen, (Functions.Function1)_function), (Functions.Function1)_function_1);
            }
        };
        Functions.Function1<String, String> _function_6 = new Functions.Function1<String, String>(){

            public String apply(String it_1) {
                return it_1;
            }
        };
        this.fillIterable(it, this.getColumn(this.cols, "D"), gleisBezeichnung, (Functions.Function1)_function_5, AbstractPlanPro2TableModelTransformator.MIXED_STRING_COMPARATOR, (Functions.Function1)_function_6);
        ColumnDescriptor _column = this.getColumn(this.cols, "E");
        Functions.Function1<Gleis_Bezeichnung, Boolean> _function_7 = new Functions.Function1<Gleis_Bezeichnung, Boolean>(){

            public Boolean apply(Gleis_Bezeichnung it_1) {
                Functions.Function1<Signal, Boolean> _function = new Functions.Function1<Signal, Boolean>(){

                    public Boolean apply(Signal it_2) {
                        boolean _isEmpty;
                        boolean _not;
                        boolean _tripleNotEquals;
                        boolean _and = false;
                        Signal_Fstr_Aus_Inselgleis_AttributeGroup _signalFstrAusInselgleis = it_2.getSignalFstrAusInselgleis();
                        EList _iDZgFahrtGleichzeitigVerbot = null;
                        if (_signalFstrAusInselgleis != null) {
                            _iDZgFahrtGleichzeitigVerbot = _signalFstrAusInselgleis.getIDZgFahrtGleichzeitigVerbot();
                        }
                        boolean bl = _tripleNotEquals = _iDZgFahrtGleichzeitigVerbot != null;
                        _and = !_tripleNotEquals ? false : (_not = !(_isEmpty = it_2.getSignalFstrAusInselgleis().getIDZgFahrtGleichzeitigVerbot().isEmpty()));
                        return _and;
                    }
                };
                return IterableExtensions.exists((Iterable)begrenzungen, (Functions.Function1)_function);
            }
        };
        Functions.Function1<Gleis_Bezeichnung, String> _function_8 = new Functions.Function1<Gleis_Bezeichnung, String>(){

            public String apply(Gleis_Bezeichnung it_1) {
                return SsliTransformator.this.translate(true);
            }
        };
        Case _case = new Case((Functions.Function1)_function_7, (Functions.Function1)_function_8);
        Functions.Function1<Gleis_Bezeichnung, Boolean> _function_9 = new Functions.Function1<Gleis_Bezeichnung, Boolean>(){

            public Boolean apply(Gleis_Bezeichnung it_1) {
                Functions.Function1<Signal, Boolean> _function = new Functions.Function1<Signal, Boolean>(){

                    public Boolean apply(Signal it_2) {
                        return SignalExtensions.isStartOfAnyTrainRoute((Signal)it_2);
                    }
                };
                return IterableExtensions.forall((Iterable)begrenzungen, (Functions.Function1)_function);
            }
        };
        Functions.Function1<Gleis_Bezeichnung, String> _function_10 = new Functions.Function1<Gleis_Bezeichnung, String>(){

            public String apply(Gleis_Bezeichnung it_1) {
                return SsliTransformator.this.translate(false);
            }
        };
        Case _case_1 = new Case((Functions.Function1)_function_9, (Functions.Function1)_function_10);
        this.fillSwitch(it, _column, gleisBezeichnung, new Case[]{_case, _case_1});
        ColumnDescriptor _column_1 = this.getColumn(this.cols, "F");
        Functions.Function1<Gleis_Bezeichnung, Boolean> _function_11 = new Functions.Function1<Gleis_Bezeichnung, Boolean>(){

            public Boolean apply(Gleis_Bezeichnung it_1) {
                Functions.Function1<Signal, Boolean> _function = new Functions.Function1<Signal, Boolean>(){

                    public Boolean apply(Signal it_2) {
                        return SsliTransformator.this.transformToGegenfahrtausschluesse(it_2).contains(ENUMRangierGegenfahrtausschluss.ENUM_RANGIER_GEGENFAHRTAUSSCHLUSS_JA) || SsliTransformator.this.transformToGegenfahrtausschluesse(it_2).contains(ENUMRangierGegenfahrtausschluss.ENUM_RANGIER_GEGENFAHRTAUSSCHLUSS_INSELGLEIS_FREI);
                    }
                };
                return IterableExtensions.exists((Iterable)begrenzungen, (Functions.Function1)_function);
            }
        };
        Functions.Function1<Gleis_Bezeichnung, String> _function_12 = new Functions.Function1<Gleis_Bezeichnung, String>(){

            public String apply(Gleis_Bezeichnung it_1) {
                return SsliTransformator.this.translate(true);
            }
        };
        Case _case_2 = new Case((Functions.Function1)_function_11, (Functions.Function1)_function_12);
        Functions.Function1<Gleis_Bezeichnung, Boolean> _function_13 = new Functions.Function1<Gleis_Bezeichnung, Boolean>(){

            public Boolean apply(Gleis_Bezeichnung it_1) {
                Functions.Function1<Signal, Boolean> _function = new Functions.Function1<Signal, Boolean>(){

                    public Boolean apply(Signal it_2) {
                        return SignalExtensions.isStartOrDestinationOfAnyShuntingRoute((Signal)it_2, (boolean)false);
                    }
                };
                return IterableExtensions.forall((Iterable)begrenzungen, (Functions.Function1)_function);
            }
        };
        Functions.Function1<Gleis_Bezeichnung, String> _function_14 = new Functions.Function1<Gleis_Bezeichnung, String>(){

            public String apply(Gleis_Bezeichnung it_1) {
                return SsliTransformator.this.translate(false);
            }
        };
        Case _case_3 = new Case((Functions.Function1)_function_13, (Functions.Function1)_function_14);
        this.fillSwitch(it, _column_1, gleisBezeichnung, new Case[]{_case_2, _case_3});
        ColumnDescriptor _column_2 = this.getColumn(this.cols, "G");
        Functions.Function1<Gleis_Bezeichnung, Boolean> _function_15 = new Functions.Function1<Gleis_Bezeichnung, Boolean>(){

            public Boolean apply(Gleis_Bezeichnung it_1) {
                Functions.Function1<Signal, Boolean> _function = new Functions.Function1<Signal, Boolean>(){

                    public Boolean apply(Signal it_2) {
                        boolean _isEmpty;
                        boolean _not;
                        boolean _tripleNotEquals;
                        boolean _and = false;
                        Signal_Fstr_Aus_Inselgleis_AttributeGroup _signalFstrAusInselgleis = it_2.getSignalFstrAusInselgleis();
                        EList _iDRaFahrtGleichzeitigVerbot = null;
                        if (_signalFstrAusInselgleis != null) {
                            _iDRaFahrtGleichzeitigVerbot = _signalFstrAusInselgleis.getIDRaFahrtGleichzeitigVerbot();
                        }
                        boolean bl = _tripleNotEquals = _iDRaFahrtGleichzeitigVerbot != null;
                        _and = !_tripleNotEquals ? false : (_not = !(_isEmpty = it_2.getSignalFstrAusInselgleis().getIDRaFahrtGleichzeitigVerbot().isEmpty()));
                        return _and;
                    }
                };
                return IterableExtensions.exists((Iterable)begrenzungen, (Functions.Function1)_function);
            }
        };
        Functions.Function1<Gleis_Bezeichnung, String> _function_16 = new Functions.Function1<Gleis_Bezeichnung, String>(){

            public String apply(Gleis_Bezeichnung it_1) {
                return SsliTransformator.this.translate(true);
            }
        };
        Case _case_4 = new Case((Functions.Function1)_function_15, (Functions.Function1)_function_16);
        Functions.Function1<Gleis_Bezeichnung, Boolean> _function_17 = new Functions.Function1<Gleis_Bezeichnung, Boolean>(){

            public Boolean apply(Gleis_Bezeichnung it_1) {
                Functions.Function1<Signal, Boolean> _function = new Functions.Function1<Signal, Boolean>(){

                    public Boolean apply(Signal it_2) {
                        return SignalExtensions.isStartOrDestinationOfAnyShuntingRoute((Signal)it_2, (boolean)true);
                    }
                };
                return IterableExtensions.forall((Iterable)begrenzungen, (Functions.Function1)_function);
            }
        };
        Functions.Function1<Gleis_Bezeichnung, String> _function_18 = new Functions.Function1<Gleis_Bezeichnung, String>(){

            public String apply(Gleis_Bezeichnung it_1) {
                return SsliTransformator.this.translate(false);
            }
        };
        Case _case_5 = new Case((Functions.Function1)_function_17, (Functions.Function1)_function_18);
        this.fillSwitch(it, _column_2, gleisBezeichnung, new Case[]{_case_4, _case_5});
        Functions.Function1<Gleis_Bezeichnung, String> _function_19 = new Functions.Function1<Gleis_Bezeichnung, String>(){

            public String apply(Gleis_Bezeichnung it_1) {
                return SsliTransformator.this.footnoteTransformation.transform((Basis_Objekt)it_1, row);
            }
        };
        this.fill(it, this.getColumn(this.cols, "H"), gleisBezeichnung, (Functions.Function1)_function_19);
    }

    private List<Double> getLaengenBegrenzung(Gleis_BezeichnungBegrenzung gleis) {
        Functions.Function1<Signal, Boolean> _function;
        Iterable _plus = Iterables.concat(gleis.zgFahrtVerbot, gleis.raFahrtVerbot);
        Iterable begrenzungen = Iterables.concat((Iterable)_plus, gleis.raGegenfahrtausschluss);
        List<Double> shortest = this.getShortestSignalDistance(IterableExtensions.filter((Iterable)begrenzungen, (Functions.Function1)(_function = new Functions.Function1<Signal, Boolean>(){

            public Boolean apply(Signal it) {
                Signal_Real_AttributeGroup _signalReal = it.getSignalReal();
                Signal_Real_Aktiv_Schirm_AttributeGroup _signalRealAktivSchirm = null;
                if (_signalReal != null) {
                    _signalRealAktivSchirm = _signalReal.getSignalRealAktivSchirm();
                }
                Signal_Art_TypeClass _signalArt = null;
                if (_signalRealAktivSchirm != null) {
                    _signalArt = _signalRealAktivSchirm.getSignalArt();
                }
                return Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new ENUMSignalArt[]{ENUMSignalArt.ENUM_SIGNAL_ART_HAUPTSIGNAL, ENUMSignalArt.ENUM_SIGNAL_ART_HAUPTSPERRSIGNAL, ENUMSignalArt.ENUM_SIGNAL_ART_MEHRABSCHNITTSSIGNAL, ENUMSignalArt.ENUM_SIGNAL_ART_MEHRABSCHNITTSSPERRSIGNAL})).contains(_signalArt);
            }
        })));
        if (shortest != null) {
            return shortest;
        }
        return this.getShortestSignalDistance(begrenzungen);
    }

    private List<Double> getShortestSignalDistance(final Iterable<Signal> begrenzungen) {
        Functions.Function1<Signal, List<Double>> _function = new Functions.Function1<Signal, List<Double>>(){

            public List<Double> apply(final Signal signalA) {
                Functions.Function1<Signal, List<Double>> _function = new Functions.Function1<Signal, List<Double>>(){

                    public List<Double> apply(Signal signalB) {
                        List<Double> _xblockexpression = null;
                        if (signalA == signalB) {
                            return null;
                        }
                        _xblockexpression = SsliTransformator.this.createDistances(signalA, signalB);
                        return _xblockexpression;
                    }
                };
                Functions.Function1<List<Double>, Double> _function_1 = new Functions.Function1<List<Double>, Double>(){

                    public Double apply(List<Double> it) {
                        ToDoubleFunction<Double> _function = new ToDoubleFunction<Double>(){

                            @Override
                            public double applyAsDouble(Double d) {
                                return d;
                            }
                        };
                        return it.stream().mapToDouble(_function).sum();
                    }
                };
                List minLenFromA = IterableExtensions.sortBy((Iterable)IterableExtensions.filterNull((Iterable)IterableExtensions.map((Iterable)begrenzungen, (Functions.Function1)_function)), (Functions.Function1)_function_1);
                boolean _isEmpty = minLenFromA.isEmpty();
                if (_isEmpty) {
                    return null;
                }
                return (List)minLenFromA.get(0);
            }
        };
        Iterable minLens = IterableExtensions.filterNull((Iterable)IterableExtensions.map(begrenzungen, (Functions.Function1)_function));
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)minLens);
        if (_isEmpty) {
            return null;
        }
        Functions.Function1<List<Double>, Double> _function_1 = new Functions.Function1<List<Double>, Double>(){

            public Double apply(List<Double> it) {
                ToDoubleFunction<Double> _function = new ToDoubleFunction<Double>(){

                    @Override
                    public double applyAsDouble(Double d) {
                        return d;
                    }
                };
                return it.stream().mapToDouble(_function).sum();
            }
        };
        return (List)IterableExtensions.sortBy((Iterable)minLens, (Functions.Function1)_function_1).get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String transformToBezeichnung(Gleis_Bezeichnung gleisBezeichnung) {
        String _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Gleis_Bezeichnung[]{gleisBezeichnung});
        HashMap<ArrayList<?>, String> hashMap = this._createCache_transformToBezeichnung;
        synchronized (hashMap) {
            String _createBezeichnung;
            if (this._createCache_transformToBezeichnung.containsKey(_cacheKey)) {
                return this._createCache_transformToBezeichnung.get(_cacheKey);
            }
            _result = _createBezeichnung = this.createBezeichnung(gleisBezeichnung);
            this._createCache_transformToBezeichnung.put(_cacheKey, _result);
        }
        this._init_transformToBezeichnung(_result, gleisBezeichnung);
        return _result;
    }

    private void _init_transformToBezeichnung(String it, Gleis_Bezeichnung gleisBezeichnung) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ENUMRangierGegenfahrtausschluss> transformToGegenfahrtausschluesse(Signal signal) {
        HashSet<ENUMRangierGegenfahrtausschluss> _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Signal[]{signal});
        HashMap<ArrayList<?>, Set<ENUMRangierGegenfahrtausschluss>> hashMap = this._createCache_transformToGegenfahrtausschluesse;
        synchronized (hashMap) {
            HashSet<ENUMRangierGegenfahrtausschluss> _hashSet;
            if (this._createCache_transformToGegenfahrtausschluesse.containsKey(_cacheKey)) {
                return this._createCache_transformToGegenfahrtausschluesse.get(_cacheKey);
            }
            _result = _hashSet = new HashSet<ENUMRangierGegenfahrtausschluss>();
            this._createCache_transformToGegenfahrtausschluesse.put(_cacheKey, _result);
        }
        this._init_transformToGegenfahrtausschluesse(_result, signal);
        return _result;
    }

    private void _init_transformToGegenfahrtausschluesse(HashSet<ENUMRangierGegenfahrtausschluss> it, final Signal signal) {
        Functions.Function1<Fstr_Fahrweg, Boolean> _function = new Functions.Function1<Fstr_Fahrweg, Boolean>(){

            public Boolean apply(Fstr_Fahrweg it_1) {
                Basis_Objekt _iDZiel = it_1.getIDZiel();
                Identitaet_TypeClass _identitaet = null;
                if (_iDZiel != null) {
                    _identitaet = _iDZiel.getIdentitaet();
                }
                String _wert = null;
                if (_identitaet != null) {
                    _wert = _identitaet.getWert();
                }
                Identitaet_TypeClass _identitaet_1 = null;
                if (signal != null) {
                    _identitaet_1 = signal.getIdentitaet();
                }
                String _wert_1 = null;
                if (_identitaet_1 != null) {
                    _wert_1 = _identitaet_1.getWert();
                }
                return Objects.equal((Object)_wert, (Object)_wert_1);
            }
        };
        Functions.Function1<Fstr_Fahrweg, Iterable<Fstr_Zug_Rangier>> _function_1 = new Functions.Function1<Fstr_Fahrweg, Iterable<Fstr_Zug_Rangier>>(){

            public Iterable<Fstr_Zug_Rangier> apply(final Fstr_Fahrweg fw) {
                Functions.Function1<Fstr_Zug_Rangier, Boolean> _function = new Functions.Function1<Fstr_Zug_Rangier, Boolean>(){

                    public Boolean apply(Fstr_Zug_Rangier it_1) {
                        Fstr_Fahrweg _iDFstrFahrweg = it_1.getIDFstrFahrweg();
                        Identitaet_TypeClass _identitaet = null;
                        if (_iDFstrFahrweg != null) {
                            _identitaet = _iDFstrFahrweg.getIdentitaet();
                        }
                        String _wert = null;
                        if (_identitaet != null) {
                            _wert = _identitaet.getWert();
                        }
                        Identitaet_TypeClass _identitaet_1 = null;
                        if (fw != null) {
                            _identitaet_1 = fw.getIdentitaet();
                        }
                        String _wert_1 = null;
                        if (_identitaet_1 != null) {
                            _wert_1 = _identitaet_1.getWert();
                        }
                        return Objects.equal((Object)_wert, (Object)_wert_1);
                    }
                };
                return IterableExtensions.filter((Iterable)SsliTransformator.this.container.getFstrZugRangier(), (Functions.Function1)_function);
            }
        };
        Functions.Function1<Fstr_Zug_Rangier, ENUMRangierGegenfahrtausschluss> _function_2 = new Functions.Function1<Fstr_Zug_Rangier, ENUMRangierGegenfahrtausschluss>(){

            public ENUMRangierGegenfahrtausschluss apply(Fstr_Zug_Rangier it_1) {
                Fstr_Rangier_AttributeGroup _fstrRangier = it_1.getFstrRangier();
                Rangier_Gegenfahrtausschluss_TypeClass _rangierGegenfahrtausschluss = null;
                if (_fstrRangier != null) {
                    _rangierGegenfahrtausschluss = _fstrRangier.getRangierGegenfahrtausschluss();
                }
                ENUMRangierGegenfahrtausschluss _wert = null;
                if (_rangierGegenfahrtausschluss != null) {
                    _wert = _rangierGegenfahrtausschluss.getWert();
                }
                return _wert;
            }
        };
        Iterables.addAll(it, (Iterable)IterableExtensions.map((Iterable)IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter((Iterable)this.container.getFstrFahrweg(), (Functions.Function1)_function), (Functions.Function1)_function_1))), (Functions.Function1)_function_2));
    }

    private Iterable<Gleis_BezeichnungBegrenzung> transformToBegrenzungen(Iterable<Gleis_Bezeichnung> gleis, Iterable<Signal> signals) {
        final HashMap result = new HashMap();
        Consumer<Gleis_Bezeichnung> _function = new Consumer<Gleis_Bezeichnung>(){

            @Override
            public void accept(Gleis_Bezeichnung g) {
                Gleis_BezeichnungBegrenzung gleisBegrenzung = new Gleis_BezeichnungBegrenzung(g);
                result.put(g.getBezeichnung().getBezGleisBezeichnung().getWert(), gleisBegrenzung);
                List signaleAufGleis = BereichObjektExtensions.filterContained((Bereich_Objekt)g, (Iterable)SsliTransformator.this.container.getSignal());
                Functions.Function1<Signal, Boolean> _function = new Functions.Function1<Signal, Boolean>(){

                    public Boolean apply(Signal it) {
                        boolean _xblockexpression = false;
                        Set<ENUMRangierGegenfahrtausschluss> ausschluesse = SsliTransformator.this.transformToGegenfahrtausschluesse(it);
                        _xblockexpression = ausschluesse.contains(ENUMRangierGegenfahrtausschluss.ENUM_RANGIER_GEGENFAHRTAUSSCHLUSS_JA) || ausschluesse.contains(ENUMRangierGegenfahrtausschluss.ENUM_RANGIER_GEGENFAHRTAUSSCHLUSS_INSELGLEIS_FREI);
                        return _xblockexpression;
                    }
                };
                gleisBegrenzung.raGegenfahrtausschluss = IterableExtensions.filter((Iterable)signaleAufGleis, (Functions.Function1)_function);
            }
        };
        gleis.forEach(_function);
        Consumer<Signal> _function_1 = new Consumer<Signal>(){

            @Override
            public void accept(final Signal signal) {
                Signal_Fstr_Aus_Inselgleis_AttributeGroup _signalFstrAusInselgleis = null;
                if (signal != null) {
                    _signalFstrAusInselgleis = signal.getSignalFstrAusInselgleis();
                }
                EList _iDRaFahrtGleichzeitigVerbot = null;
                if (_signalFstrAusInselgleis != null) {
                    _iDRaFahrtGleichzeitigVerbot = _signalFstrAusInselgleis.getIDRaFahrtGleichzeitigVerbot();
                }
                EList rafahrt = _iDRaFahrtGleichzeitigVerbot;
                Iterable _filter = null;
                if (rafahrt != null) {
                    Functions.Function1<Gleis_Bezeichnung, Boolean> _function = new Functions.Function1<Gleis_Bezeichnung, Boolean>(){

                        public Boolean apply(Gleis_Bezeichnung gl) {
                            Identitaet_TypeClass _identitaet = gl.getIdentitaet();
                            String _wert = null;
                            if (_identitaet != null) {
                                _wert = _identitaet.getWert();
                            }
                            return result.containsKey(_wert);
                        }
                    };
                    _filter = IterableExtensions.filter((Iterable)rafahrt, (Functions.Function1)_function);
                }
                if (_filter != null) {
                    Consumer<Gleis_Bezeichnung> _function_1 = new Consumer<Gleis_Bezeichnung>(){

                        @Override
                        public void accept(Gleis_Bezeichnung gl) {
                            Identitaet_TypeClass _identitaet = gl.getIdentitaet();
                            String _wert = null;
                            if (_identitaet != null) {
                                _wert = _identitaet.getWert();
                            }
                            ((Gleis_BezeichnungBegrenzung)result.get((Object)_wert)).raFahrtVerbot.add(signal);
                        }
                    };
                    _filter.forEach(_function_1);
                }
                Signal_Fstr_Aus_Inselgleis_AttributeGroup _signalFstrAusInselgleis_1 = null;
                if (signal != null) {
                    _signalFstrAusInselgleis_1 = signal.getSignalFstrAusInselgleis();
                }
                EList _iDZgFahrtGleichzeitigVerbot = null;
                if (_signalFstrAusInselgleis_1 != null) {
                    _iDZgFahrtGleichzeitigVerbot = _signalFstrAusInselgleis_1.getIDZgFahrtGleichzeitigVerbot();
                }
                EList zgfahrt = _iDZgFahrtGleichzeitigVerbot;
                Iterable _filter_1 = null;
                if (zgfahrt != null) {
                    Functions.Function1<Gleis_Bezeichnung, Boolean> _function_2 = new Functions.Function1<Gleis_Bezeichnung, Boolean>(){

                        public Boolean apply(Gleis_Bezeichnung gl) {
                            Identitaet_TypeClass _identitaet = gl.getIdentitaet();
                            String _wert = null;
                            if (_identitaet != null) {
                                _wert = _identitaet.getWert();
                            }
                            return result.containsKey(_wert);
                        }
                    };
                    _filter_1 = IterableExtensions.filter((Iterable)zgfahrt, (Functions.Function1)_function_2);
                }
                if (_filter_1 != null) {
                    Consumer<Gleis_Bezeichnung> _function_3 = new Consumer<Gleis_Bezeichnung>(){

                        @Override
                        public void accept(Gleis_Bezeichnung gl) {
                            Identitaet_TypeClass _identitaet = gl.getIdentitaet();
                            String _wert = null;
                            if (_identitaet != null) {
                                _wert = _identitaet.getWert();
                            }
                            ((Gleis_BezeichnungBegrenzung)result.get((Object)_wert)).zgFahrtVerbot.add(signal);
                        }
                    };
                    _filter_1.forEach(_function_3);
                }
            }
        };
        signals.forEach(_function_1);
        return result.values();
    }

    private String createBezeichnung(Gleis_Bezeichnung gleisBezeichnung) {
        Gleis_Bezeichnung_Bezeichnung_AttributeGroup _bezeichnung = null;
        if (gleisBezeichnung != null) {
            _bezeichnung = gleisBezeichnung.getBezeichnung();
        }
        Bez_Gleis_Bezeichnung_TypeClass _bezGleisBezeichnung = null;
        if (_bezeichnung != null) {
            _bezGleisBezeichnung = _bezeichnung.getBezGleisBezeichnung();
        }
        String _wert = null;
        if (_bezGleisBezeichnung != null) {
            _wert = _bezGleisBezeichnung.getWert();
        }
        return _wert;
    }

    private List<Double> createDistances(Signal a, Signal b) {
        Iterable _tOPKante = BasisAttributExtensions.getContainer((EObject)a).getTOPKante();
        TopGraph topGraph = new TopGraph(_tOPKante);
        Set paths = Digraphs.getPaths((Digraph)topGraph, (Collection)PunktObjektExtensions.getSinglePoints((Punkt_Objekt)a), (Collection)PunktObjektExtensions.getSinglePoints((Punkt_Objekt)b));
        Functions.Function1<DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Double> _function = new Functions.Function1<DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Double>(){

            public Double apply(DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> it) {
                return it.getLength();
            }
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.map((Iterable)paths, (Functions.Function1)_function));
    }

    private boolean getGeneralbedingung(Gleis_BezeichnungBegrenzung gleisBezeichnung) {
        return gleisBezeichnung.zgFahrtVerbot.size() >= 2 || gleisBezeichnung.raFahrtVerbot.size() >= 2 || IterableExtensions.size(gleisBezeichnung.raGegenfahrtausschluss) == 2;
    }

    private static boolean lageplanKurzContains(Signal signal, String letters, boolean isEven) {
        String bezeichnung;
        Bezeichnung_Element_AttributeGroup _bezeichnung = null;
        if (signal != null) {
            _bezeichnung = signal.getBezeichnung();
        }
        Bezeichnung_Lageplan_Kurz_TypeClass _bezeichnungLageplanKurz = null;
        if (_bezeichnung != null) {
            _bezeichnungLageplanKurz = _bezeichnung.getBezeichnungLageplanKurz();
        }
        String _wert = null;
        if (_bezeichnungLageplanKurz != null) {
            _wert = _bezeichnungLageplanKurz.getWert();
        }
        if ((bezeichnung = _wert) == null) {
            return false;
        }
        Functions.Function1<Character, Boolean> _function = new Functions.Function1<Character, Boolean>(){

            public Boolean apply(Character it) {
                return bezeichnung.contains(it.toString());
            }
        };
        boolean _exists = IterableExtensions.exists((Iterable)((Iterable)Conversions.doWrapArray((Object)letters.toCharArray())), (Functions.Function1)_function);
        if (_exists) {
            return true;
        }
        try {
            int bezeichnungsNummer = Integer.parseInt(bezeichnung);
            if (isEven) {
                return bezeichnungsNummer % 2 == 0;
            }
            return bezeichnungsNummer % 2 != 0;
        }
        catch (Throwable _t) {
            if (!(_t instanceof NumberFormatException)) {
                throw Exceptions.sneakyThrow((Throwable)_t);
            }
            return false;
        }
    }

    private static class Gleis_BezeichnungBegrenzung {
        private Gleis_Bezeichnung gleisBezeichnung;
        private List<Signal> zgFahrtVerbot = new ArrayList<Signal>();
        private List<Signal> raFahrtVerbot = new ArrayList<Signal>();
        private Iterable<Signal> raGegenfahrtausschluss = new ArrayList<Signal>();

        public Gleis_BezeichnungBegrenzung(Gleis_Bezeichnung bezeichnung) {
            this.gleisBezeichnung = bezeichnung;
        }
    }
}

