/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.browser.cef.handlers;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.set.browser.RequestHandler;
import org.eclipse.set.browser.lib.ChromiumLib;
import org.eclipse.set.browser.lib.cef_download_item_t;
import org.eclipse.set.browser.lib.cef_request_t;
import org.eclipse.set.browser.lib.cef_response_t;

public class ResourceHandler {
    private final long cefResourceHandler = ChromiumLib.allocate_cef_resource_handler_t((Object)this);
    private final RequestImpl request = new RequestImpl();
    private final RequestHandler requestHandler;
    private final ResponseImpl response = new ResponseImpl();

    public ResourceHandler(RequestHandler requestHandler) {
        this.requestHandler = requestHandler;
    }

    public void dispose() {
        ChromiumLib.deallocate_cef_resource_handler_t((long)this.cefResourceHandler);
    }

    public long get() {
        return this.cefResourceHandler;
    }

    private void get_response_headers(long self, long cef_response, long response_length, long redirectUrl) throws IOException {
        this.response.cefResponse = cef_response;
        this.response.setMimeType("text/plain");
        this.response.setResponseData("");
        try {
            this.requestHandler.onRequest(this.request, this.response);
        }
        catch (Exception e) {
            this.response.setMimeType("text/plain");
            this.response.setResponseData("Internal server error");
            this.response.setStatus(500);
        }
        ChromiumLib.cefswt_set_intptr((long)response_length, (int)this.response.responseStream.available());
    }

    private int open(long self, long cef_request, long handle_request_ptr, long callback) {
        ChromiumLib.cefswt_set_intptr((long)handle_request_ptr, (int)1);
        this.request.cefRequest = cef_request;
        return 1;
    }

    private int read(long self, long data_out, int bytes_to_read, long bytes_read_ptr, long callback) throws IOException {
        byte[] bytes = this.response.responseStream.readNBytes(bytes_to_read);
        ChromiumLib.cefswt_set_intptr((long)bytes_read_ptr, (int)bytes.length);
        if (bytes.length > 0) {
            cef_download_item_t.cefswt_copy_bytes((long)data_out, (byte[])bytes, (long)bytes.length);
            return 1;
        }
        this.response.responseStream.close();
        return 0;
    }

    class RequestImpl
    implements RequestHandler.Request {
        private long cefRequest;

        RequestImpl() {
        }

        @Override
        public String getHeader(String headerName) {
            return cef_request_t.cefswt_request_get_header_by_name((long)this.cefRequest, (String)headerName);
        }

        @Override
        public String getMethod() {
            return cef_request_t.cefswt_request_get_method((long)this.cefRequest);
        }

        @Override
        public String getURL() {
            return cef_request_t.cefswt_request_get_url((long)this.cefRequest);
        }
    }

    class ResponseImpl
    implements RequestHandler.Response {
        private long cefResponse;
        private InputStream responseStream;

        ResponseImpl() {
        }

        @Override
        public void setHeader(String headerName, String headerValue) {
            cef_response_t.cefswt_response_set_header((long)this.cefResponse, (String)headerName, (String)headerValue);
        }

        @Override
        public void setMimeType(String mimeType) {
            cef_response_t.cefswt_response_set_mime_type((long)this.cefResponse, (String)mimeType);
        }

        @Override
        public void setResponseData(InputStream stream) {
            this.responseStream = stream;
        }

        @Override
        public void setResponseData(String data) {
            this.setResponseData(new ByteArrayInputStream(data.getBytes()));
        }

        @Override
        public void setStatus(int statusCode) {
            cef_response_t.cefswt_response_set_status_code((long)this.cefResponse, (int)statusCode);
        }
    }
}

