/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions.utils;

import org.eclipse.set.toolboxmodel.Geodaten.ENUMGEOKoordinatensystem;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.proj4j.CRSFactory;
import org.locationtech.proj4j.CoordinateReferenceSystem;
import org.locationtech.proj4j.CoordinateTransform;
import org.locationtech.proj4j.CoordinateTransformFactory;
import org.locationtech.proj4j.ProjCoordinate;

public class CoordinateExtensions {
    public static String CRS_CR0_PARAMETER = "+proj=tmerc +lat_0=0 +lon_0=6  +k=1 +x_0=2500000 +y_0=0 +ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.455,6.7 +units=m +no_defs";
    public static String CRS_DR0_PARAMETER = "+proj=tmerc +lat_0=0 +lon_0=9  +k=1 +x_0=3500000 +y_0=0 +ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.455,6.7 +units=m +no_defs";
    public static String CRS_ERO_PARAMETER = "+proj=tmerc +lat_0=0 +lon_0=12 +k=1 +x_0=4500000 +y_0=0 +ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.455,6.7 +units=m +no_defs";
    public static String CRS_FRO_PARAMETER = "+proj=tmerc +lat_0=0 +lon_0=15 +k=1 +x_0=5500000 +y_0=0 +ellps=bessel +towgs84=598.1,73.7,418.2,0.202,0.045,-2.455,6.7 +units=m +no_defs";

    public static Coordinate rotateAroundPoint(Coordinate coordinate, double angle, Coordinate point) {
        double x = coordinate.x - point.x;
        double y = coordinate.y - point.y;
        double si = Math.sin(angle);
        double co = Math.cos(angle);
        double newx = x * co - y * si + point.x;
        double newy = x * si + y * co + point.y;
        double _z = coordinate.getZ();
        return new Coordinate(newx, newy, _z);
    }

    public static Coordinate rotateAroundOrigin(Coordinate coordinate, double angle) {
        Coordinate _coordinate = new Coordinate(0.0, 0.0, 0.0);
        return CoordinateExtensions.rotateAroundPoint(coordinate, angle, _coordinate);
    }

    public static Coordinate offsetBy(Coordinate coordinate, double xoffset, double yoffset) {
        double _z = coordinate.getZ();
        return new Coordinate(coordinate.x + xoffset, coordinate.y + yoffset, _z);
    }

    public static Coordinate mirrorY(Coordinate coordinate) {
        double _z = coordinate.getZ();
        return new Coordinate(coordinate.x, -coordinate.y, _z);
    }

    public static double getAngleBetweenPoints(Coordinate origin, Coordinate coordinate) {
        double dx = origin.x - coordinate.x;
        double dy = origin.y - coordinate.y;
        return Math.atan2(dy, dx);
    }

    public static Coordinate transformCRS(Coordinate originCoor, ENUMGEOKoordinatensystem source, ENUMGEOKoordinatensystem target) {
        return CoordinateExtensions.transformCRS(originCoor.x, originCoor.y, source, target);
    }

    public static Coordinate transformCRS(double x, double y, ENUMGEOKoordinatensystem source, ENUMGEOKoordinatensystem target) {
        CoordinateReferenceSystem sourceCRS = CoordinateExtensions.createCRS(source);
        CoordinateReferenceSystem targetCRS = CoordinateExtensions.createCRS(target);
        if (sourceCRS == null || targetCRS == null) {
            return new Coordinate(x, y);
        }
        CoordinateTransformFactory transformFactory = new CoordinateTransformFactory();
        ProjCoordinate targetCoor = new ProjCoordinate();
        CoordinateTransform _createTransform = transformFactory.createTransform(sourceCRS, targetCRS);
        ProjCoordinate _projCoordinate = new ProjCoordinate(x, y);
        _createTransform.transform(_projCoordinate, targetCoor);
        return new Coordinate(targetCoor.x, targetCoor.y);
    }

    private static CoordinateReferenceSystem createCRS(ENUMGEOKoordinatensystem crs) {
        CRSFactory crsFactory = new CRSFactory();
        if (crs != null) {
            switch (crs) {
                case ENUMGEO_KOORDINATENSYSTEM_CR0: {
                    return crsFactory.createFromParameters(crs.getLiteral(), CRS_CR0_PARAMETER);
                }
                case ENUMGEO_KOORDINATENSYSTEM_DR0: {
                    return crsFactory.createFromParameters(crs.getLiteral(), CRS_DR0_PARAMETER);
                }
                case ENUMGEO_KOORDINATENSYSTEM_ER0: {
                    return crsFactory.createFromParameters(crs.getLiteral(), CRS_ERO_PARAMETER);
                }
                case ENUMGEO_KOORDINATENSYSTEM_FR0: {
                    return crsFactory.createFromParameters(crs.getLiteral(), CRS_FRO_PARAMETER);
                }
            }
            return null;
        }
        return null;
    }
}

