/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.MissingSupplier;
import org.eclipse.set.basis.cache.Cache;
import org.eclipse.set.basis.graph.DirectedEdge;
import org.eclipse.set.basis.graph.DirectedElement;
import org.eclipse.set.basis.graph.DirectedElementImpl;
import org.eclipse.set.core.services.Services;
import org.eclipse.set.core.services.cache.CacheService;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.BasisObjektExtensions;
import org.eclipse.set.ppmodel.extensions.BereichObjektExtensions;
import org.eclipse.set.ppmodel.extensions.ContainerExtensions;
import org.eclipse.set.ppmodel.extensions.GeoKanteExtensions;
import org.eclipse.set.ppmodel.extensions.GeoKnotenExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektTopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.TopKnotenExtensions;
import org.eclipse.set.ppmodel.extensions.utils.CollectionExtensions;
import org.eclipse.set.ppmodel.extensions.utils.Distance;
import org.eclipse.set.ppmodel.extensions.utils.SetExtensions;
import org.eclipse.set.ppmodel.extensions.utils.SymbolArrangement;
import org.eclipse.set.toolboxmodel.BasisTypen.ENUMWirkrichtung;
import org.eclipse.set.toolboxmodel.Basisobjekte.Basis_Objekt;
import org.eclipse.set.toolboxmodel.Basisobjekte.Bereich_Objekt_Teilbereich_AttributeGroup;
import org.eclipse.set.toolboxmodel.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.toolboxmodel.Geodaten.ENUMTOPAnschluss;
import org.eclipse.set.toolboxmodel.Geodaten.GEO_Kante;
import org.eclipse.set.toolboxmodel.Geodaten.GEO_Knoten;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Knoten;
import org.eclipse.set.toolboxmodel.Gleis.Gleis_Lichtraum;
import org.eclipse.set.toolboxmodel.Weichen_und_Gleissperren.W_Kr_Gsp_Element;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.locationtech.jts.geom.Coordinate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopKanteExtensions
extends BasisObjektExtensions {
    private static final double TOLERANCE = 0.002;
    private static final Logger logger = LoggerFactory.getLogger(TopKanteExtensions.class);
    private static Cache cache;

    public static TOP_Knoten getTOPKnotenA(TOP_Kante topKante) {
        return topKante.getIDTOPKnotenA();
    }

    public static TOP_Knoten getTOPKnotenB(TOP_Kante topKante) {
        return topKante.getIDTOPKnotenB();
    }

    public static List<GEO_Kante> getGeoKanten(final TOP_Kante topKante) {
        Functions.Function1<GEO_Kante, Boolean> _function = new Functions.Function1<GEO_Kante, Boolean>(){

            public Boolean apply(GEO_Kante k) {
                TOP_Kante _pKante = GeoKanteExtensions.topKante(k);
                return Objects.equal((Object)_pKante, (Object)topKante);
            }
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)topKante).getGEOKante(), (Functions.Function1)_function));
    }

    public static List<DirectedElement<GEO_Kante>> getGeoKanten(DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> directedTopEdge) {
        GEO_Knoten start;
        TOP_Knoten _tail = null;
        if (directedTopEdge != null) {
            _tail = (TOP_Knoten)directedTopEdge.getTail();
        }
        GEO_Knoten _gEOKnoten = null;
        if (_tail != null) {
            _gEOKnoten = TopKnotenExtensions.getGEOKnoten(_tail);
        }
        if ((start = _gEOKnoten) == null) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        return TopKanteExtensions.getGeoKanten(directedTopEdge, start, result);
    }

    public static SymbolArrangement<Coordinate> getCoordinate(TOP_Kante topKante, double abstand, double seitlicherAbstand, ENUMWirkrichtung wirkrichtung) {
        TOP_Knoten topKnotenA = TopKanteExtensions.getTOPKnotenA(topKante);
        return TopKanteExtensions.getCoordinate(topKante, topKnotenA, abstand, seitlicherAbstand, wirkrichtung);
    }

    public static SymbolArrangement<Coordinate> getCoordinate(TOP_Kante topKante, TOP_Knoten topStart, double abstand, double seitlicherAbstand, ENUMWirkrichtung wirkrichtung) {
        GEO_Knoten start = TopKnotenExtensions.getGEOKnoten(topStart);
        List<GEO_Kante> geoKantenOnTopKante = TopKanteExtensions.getGeoKanten(topKante);
        Functions.Function2<Double, GEO_Kante, Double> _function = new Functions.Function2<Double, GEO_Kante, Double>(){

            public Double apply(Double l, GEO_Kante k) {
                double _doubleValue = k.getGEOKanteAllg().getGEOLaenge().getWert().doubleValue();
                return l + _doubleValue;
            }
        };
        Double lengthGeoKanten = (Double)IterableExtensions.fold(geoKantenOnTopKante, (Object)0.0, (Functions.Function2)_function);
        double lengthTopKante = topKante.getTOPKanteAllg().getTOPLaenge().getWert().doubleValue();
        double difference = Math.abs(lengthGeoKanten - lengthTopKante);
        if (difference > 0.002) {
            logger.debug("lengthTopKante={}", (Object)lengthTopKante);
            logger.debug("lengthGeoKanten={}", (Object)lengthGeoKanten);
            logger.debug("geoKantenOnTopKante={}", (Object)geoKantenOnTopKante.size());
            logger.warn("Difference of GEO Kanten length and TOP Kante length for TOP Kante {} greater than tolerance {} ({}).", new Object[]{topKante.getIdentitaet().getWert(), 0.002, difference});
        }
        double relativeAbstand = abstand * lengthGeoKanten / lengthTopKante;
        return GeoKnotenExtensions.getCoordinate(start, null, (Basis_Objekt)topKante, relativeAbstand, seitlicherAbstand, wirkrichtung);
    }

    public static boolean isConnectedTo(TOP_Kante topKante, TOP_Kante otherTopKante) {
        try {
            TOP_Knoten _connectionTo = TopKanteExtensions.connectionTo(topKante, otherTopKante);
            return _connectionTo != null;
        }
        catch (Throwable _t) {
            if (_t instanceof IllegalArgumentException) {
                return false;
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    public static boolean isConnectedTo(final TOP_Kante topKante, final Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint) {
        boolean _not;
        Functions.Function1<TOP_Kante, Boolean> _function;
        TOP_Kante _topKante = PunktObjektTopKanteExtensions.getTopKante(singlePoint);
        boolean _equals = Objects.equal((Object)_topKante, (Object)topKante);
        if (_equals) {
            return true;
        }
        List<TOP_Kante> adjacentTopKanten = TopKanteExtensions.getAdjacentTopKanten(topKante);
        List qualifiedAdjacentTopKanten = IterableExtensions.toList((Iterable)IterableExtensions.filter(adjacentTopKanten, (Functions.Function1)(_function = new Functions.Function1<TOP_Kante, Boolean>(){

            public Boolean apply(TOP_Kante t) {
                return TopKanteExtensions.isOnProperEndOf(singlePoint, t, topKante);
            }
        })));
        boolean _isEmpty = qualifiedAdjacentTopKanten.isEmpty();
        boolean bl = _not = !_isEmpty;
        return _not;
    }

    public static TOP_Knoten connectionTo(TOP_Kante topKante, TOP_Kante otherTopKante) {
        Functions.Function1<TOP_Knoten, Boolean> _function;
        Object _xblockexpression = null;
        TOP_Knoten _tOPKnotenA = TopKanteExtensions.getTOPKnotenA(topKante);
        TOP_Knoten _tOPKnotenB = TopKanteExtensions.getTOPKnotenB(topKante);
        final List thisKnoten = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TOP_Knoten[]{_tOPKnotenA, _tOPKnotenB}));
        TOP_Knoten _tOPKnotenA_1 = TopKanteExtensions.getTOPKnotenA(otherTopKante);
        TOP_Knoten _tOPKnotenB_1 = TopKanteExtensions.getTOPKnotenB(otherTopKante);
        List otherKnoten = Collections.unmodifiableList(CollectionLiterals.newArrayList((Object[])new TOP_Knoten[]{_tOPKnotenA_1, _tOPKnotenB_1}));
        Iterable commonKnoten = IterableExtensions.filter(otherKnoten, (Functions.Function1)(_function = new Functions.Function1<TOP_Knoten, Boolean>(){

            public Boolean apply(TOP_Knoten k) {
                return thisKnoten.contains(k);
            }
        }));
        int size = IterableExtensions.size((Iterable)commonKnoten);
        if (size == 0) {
            return null;
        }
        if (size == 1) {
            return ((TOP_Knoten[])Conversions.unwrapArray((Object)commonKnoten, TOP_Knoten.class))[0];
        }
        Object _xifexpression = null;
        if (size > 1) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Ambiguous connection for ");
            String _wert = topKante.getIdentitaet().getWert();
            _builder.append(_wert);
            _builder.append(" and ");
            String _wert_1 = otherTopKante.getIdentitaet().getWert();
            _builder.append(_wert_1);
            throw new IllegalArgumentException(_builder.toString());
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public static Gleis_Lichtraum getGleisLichtraum(final TOP_Kante topKante) {
        boolean _tripleNotEquals;
        Functions.Function1<Gleis_Lichtraum, Boolean> _function = new Functions.Function1<Gleis_Lichtraum, Boolean>(){

            public Boolean apply(Gleis_Lichtraum l) {
                Functions.Function1<Bereich_Objekt_Teilbereich_AttributeGroup, TOP_Kante> _function = new Functions.Function1<Bereich_Objekt_Teilbereich_AttributeGroup, TOP_Kante>(){

                    public TOP_Kante apply(Bereich_Objekt_Teilbereich_AttributeGroup it) {
                        return BereichObjektExtensions.getTopKante(it);
                    }
                };
                return ListExtensions.map((List)l.getBereichObjektTeilbereich(), (Functions.Function1)_function).contains(topKante);
            }
        };
        Iterable lichtraeume = IterableExtensions.filter((Iterable)BasisAttributExtensions.getContainer((EObject)topKante).getGleisLichtraum(), (Functions.Function1)_function);
        boolean _isEmpty = IterableExtensions.isEmpty((Iterable)lichtraeume);
        if (_isEmpty) {
            return null;
        }
        int _size = IterableExtensions.size((Iterable)lichtraeume);
        boolean bl = _tripleNotEquals = _size != 1;
        if (_tripleNotEquals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Unexpected number of Gleis Lichtr\u00e4ume for Top-Kante: topKante=");
            String _wert = topKante.getIdentitaet().getWert();
            _builder.append(_wert);
            _builder.append(" size=");
            int _size_1 = IterableExtensions.size((Iterable)lichtraeume);
            _builder.append((Object)_size_1);
            throw new IllegalArgumentException(_builder.toString());
        }
        return ((Gleis_Lichtraum[])Conversions.unwrapArray((Object)lichtraeume, Gleis_Lichtraum.class))[0];
    }

    public static List<TOP_Kante> getAdjacentTopKanten(final TOP_Kante topKante, final Iterable<TOP_Kante> topKanten) {
        TopKanteExtensions.createCache();
        MissingSupplier<List<TOP_Kante>> _function = new MissingSupplier<List<TOP_Kante>>(){

            public List<TOP_Kante> get() {
                return TopKanteExtensions.calcAdjacentTopKanten(topKante, topKanten);
            }
        };
        return (List)cache.get(TopKanteExtensions.getCacheKey(topKante), (MissingSupplier)_function);
    }

    public static void createCache() {
        if (cache == null) {
            cache = Services.getCacheService().getCache("toolbox.cache.topkante-to-adjacent-topkanten");
        }
    }

    public static String getCacheKey(TOP_Kante edge) {
        StringConcatenation _builder = new StringConcatenation();
        String _cacheString = BasisAttributExtensions.getContainer((EObject)edge).getCacheString();
        _builder.append(_cacheString);
        _builder.append("/");
        String _wert = edge.getIdentitaet().getWert();
        _builder.append(_wert);
        return _builder.toString();
    }

    private static List<TOP_Kante> calcAdjacentTopKanten(final TOP_Kante topKante, Iterable<TOP_Kante> topKanten) {
        Functions.Function1<TOP_Kante, Boolean> _function = new Functions.Function1<TOP_Kante, Boolean>(){

            public Boolean apply(TOP_Kante t) {
                return !Objects.equal((Object)t, (Object)topKante) && TopKanteExtensions.isConnectedTo(t, topKante);
            }
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter(topKanten, (Functions.Function1)_function));
    }

    public static List<TOP_Kante> getAdjacentTopKanten(TOP_Kante topKante) {
        return TopKanteExtensions.getAdjacentTopKanten(topKante, BasisAttributExtensions.getContainer((EObject)topKante).getTOPKante());
    }

    public static List<Punkt_Objekt_TOP_Kante_AttributeGroup> getConnected(TOP_Kante topKante) {
        CacheService cacheService = Services.getCacheService();
        Cache cache = cacheService.getCache("toolbox.cache.topkante-to-singlepoints", BasisAttributExtensions.getContainer((EObject)topKante).getCacheString());
        String _wert = topKante.getIdentitaet().getWert();
        PunktObjektTopKanteLoader _punktObjektTopKanteLoader = new PunktObjektTopKanteLoader(topKante);
        Object _get = cache.get(_wert, (MissingSupplier)_punktObjektTopKanteLoader);
        return (List)_get;
    }

    private static List<Punkt_Objekt_TOP_Kante_AttributeGroup> findPunktObjektTopKanten(final TOP_Kante topKante) {
        Functions.Function1<Punkt_Objekt, List<Punkt_Objekt_TOP_Kante_AttributeGroup>> _function = new Functions.Function1<Punkt_Objekt, List<Punkt_Objekt_TOP_Kante_AttributeGroup>>(){

            public List<Punkt_Objekt_TOP_Kante_AttributeGroup> apply(Punkt_Objekt it) {
                return PunktObjektExtensions.getSinglePoints(it);
            }
        };
        Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Boolean> _function_1 = new Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Boolean>(){

            public Boolean apply(Punkt_Objekt_TOP_Kante_AttributeGroup it) {
                return TopKanteExtensions.isConnectedTo(topKante, it);
            }
        };
        return IterableExtensions.toList((Iterable)IterableExtensions.filter((Iterable)Iterables.concat((Iterable)IterableExtensions.map(ContainerExtensions.getPunktObjekte(BasisAttributExtensions.getContainer((EObject)topKante)), (Functions.Function1)_function)), (Functions.Function1)_function_1));
    }

    public static double getAbstand(TOP_Kante topKante, Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint) {
        boolean _not;
        TOP_Kante _topKante = PunktObjektTopKanteExtensions.getTopKante(singlePoint);
        boolean _equals = Objects.equal((Object)_topKante, (Object)topKante);
        if (_equals) {
            return singlePoint.getAbstand().getWert().doubleValue();
        }
        Set<TOP_Knoten> topKnotenSet = SetExtensions.intersection(PunktObjektTopKanteExtensions.getTopKnoten(singlePoint), TopKanteExtensions.getTOPKnoten(topKante));
        boolean _isEmpty = topKnotenSet.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            int _size = topKnotenSet.size();
            boolean _equals_1 = _size == 1;
            Assert.isTrue((boolean)_equals_1);
            TOP_Knoten topKnoten = (TOP_Knoten)IterableExtensions.head(topKnotenSet);
            return TopKanteExtensions.getAbstand(topKante, topKnoten);
        }
        String _identitaet = PunktObjektTopKanteExtensions.getIdentitaet(singlePoint);
        throw new IllegalArgumentException(_identitaet);
    }

    public static double getAbstand(TOP_Kante topKante, TOP_Knoten topKnoten) {
        TOP_Knoten _tOPKnotenA = TopKanteExtensions.getTOPKnotenA(topKante);
        boolean _equals = Objects.equal((Object)_tOPKnotenA, (Object)topKnoten);
        if (_equals) {
            return 0.0;
        }
        TOP_Knoten _tOPKnotenB = TopKanteExtensions.getTOPKnotenB(topKante);
        boolean _equals_1 = Objects.equal((Object)_tOPKnotenB, (Object)topKnoten);
        if (_equals_1) {
            return topKante.getTOPKanteAllg().getTOPLaenge().getWert().doubleValue();
        }
        String _wert = topKnoten.getIdentitaet().getWert();
        throw new IllegalArgumentException(_wert);
    }

    public static double getAbstand(TOP_Kante topKante, Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint1, Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint2) {
        double d1 = TopKanteExtensions.getAbstand(topKante, singlePoint1);
        double d2 = TopKanteExtensions.getAbstand(topKante, singlePoint2);
        double _max = Math.max(d1, d2);
        double _min = Math.min(d1, d2);
        return _max - _min;
    }

    public static double getAbstand(final TOP_Kante topKante, Punkt_Objekt punktObjekt1, Punkt_Objekt punktObjekt2) {
        Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Boolean> _function = new Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Boolean>(){

            public Boolean apply(Punkt_Objekt_TOP_Kante_AttributeGroup it) {
                return TopKanteExtensions.isConnectedTo(topKante, it);
            }
        };
        Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Boolean> _function_1 = new Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Boolean>(){

            public Boolean apply(Punkt_Objekt_TOP_Kante_AttributeGroup it) {
                return TopKanteExtensions.isConnectedTo(topKante, it);
            }
        };
        return TopKanteExtensions.getAbstand(topKante, (Punkt_Objekt_TOP_Kante_AttributeGroup)CollectionExtensions.getUnique(IterableExtensions.toSet((Iterable)IterableExtensions.filter(PunktObjektExtensions.getSinglePoints(punktObjekt1), (Functions.Function1)_function))), (Punkt_Objekt_TOP_Kante_AttributeGroup)CollectionExtensions.getUnique(IterableExtensions.toSet((Iterable)IterableExtensions.filter(PunktObjektExtensions.getSinglePoints(punktObjekt2), (Functions.Function1)_function_1))));
    }

    public static double getAbstand(TOP_Kante topKante, TOP_Knoten topKnoten, Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint) {
        TOP_Knoten _tOPKnotenA = TopKanteExtensions.getTOPKnotenA(topKante);
        boolean _equals = Objects.equal((Object)topKnoten, (Object)_tOPKnotenA);
        if (_equals) {
            return TopKanteExtensions.getAbstand(topKante, singlePoint);
        }
        TOP_Knoten _tOPKnotenB = TopKanteExtensions.getTOPKnotenB(topKante);
        boolean _equals_1 = Objects.equal((Object)topKnoten, (Object)_tOPKnotenB);
        if (_equals_1) {
            double _laenge = TopKanteExtensions.getLaenge(topKante);
            double _abstand = TopKanteExtensions.getAbstand(topKante, singlePoint);
            return _laenge - _abstand;
        }
        String _string = topKnoten.toString();
        throw new IllegalArgumentException(_string);
    }

    protected static double _getAbstandDispatch(TOP_Kante topKante, Basis_Objekt basisObjekt1, Basis_Objekt basisObjekt2) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Unexpected Argumenttypes ");
        String _simpleName = basisObjekt1.getClass().getSimpleName();
        _builder.append(_simpleName);
        _builder.append(", ");
        String _simpleName_1 = basisObjekt2.getClass().getSimpleName();
        _builder.append(_simpleName_1);
        throw new IllegalArgumentException(_builder.toString());
    }

    protected static double _getAbstandDispatch(TOP_Kante topKante, Punkt_Objekt punktObject1, Punkt_Objekt punktObjekt2) {
        return TopKanteExtensions.getAbstand(topKante, punktObject1, punktObjekt2);
    }

    protected static double _getAbstandDispatch(final TOP_Kante topKante, TOP_Knoten topKnoten, Punkt_Objekt punktObjekt) {
        Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Boolean> _function = new Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Boolean>(){

            public Boolean apply(Punkt_Objekt_TOP_Kante_AttributeGroup it) {
                return TopKanteExtensions.isConnectedTo(topKante, it);
            }
        };
        return TopKanteExtensions.getAbstand(topKante, topKnoten, (Punkt_Objekt_TOP_Kante_AttributeGroup)CollectionExtensions.getUnique(IterableExtensions.toList((Iterable)IterableExtensions.filter(PunktObjektExtensions.getSinglePoints(punktObjekt), (Functions.Function1)_function))));
    }

    protected static double _getAbstandDispatch(final TOP_Kante topKante, Punkt_Objekt punktObjekt, TOP_Knoten topKnoten) {
        Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Boolean> _function = new Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Boolean>(){

            public Boolean apply(Punkt_Objekt_TOP_Kante_AttributeGroup it) {
                return TopKanteExtensions.isConnectedTo(topKante, it);
            }
        };
        return TopKanteExtensions.getAbstand(topKante, topKnoten, (Punkt_Objekt_TOP_Kante_AttributeGroup)CollectionExtensions.getUnique(IterableExtensions.toList((Iterable)IterableExtensions.filter(PunktObjektExtensions.getSinglePoints(punktObjekt), (Functions.Function1)_function))));
    }

    public static double getLaenge(TOP_Kante topKante) {
        return topKante.getTOPKanteAllg().getTOPLaenge().getWert().doubleValue();
    }

    public static boolean intersect(TOP_Kante topKante, Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint) {
        boolean _isEmpty = TopKanteExtensions.intersection(topKante, PunktObjektTopKanteExtensions.getSinglePoints(singlePoint)).isEmpty();
        return !_isEmpty;
    }

    public static Set<Punkt_Objekt_TOP_Kante_AttributeGroup> intersection(final TOP_Kante topKante, Collection<Punkt_Objekt_TOP_Kante_AttributeGroup> singlePoints) {
        Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Boolean> _function = new Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Boolean>(){

            public Boolean apply(Punkt_Objekt_TOP_Kante_AttributeGroup it) {
                Identitaet_TypeClass _identitaet = it.getIDTOPKante().getIdentitaet();
                String _wert = null;
                if (_identitaet != null) {
                    _wert = _identitaet.getWert();
                }
                String _wert_1 = topKante.getIdentitaet().getWert();
                return Objects.equal((Object)_wert, (Object)_wert_1);
            }
        };
        return IterableExtensions.toSet((Iterable)IterableExtensions.filter(singlePoints, (Functions.Function1)_function));
    }

    public static ENUMTOPAnschluss getTOPAnschluss(TOP_Kante topKante, TOP_Knoten topKnoten) {
        boolean _equals_1;
        boolean _equals;
        TOP_Knoten idA = topKante.getIDTOPKnotenA();
        TOP_Knoten idB = topKante.getIDTOPKnotenB();
        String _wert = topKnoten.getIdentitaet().getWert();
        Identitaet_TypeClass _identitaet = idA.getIdentitaet();
        String _wert_1 = null;
        if (_identitaet != null) {
            _wert_1 = _identitaet.getWert();
        }
        if (_equals = Objects.equal((Object)_wert, (Object)_wert_1)) {
            return topKante.getTOPKanteAllg().getTOPAnschlussA().getWert();
        }
        String _wert_2 = topKnoten.getIdentitaet().getWert();
        Identitaet_TypeClass _identitaet_1 = idB.getIdentitaet();
        String _wert_3 = null;
        if (_identitaet_1 != null) {
            _wert_3 = _identitaet_1.getWert();
        }
        if (_equals_1 = Objects.equal((Object)_wert_2, (Object)_wert_3)) {
            return topKante.getTOPKanteAllg().getTOPAnschlussB().getWert();
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("topKnoten=");
        String _wert_4 = topKnoten.getIdentitaet().getWert();
        _builder.append(_wert_4);
        throw new IllegalArgumentException(_builder.toString());
    }

    public static TOP_Knoten opposite(TOP_Kante topKante, TOP_Knoten topKnoten) {
        boolean _equals_1;
        boolean _equals;
        TOP_Knoten idA = topKante.getIDTOPKnotenA();
        TOP_Knoten idB = topKante.getIDTOPKnotenB();
        String _wert = topKnoten.getIdentitaet().getWert();
        Identitaet_TypeClass _identitaet = idA.getIdentitaet();
        String _wert_1 = null;
        if (_identitaet != null) {
            _wert_1 = _identitaet.getWert();
        }
        if (_equals = Objects.equal((Object)_wert, (Object)_wert_1)) {
            return TopKanteExtensions.getTOPKnotenB(topKante);
        }
        String _wert_2 = topKnoten.getIdentitaet().getWert();
        Identitaet_TypeClass _identitaet_1 = idB.getIdentitaet();
        String _wert_3 = null;
        if (_identitaet_1 != null) {
            _wert_3 = _identitaet_1.getWert();
        }
        if (_equals_1 = Objects.equal((Object)_wert_2, (Object)_wert_3)) {
            return TopKanteExtensions.getTOPKnotenA(topKante);
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("topKnoten=");
        String _wert_4 = topKnoten.getIdentitaet().getWert();
        _builder.append(_wert_4);
        throw new IllegalArgumentException(_builder.toString());
    }

    public static boolean isRoute(TOP_Kante topKante, TOP_Kante destination, TOP_Knoten transition) {
        ENUMTOPAnschluss anschlussOrigin = TopKanteExtensions.getTOPAnschluss(topKante, transition);
        ENUMTOPAnschluss anschlussDestination = TopKanteExtensions.getTOPAnschluss(destination, transition);
        boolean _isPoint = TopKanteExtensions.isPoint(anschlussOrigin);
        if (_isPoint) {
            return TopKanteExtensions.isBranch(anschlussDestination);
        }
        boolean _isBranch = TopKanteExtensions.isBranch(anschlussOrigin);
        if (_isBranch) {
            return TopKanteExtensions.isPoint(anschlussDestination);
        }
        return false;
    }

    public static List<TOP_Knoten> getTOPKnoten(TOP_Kante topKante) {
        LinkedList<TOP_Knoten> result = new LinkedList<TOP_Knoten>();
        result.add(TopKanteExtensions.getTOPKnotenA(topKante));
        result.add(TopKanteExtensions.getTOPKnotenB(topKante));
        return result;
    }

    public static List<W_Kr_Gsp_Element> getWKrGspElemente(TOP_Kante topKante) {
        LinkedList result = Lists.newLinkedList();
        result.add(TopKnotenExtensions.getWKrGspElement(TopKanteExtensions.getTOPKnotenA(topKante)));
        result.add(TopKnotenExtensions.getWKrGspElement(TopKanteExtensions.getTOPKnotenB(topKante)));
        return result;
    }

    private static boolean isPoint(ENUMTOPAnschluss anschluss) {
        return Objects.equal((Object)anschluss, (Object)ENUMTOPAnschluss.ENUMTOP_ANSCHLUSS_SPITZE);
    }

    private static boolean isBranch(ENUMTOPAnschluss anschluss) {
        return Objects.equal((Object)anschluss, (Object)ENUMTOPAnschluss.ENUMTOP_ANSCHLUSS_LINKS) || Objects.equal((Object)anschluss, (Object)ENUMTOPAnschluss.ENUMTOP_ANSCHLUSS_RECHTS);
    }

    private static boolean isOnProperEndOf(Punkt_Objekt_TOP_Kante_AttributeGroup p, TOP_Kante adjacentTopKante, TOP_Kante originTopKante) {
        boolean _notEquals;
        TOP_Kante _topKante = PunktObjektTopKanteExtensions.getTopKante(p);
        boolean bl = _notEquals = !Objects.equal((Object)_topKante, (Object)adjacentTopKante);
        if (_notEquals) {
            return false;
        }
        double abstand = p.getAbstand().getWert().doubleValue();
        TOP_Knoten A = TopKanteExtensions.getTOPKnotenA(adjacentTopKante);
        TOP_Knoten B = TopKanteExtensions.getTOPKnotenB(adjacentTopKante);
        TOP_Knoten C = TopKanteExtensions.connectionTo(adjacentTopKante, originTopKante);
        boolean _equals = Objects.equal((Object)A, (Object)C);
        if (_equals) {
            return TopKanteExtensions.isApproxEqual(abstand, 0.0);
        }
        boolean _equals_1 = Objects.equal((Object)B, (Object)C);
        if (_equals_1) {
            return TopKanteExtensions.isApproxEqual(abstand, TopKanteExtensions.getLaenge(adjacentTopKante));
        }
        return false;
    }

    private static boolean isApproxEqual(double a, double b) {
        int _compare = Distance.compare(a, b);
        return _compare == 0;
    }

    private static List<DirectedElement<GEO_Kante>> getGeoKanten(DirectedEdge<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> directedTopEdge, GEO_Knoten start, List<DirectedElement<GEO_Kante>> result) {
        boolean _tripleEquals;
        TOP_Knoten _head = null;
        if (directedTopEdge != null) {
            _head = (TOP_Knoten)directedTopEdge.getHead();
        }
        GEO_Knoten _gEOKnoten = null;
        if (_head != null) {
            _gEOKnoten = TopKnotenExtensions.getGEOKnoten(_head);
        }
        boolean bl = _tripleEquals = start == _gEOKnoten;
        if (_tripleEquals) {
            return result;
        }
        List<GEO_Kante> startEdges = GeoKnotenExtensions.getGeoKantenOnTopKante(start, (TOP_Kante)directedTopEdge.getElement());
        Functions.Function1<DirectedElement<GEO_Kante>, GEO_Kante> _function = new Functions.Function1<DirectedElement<GEO_Kante>, GEO_Kante>(){

            public GEO_Kante apply(DirectedElement<GEO_Kante> it) {
                return (GEO_Kante)it.getElement();
            }
        };
        startEdges.removeAll(ListExtensions.map(result, (Functions.Function1)_function));
        boolean _isEmpty = startEdges.isEmpty();
        if (_isEmpty) {
            return result;
        }
        int _size = startEdges.size();
        boolean _equals = _size == 1;
        Assert.isTrue((boolean)_equals);
        GEO_Kante startEdge = startEdges.get(0);
        GEO_Knoten _geoKnotenA = GeoKanteExtensions.getGeoKnotenA(startEdge);
        boolean _tripleEquals_1 = _geoKnotenA == start;
        DirectedElementImpl directedStartEdge = new DirectedElementImpl((Object)startEdge, _tripleEquals_1);
        result.add((DirectedElement<GEO_Kante>)directedStartEdge);
        return TopKanteExtensions.getGeoKanten(directedTopEdge, GeoKanteExtensions.getOpposite(startEdge, start), result);
    }

    public static Iterable<Pair<GEO_Kante, Double>> getGeoKantenWithDistance(TOP_Kante topKante) {
        TOP_Knoten topKnotenA = TopKanteExtensions.getTOPKnotenA(topKante);
        GEO_Knoten start = TopKnotenExtensions.getGEOKnoten(topKnotenA);
        return GeoKnotenExtensions.getGeoKantenWithDistance(start, topKante);
    }

    public static double getAbstandDispatch(TOP_Kante topKante, Basis_Objekt punktObject1, Basis_Objekt punktObjekt2) {
        if (punktObject1 instanceof Punkt_Objekt && punktObjekt2 instanceof Punkt_Objekt) {
            return TopKanteExtensions._getAbstandDispatch(topKante, (Punkt_Objekt)punktObject1, (Punkt_Objekt)punktObjekt2);
        }
        if (punktObject1 instanceof Punkt_Objekt && punktObjekt2 instanceof TOP_Knoten) {
            return TopKanteExtensions._getAbstandDispatch(topKante, (Punkt_Objekt)punktObject1, (TOP_Knoten)punktObjekt2);
        }
        if (punktObject1 instanceof TOP_Knoten && punktObjekt2 instanceof Punkt_Objekt) {
            return TopKanteExtensions._getAbstandDispatch(topKante, (TOP_Knoten)punktObject1, (Punkt_Objekt)punktObjekt2);
        }
        if (punktObject1 != null && punktObjekt2 != null) {
            return TopKanteExtensions._getAbstandDispatch(topKante, punktObject1, punktObjekt2);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(topKante, punktObject1, punktObjekt2).toString());
    }

    private static class PunktObjektTopKanteLoader
    implements MissingSupplier<Object> {
        private final TOP_Kante topKante;

        public PunktObjektTopKanteLoader(TOP_Kante topKante) {
            this.topKante = topKante;
        }

        public Object get() {
            return TopKanteExtensions.findPunktObjektTopKanten(this.topKante);
        }
    }
}

