/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.ppmodel.extensions.BasisObjektExtensions;
import org.eclipse.set.ppmodel.extensions.TopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.utils.Distance;
import org.eclipse.set.ppmodel.extensions.utils.SymbolArrangement;
import org.eclipse.set.toolboxmodel.BasisTypen.ENUMWirkrichtung;
import org.eclipse.set.toolboxmodel.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.toolboxmodel.Basisobjekte.Seitlicher_Abstand_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Ur_Objekt;
import org.eclipse.set.toolboxmodel.Basisobjekte.Wirkrichtung_TypeClass;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Knoten;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.locationtech.jts.geom.Coordinate;

public class PunktObjektTopKanteExtensions
extends BasisObjektExtensions {
    public static String getIdentitaet(Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint) {
        EObject _eContainer = singlePoint.eContainer();
        Ur_Objekt container = (Ur_Objekt)_eContainer;
        Identitaet_TypeClass _identitaet = null;
        if (container != null) {
            _identitaet = container.getIdentitaet();
        }
        String _wert = null;
        if (_identitaet != null) {
            _wert = _identitaet.getWert();
        }
        String containerId = _wert;
        List containedPots = IterableExtensions.toList((Iterable)Iterables.filter((Iterable)container.eContents(), Punkt_Objekt_TOP_Kante_AttributeGroup.class));
        int index = containedPots.indexOf(singlePoint);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append(containerId);
        _builder.append("/");
        _builder.append((Object)index);
        return _builder.toString();
    }

    public static TOP_Kante getTopKante(Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint) {
        return singlePoint.getIDTOPKante();
    }

    public static SymbolArrangement<Coordinate> getCoordinate(Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint, ENUMWirkrichtung direction) {
        TOP_Kante topKante = PunktObjektTopKanteExtensions.getTopKante(singlePoint);
        double abstand = singlePoint.getAbstand().getWert().doubleValue();
        BigDecimal _elvis = null;
        Seitlicher_Abstand_TypeClass _seitlicherAbstand = null;
        if (singlePoint != null) {
            _seitlicherAbstand = singlePoint.getSeitlicherAbstand();
        }
        BigDecimal _wert = null;
        if (_seitlicherAbstand != null) {
            _wert = _seitlicherAbstand.getWert();
        }
        _elvis = _wert != null ? _wert : BigDecimal.ZERO;
        double lateralDistance = _elvis.doubleValue();
        return TopKanteExtensions.getCoordinate(topKante, abstand, lateralDistance, direction);
    }

    public static SymbolArrangement<Coordinate> getCoordinate(Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint) {
        Wirkrichtung_TypeClass _wirkrichtung = singlePoint.getWirkrichtung();
        ENUMWirkrichtung _wert = null;
        if (_wirkrichtung != null) {
            _wert = _wirkrichtung.getWert();
        }
        ENUMWirkrichtung direction = _wert;
        return PunktObjektTopKanteExtensions.getCoordinate(singlePoint, direction);
    }

    public static Set<TOP_Knoten> getTopKnoten(Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint) {
        int _compare_1;
        boolean _equals_1;
        boolean _equals;
        HashSet<TOP_Knoten> result = new HashSet<TOP_Knoten>();
        TOP_Kante topKante = PunktObjektTopKanteExtensions.getTopKante(singlePoint);
        if (topKante == null) {
            return result;
        }
        double abstand = TopKanteExtensions.getAbstand(topKante, singlePoint);
        double length = topKante.getTOPKanteAllg().getTOPLaenge().getWert().doubleValue();
        int _compare = Distance.compare(abstand, 0.0);
        boolean bl = _equals = _compare == 0;
        if (_equals) {
            result.add(TopKanteExtensions.getTOPKnotenA(topKante));
        }
        boolean bl2 = _equals_1 = (_compare_1 = Distance.compare(abstand, length)) == 0;
        if (_equals_1) {
            result.add(TopKanteExtensions.getTOPKnotenB(topKante));
        }
        return result;
    }

    public static Punkt_Objekt getPunktObjekt(Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint) {
        EObject _eContainer = singlePoint.eContainer();
        return (Punkt_Objekt)_eContainer;
    }

    public static List<Punkt_Objekt_TOP_Kante_AttributeGroup> getSinglePoints(Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint) {
        return Lists.newArrayList((Object[])new Punkt_Objekt_TOP_Kante_AttributeGroup[]{singlePoint});
    }

    public static Pair<SymbolArrangement<Coordinate>, SymbolArrangement<Coordinate>> getPerpendicularLineAtPoint(Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint) {
        TOP_Kante topKante = PunktObjektTopKanteExtensions.getTopKante(singlePoint);
        double abstand = singlePoint.getAbstand().getWert().doubleValue();
        Wirkrichtung_TypeClass _wirkrichtung = singlePoint.getWirkrichtung();
        ENUMWirkrichtung _wert = null;
        if (_wirkrichtung != null) {
            _wert = _wirkrichtung.getWert();
        }
        ENUMWirkrichtung wirkrichtung = _wert;
        SymbolArrangement<Coordinate> firstCoordinate = TopKanteExtensions.getCoordinate(topKante, abstand, -1.0, wirkrichtung);
        SymbolArrangement<Coordinate> secondCoordinate = TopKanteExtensions.getCoordinate(topKante, abstand, 1.0, wirkrichtung);
        return Pair.of(firstCoordinate, secondCoordinate);
    }
}

