/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Set;
import org.eclipse.set.basis.graph.DirectedEdge;
import org.eclipse.set.ppmodel.extensions.BasisObjektExtensions;
import org.eclipse.set.ppmodel.extensions.ENUMWirkrichtungExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektTopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.SignalExtensions;
import org.eclipse.set.ppmodel.extensions.utils.CollectionExtensions;
import org.eclipse.set.toolboxmodel.BasisTypen.ENUMWirkrichtung;
import org.eclipse.set.toolboxmodel.Basisobjekte.Identitaet_TypeClass;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.toolboxmodel.Basisobjekte.Wirkrichtung_TypeClass;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Knoten;
import org.eclipse.set.toolboxmodel.Ortung.FMA_Komponente;
import org.eclipse.set.toolboxmodel.Ortung.FMA_Komponente_Achszaehlpunkt_AttributeGroup;
import org.eclipse.set.toolboxmodel.Signalbegriffe_Ril_301.Ra12;
import org.eclipse.set.toolboxmodel.Signale.Signal;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.locationtech.jts.geom.Coordinate;

public class PunktObjektExtensions
extends BasisObjektExtensions {
    public static List<TOP_Kante> getTopKanten(Punkt_Objekt punktObjekt) {
        Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, TOP_Kante> _function = new Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, TOP_Kante>(){

            public TOP_Kante apply(Punkt_Objekt_TOP_Kante_AttributeGroup it) {
                return PunktObjektTopKanteExtensions.getTopKante(it);
            }
        };
        return ListExtensions.map(PunktObjektExtensions.getSinglePoints(punktObjekt), (Functions.Function1)_function);
    }

    public static boolean isAchszaehlpunkt(Punkt_Objekt punktObjekt) {
        if (punktObjekt instanceof FMA_Komponente) {
            FMA_Komponente_Achszaehlpunkt_AttributeGroup _fMAKomponenteAchszaehlpunkt = ((FMA_Komponente)punktObjekt).getFMAKomponenteAchszaehlpunkt();
            return _fMAKomponenteAchszaehlpunkt != null;
        }
        return false;
    }

    public static TOP_Knoten getTopKnoten(Punkt_Objekt punktObjekt) {
        Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Set<TOP_Knoten>> _function = new Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Set<TOP_Knoten>>(){

            public Set<TOP_Knoten> apply(Punkt_Objekt_TOP_Kante_AttributeGroup it) {
                return PunktObjektTopKanteExtensions.getTopKnoten(it);
            }
        };
        return (TOP_Knoten)CollectionExtensions.getUniqueOrNull(IterableExtensions.toSet((Iterable)Iterables.concat((Iterable)ListExtensions.map(PunktObjektExtensions.getSinglePoints(punktObjekt), (Functions.Function1)_function))));
    }

    public static ENUMWirkrichtung getWirkrichtung(Punkt_Objekt punktObjekt, final TOP_Kante topKante) {
        boolean _equals;
        Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Boolean> _function = new Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, Boolean>(){

            public Boolean apply(Punkt_Objekt_TOP_Kante_AttributeGroup it) {
                Identitaet_TypeClass _identitaet = it.getIDTOPKante().getIdentitaet();
                String _wert = null;
                if (_identitaet != null) {
                    _wert = _identitaet.getWert();
                }
                String _wert_1 = topKante.getIdentitaet().getWert();
                return Objects.equal((Object)_wert, (Object)_wert_1);
            }
        };
        Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, ENUMWirkrichtung> _function_1 = new Functions.Function1<Punkt_Objekt_TOP_Kante_AttributeGroup, ENUMWirkrichtung>(){

            public ENUMWirkrichtung apply(Punkt_Objekt_TOP_Kante_AttributeGroup it) {
                Wirkrichtung_TypeClass _wirkrichtung = it.getWirkrichtung();
                ENUMWirkrichtung _wert = null;
                if (_wirkrichtung != null) {
                    _wert = _wirkrichtung.getWert();
                }
                return _wert;
            }
        };
        Set wirkrichtungen = IterableExtensions.toSet((Iterable)IterableExtensions.map((Iterable)IterableExtensions.filter(PunktObjektExtensions.getSinglePoints(punktObjekt), (Functions.Function1)_function), (Functions.Function1)_function_1));
        int _size = wirkrichtungen.size();
        boolean bl = _equals = _size == 0;
        if (_equals) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("Punkt Objekt ");
            String _wert = punktObjekt.getIdentitaet().getWert();
            _builder.append(_wert);
            _builder.append(" not located on TOP-Kante ");
            String _wert_1 = topKante.getIdentitaet().getWert();
            _builder.append(_wert_1);
            throw new IllegalArgumentException(_builder.toString());
        }
        return ((ENUMWirkrichtung[])Conversions.unwrapArray((Object)wirkrichtungen, ENUMWirkrichtung.class))[0];
    }

    public static boolean isInWirkrichtung(Punkt_Objekt punktObjekt, DirectedEdge<TOP_Kante, ?, Punkt_Objekt> edge) {
        return ENUMWirkrichtungExtensions.isInWirkrichtung(PunktObjektExtensions.getWirkrichtung(punktObjekt, (TOP_Kante)edge.getElement()), edge.isForwards());
    }

    public static Punkt_Objekt_TOP_Kante_AttributeGroup getSinglePoint(Punkt_Objekt punktObjekt) {
        return CollectionExtensions.getUnique(PunktObjektExtensions.getSinglePoints(punktObjekt));
    }

    public static List<Punkt_Objekt_TOP_Kante_AttributeGroup> getSinglePoints(Punkt_Objekt punktObjekt) {
        return punktObjekt.getPunktObjektTOPKante();
    }

    public static boolean isGrenzzeichen(Punkt_Objekt punktObjekt) {
        if (punktObjekt instanceof Signal) {
            return SignalExtensions.hasSignalbegriffID((Signal)punktObjekt, Ra12.class);
        }
        return false;
    }

    public static Coordinate getCoordinate(Punkt_Objekt punktObjekt) {
        return PunktObjektTopKanteExtensions.getCoordinate(PunktObjektExtensions.getSinglePoints(punktObjekt).get(0)).getGeometricInformation();
    }

    public static double rotation(Punkt_Objekt object) {
        ENUMWirkrichtung direction;
        Punkt_Objekt_TOP_Kante_AttributeGroup point = PunktObjektExtensions.getSinglePoints(object).get(0);
        Wirkrichtung_TypeClass _wirkrichtung = point.getWirkrichtung();
        ENUMWirkrichtung _wert = null;
        if (_wirkrichtung != null) {
            _wert = _wirkrichtung.getWert();
        }
        if ((direction = _wert) == null) {
            direction = ENUMWirkrichtung.ENUM_WIRKRICHTUNG_IN;
        }
        return PunktObjektTopKanteExtensions.getCoordinate(point, direction).getRotation();
    }
}

