/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.set.ppmodel.extensions;

import com.google.common.base.Objects;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.set.basis.geometry.GeometryException;
import org.eclipse.set.basis.graph.Digraph;
import org.eclipse.set.basis.graph.Digraphs;
import org.eclipse.set.basis.graph.DirectedEdgePath;
import org.eclipse.set.ppmodel.extensions.BasisAttributExtensions;
import org.eclipse.set.ppmodel.extensions.GeoPunktExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektExtensions;
import org.eclipse.set.ppmodel.extensions.PunktObjektTopKanteExtensions;
import org.eclipse.set.ppmodel.extensions.UnterbringungExtensions;
import org.eclipse.set.ppmodel.extensions.utils.Debug;
import org.eclipse.set.ppmodel.extensions.utils.TopGraph;
import org.eclipse.set.toolboxmodel.Ansteuerung_Element.Unterbringung;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt;
import org.eclipse.set.toolboxmodel.Basisobjekte.Punkt_Objekt_TOP_Kante_AttributeGroup;
import org.eclipse.set.toolboxmodel.Geodaten.GEO_Punkt;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Kante;
import org.eclipse.set.toolboxmodel.Geodaten.TOP_Knoten;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.locationtech.jts.geom.Coordinate;

public class DistanceExtensions {
    public static double distance(EObject object1, EObject object2) {
        return DistanceExtensions.distance(object1, object2, MeasuringStrategy.NONE);
    }

    public static double distance(EObject object1, EObject object2, MeasuringStrategy strategy) {
        return DistanceExtensions.distanceDispatch(object1, object2, strategy);
    }

    private static double _distanceDispatch(EObject object1, EObject object2, MeasuringStrategy strategy) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Distance cannot be obtained for types ");
        String _name = object1.getClass().getName();
        _builder.append(_name);
        _builder.append(", ");
        String _name_1 = object2.getClass().getName();
        _builder.append(_name_1);
        throw new IllegalArgumentException(_builder.toString());
    }

    private static double _distanceDispatch(Punkt_Objekt object1, Punkt_Objekt object2, MeasuringStrategy strategy) {
        Iterable _tOPKante = BasisAttributExtensions.getContainer((EObject)object1).getTOPKante();
        TopGraph topGraph = new TopGraph(_tOPKante);
        Set paths = Digraphs.getPaths((Digraph)topGraph, PunktObjektExtensions.getSinglePoints(object1), PunktObjektExtensions.getSinglePoints(object2));
        boolean _isEmpty = paths.isEmpty();
        if (_isEmpty) {
            boolean _equals = Objects.equal((Object)((Object)strategy), (Object)((Object)MeasuringStrategy.USE_BEELINE_IF_ROUTING_FAILS));
            if (_equals) {
                return DistanceExtensions.distanceBeeline((EObject)object1, (EObject)object2);
            }
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("No path from ");
            String _debugString = Debug.debugString(object1);
            _builder.append(_debugString);
            _builder.append(" to ");
            String _debugString_1 = Debug.debugString(object2);
            _builder.append(_debugString_1);
            throw new IllegalArgumentException(_builder.toString());
        }
        Functions.Function2<Double, DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Double> _function = new Functions.Function2<Double, DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Double>(){

            public Double apply(Double d, DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> p) {
                return Math.min(d, p.getLength());
            }
        };
        return (Double)IterableExtensions.fold((Iterable)paths, (Object)Double.MAX_VALUE, (Functions.Function2)_function);
    }

    private static double _distanceDispatch(Punkt_Objekt punktObjekt, Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint, MeasuringStrategy strategy) {
        Iterable _tOPKante = BasisAttributExtensions.getContainer((EObject)punktObjekt).getTOPKante();
        TopGraph topGraph = new TopGraph(_tOPKante);
        Set paths = Digraphs.getPaths((Digraph)topGraph, PunktObjektExtensions.getSinglePoints(punktObjekt), Collections.unmodifiableSet(CollectionLiterals.newHashSet((Object[])new Punkt_Objekt_TOP_Kante_AttributeGroup[]{singlePoint})));
        boolean _isEmpty = paths.isEmpty();
        if (_isEmpty) {
            boolean _equals = Objects.equal((Object)((Object)strategy), (Object)((Object)MeasuringStrategy.USE_BEELINE_IF_ROUTING_FAILS));
            if (_equals) {
                return DistanceExtensions.distanceBeeline((EObject)punktObjekt, (EObject)singlePoint);
            }
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("No path from ");
            String _debugString = Debug.debugString(punktObjekt);
            _builder.append(_debugString);
            _builder.append(" to ");
            String _debugString_1 = Debug.debugString(singlePoint);
            _builder.append(_debugString_1);
            throw new IllegalArgumentException(_builder.toString());
        }
        Functions.Function2<Double, DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Double> _function = new Functions.Function2<Double, DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Double>(){

            public Double apply(Double d, DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> p) {
                return Math.min(d, p.getLength());
            }
        };
        return (Double)IterableExtensions.fold((Iterable)paths, (Object)Double.MAX_VALUE, (Functions.Function2)_function);
    }

    private static double _distanceDispatch(Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint, Punkt_Objekt punktObjekt, MeasuringStrategy strategy) {
        return DistanceExtensions.distanceDispatch((EObject)punktObjekt, (EObject)singlePoint, strategy);
    }

    private static double _distanceDispatch(Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint1, Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint2, MeasuringStrategy strategy) {
        Iterable _tOPKante = BasisAttributExtensions.getContainer((EObject)PunktObjektTopKanteExtensions.getPunktObjekt(singlePoint1)).getTOPKante();
        TopGraph topGraph = new TopGraph(_tOPKante);
        Set paths = Digraphs.getPaths((Digraph)topGraph, (Object)singlePoint1, (Object)singlePoint2);
        boolean _isEmpty = paths.isEmpty();
        if (_isEmpty) {
            boolean _equals = Objects.equal((Object)((Object)strategy), (Object)((Object)MeasuringStrategy.USE_BEELINE_IF_ROUTING_FAILS));
            if (_equals) {
                return DistanceExtensions.distanceBeeline((EObject)singlePoint1, (EObject)singlePoint2);
            }
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("No path from ");
            String _debugString = Debug.debugString(singlePoint1);
            _builder.append(_debugString);
            _builder.append(" to ");
            String _debugString_1 = Debug.debugString(singlePoint2);
            _builder.append(_debugString_1);
            throw new IllegalArgumentException(_builder.toString());
        }
        Functions.Function2<Double, DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Double> _function = new Functions.Function2<Double, DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup>, Double>(){

            public Double apply(Double d, DirectedEdgePath<TOP_Kante, TOP_Knoten, Punkt_Objekt_TOP_Kante_AttributeGroup> p) {
                return Math.min(d, p.getLength());
            }
        };
        return (Double)IterableExtensions.fold((Iterable)paths, (Object)Double.MAX_VALUE, (Functions.Function2)_function);
    }

    private static double _distanceDispatch(Punkt_Objekt punktObjekt, Unterbringung unterbringung, MeasuringStrategy strategy) {
        boolean _tripleNotEquals;
        Punkt_Objekt_TOP_Kante_AttributeGroup _punktObjektTOPKante = unterbringung.getPunktObjektTOPKante();
        boolean bl = _tripleNotEquals = _punktObjektTOPKante != null;
        if (_tripleNotEquals) {
            return DistanceExtensions.distanceDispatch((EObject)punktObjekt, (EObject)unterbringung.getPunktObjektTOPKante(), strategy);
        }
        return DistanceExtensions.distanceBeeline((EObject)punktObjekt, (EObject)UnterbringungExtensions.getGeoPunkt(unterbringung));
    }

    private static double _distanceDispatch(Unterbringung unterbringung, Punkt_Objekt punktObjekt, MeasuringStrategy strategy) {
        return DistanceExtensions.distanceDispatch((EObject)punktObjekt, (EObject)unterbringung, strategy);
    }

    private static double _distanceDispatch(GEO_Punkt geoPunkt1, GEO_Punkt geoPunkt2, MeasuringStrategy strategy) {
        try {
            Coordinate c1 = GeoPunktExtensions.getCoordinate(geoPunkt1);
            Coordinate c2 = GeoPunktExtensions.getCoordinate(geoPunkt2);
            return c1.distance(c2);
        }
        catch (Throwable _t) {
            if (_t instanceof GeometryException) {
                GeometryException e = (GeometryException)_t;
                throw new IllegalArgumentException((Throwable)e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private static double _distanceBeeline(EObject object1, EObject object2) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Distance cannot be obtained for types ");
        String _name = object1.getClass().getName();
        _builder.append(_name);
        _builder.append(", ");
        String _name_1 = object2.getClass().getName();
        _builder.append(_name_1);
        throw new IllegalArgumentException(_builder.toString());
    }

    private static double _distanceBeeline(Punkt_Objekt punktObjekt1, Punkt_Objekt punktObjekt2) {
        try {
            Coordinate c1 = PunktObjektExtensions.getCoordinate(punktObjekt1);
            Coordinate c2 = PunktObjektExtensions.getCoordinate(punktObjekt2);
            return c1.distance(c2);
        }
        catch (Throwable _t) {
            if (_t instanceof GeometryException) {
                GeometryException e = (GeometryException)_t;
                throw new IllegalArgumentException((Throwable)e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private static double _distanceBeeline(Punkt_Objekt punktObjekt, GEO_Punkt geoPunkt) {
        try {
            Coordinate c1 = PunktObjektExtensions.getCoordinate(punktObjekt);
            Coordinate c2 = GeoPunktExtensions.getCoordinate(geoPunkt);
            return c1.distance(c2);
        }
        catch (Throwable _t) {
            if (_t instanceof GeometryException) {
                GeometryException e = (GeometryException)_t;
                throw new IllegalArgumentException((Throwable)e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private static double _distanceBeeline(GEO_Punkt geoPunkt, Punkt_Objekt punktObjekt) {
        return DistanceExtensions.distanceBeeline((EObject)punktObjekt, (EObject)geoPunkt);
    }

    private static double _distanceBeeline(Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint1, Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint2) {
        try {
            Coordinate c1 = PunktObjektTopKanteExtensions.getCoordinate(singlePoint1).getGeometricInformation();
            Coordinate c2 = PunktObjektTopKanteExtensions.getCoordinate(singlePoint2).getGeometricInformation();
            return c1.distance(c2);
        }
        catch (Throwable _t) {
            if (_t instanceof GeometryException) {
                GeometryException e = (GeometryException)_t;
                throw new IllegalArgumentException((Throwable)e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private static double _distanceBeeline(Punkt_Objekt punktObjekt, Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint) {
        try {
            Coordinate c1 = PunktObjektExtensions.getCoordinate(punktObjekt);
            Coordinate c2 = PunktObjektTopKanteExtensions.getCoordinate(singlePoint).getGeometricInformation();
            return c1.distance(c2);
        }
        catch (Throwable _t) {
            if (_t instanceof GeometryException) {
                GeometryException e = (GeometryException)_t;
                throw new IllegalArgumentException((Throwable)e);
            }
            throw Exceptions.sneakyThrow((Throwable)_t);
        }
    }

    private static double _distanceBeeline(Punkt_Objekt_TOP_Kante_AttributeGroup singlePoint, Punkt_Objekt punktObjekt) {
        return DistanceExtensions.distanceBeeline((EObject)punktObjekt, (EObject)singlePoint);
    }

    private static double distanceDispatch(EObject unterbringung, EObject punktObjekt, MeasuringStrategy strategy) {
        if (unterbringung instanceof Unterbringung && punktObjekt instanceof Punkt_Objekt) {
            return DistanceExtensions._distanceDispatch((Unterbringung)unterbringung, (Punkt_Objekt)punktObjekt, strategy);
        }
        if (unterbringung instanceof Punkt_Objekt && punktObjekt instanceof Unterbringung) {
            return DistanceExtensions._distanceDispatch((Punkt_Objekt)unterbringung, (Unterbringung)punktObjekt, strategy);
        }
        if (unterbringung instanceof Punkt_Objekt && punktObjekt instanceof Punkt_Objekt) {
            return DistanceExtensions._distanceDispatch((Punkt_Objekt)unterbringung, (Punkt_Objekt)punktObjekt, strategy);
        }
        if (unterbringung instanceof GEO_Punkt && punktObjekt instanceof GEO_Punkt) {
            return DistanceExtensions._distanceDispatch((GEO_Punkt)unterbringung, (GEO_Punkt)punktObjekt, strategy);
        }
        if (unterbringung instanceof Punkt_Objekt && punktObjekt instanceof Punkt_Objekt_TOP_Kante_AttributeGroup) {
            return DistanceExtensions._distanceDispatch((Punkt_Objekt)unterbringung, (Punkt_Objekt_TOP_Kante_AttributeGroup)punktObjekt, strategy);
        }
        if (unterbringung instanceof Punkt_Objekt_TOP_Kante_AttributeGroup && punktObjekt instanceof Punkt_Objekt) {
            return DistanceExtensions._distanceDispatch((Punkt_Objekt_TOP_Kante_AttributeGroup)unterbringung, (Punkt_Objekt)punktObjekt, strategy);
        }
        if (unterbringung instanceof Punkt_Objekt_TOP_Kante_AttributeGroup && punktObjekt instanceof Punkt_Objekt_TOP_Kante_AttributeGroup) {
            return DistanceExtensions._distanceDispatch((Punkt_Objekt_TOP_Kante_AttributeGroup)unterbringung, (Punkt_Objekt_TOP_Kante_AttributeGroup)punktObjekt, strategy);
        }
        if (unterbringung != null && punktObjekt != null) {
            return DistanceExtensions._distanceDispatch(unterbringung, punktObjekt, strategy);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(new Object[]{unterbringung, punktObjekt, strategy}).toString());
    }

    private static double distanceBeeline(EObject punktObjekt1, EObject punktObjekt2) {
        if (punktObjekt1 instanceof Punkt_Objekt && punktObjekt2 instanceof Punkt_Objekt) {
            return DistanceExtensions._distanceBeeline((Punkt_Objekt)punktObjekt1, (Punkt_Objekt)punktObjekt2);
        }
        if (punktObjekt1 instanceof Punkt_Objekt && punktObjekt2 instanceof GEO_Punkt) {
            return DistanceExtensions._distanceBeeline((Punkt_Objekt)punktObjekt1, (GEO_Punkt)punktObjekt2);
        }
        if (punktObjekt1 instanceof GEO_Punkt && punktObjekt2 instanceof Punkt_Objekt) {
            return DistanceExtensions._distanceBeeline((GEO_Punkt)punktObjekt1, (Punkt_Objekt)punktObjekt2);
        }
        if (punktObjekt1 instanceof Punkt_Objekt && punktObjekt2 instanceof Punkt_Objekt_TOP_Kante_AttributeGroup) {
            return DistanceExtensions._distanceBeeline((Punkt_Objekt)punktObjekt1, (Punkt_Objekt_TOP_Kante_AttributeGroup)punktObjekt2);
        }
        if (punktObjekt1 instanceof Punkt_Objekt_TOP_Kante_AttributeGroup && punktObjekt2 instanceof Punkt_Objekt) {
            return DistanceExtensions._distanceBeeline((Punkt_Objekt_TOP_Kante_AttributeGroup)punktObjekt1, (Punkt_Objekt)punktObjekt2);
        }
        if (punktObjekt1 instanceof Punkt_Objekt_TOP_Kante_AttributeGroup && punktObjekt2 instanceof Punkt_Objekt_TOP_Kante_AttributeGroup) {
            return DistanceExtensions._distanceBeeline((Punkt_Objekt_TOP_Kante_AttributeGroup)punktObjekt1, (Punkt_Objekt_TOP_Kante_AttributeGroup)punktObjekt2);
        }
        if (punktObjekt1 != null && punktObjekt2 != null) {
            return DistanceExtensions._distanceBeeline(punktObjekt1, punktObjekt2);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(punktObjekt1, punktObjekt2).toString());
    }

    public static enum MeasuringStrategy {
        NONE,
        USE_BEELINE_IF_ROUTING_FAILS;

    }
}

